/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.view.PercentageRecord;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/coverage/view/PercentageParser;", "", "<init>", "()V", "parse", "Lcom/intellij/coverage/view/PercentageRecord;", "s", "", "safeParseDouble", "", "intellij.platform.coverage"})
@ApiStatus.Internal
public final class PercentageParser {
    @NotNull
    public static final PercentageParser INSTANCE = new PercentageParser();

    private PercentageParser() {
    }

    @JvmStatic
    @NotNull
    public static final PercentageRecord parse(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int percentIndex = StringsKt.indexOf$default((CharSequence)s, (char)'%', (int)0, (boolean)false, (int)6, null);
        if (percentIndex < 0) {
            return PercentageRecord.Companion.getEMPTY$intellij_platform_coverage();
        }
        String string = s.substring(0, percentIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        double percent = PercentageParser.safeParseDouble(string);
        int openBraceIndex = StringsKt.indexOf$default((CharSequence)s, (char)'(', (int)percentIndex, (boolean)false, (int)4, null);
        if (openBraceIndex < 0) {
            return new PercentageRecord(percent, null, null);
        }
        int slashIndex = StringsKt.indexOf$default((CharSequence)s, (char)'/', (int)openBraceIndex, (boolean)false, (int)4, null);
        if (slashIndex < 0) {
            return new PercentageRecord(percent, null, null);
        }
        int closingBraceIndex = StringsKt.indexOf$default((CharSequence)s, (char)')', (int)slashIndex, (boolean)false, (int)4, null);
        if (closingBraceIndex < 0) {
            return new PercentageRecord(percent, null, null);
        }
        String string2 = s.substring(openBraceIndex + 1, slashIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int covered = (int)PercentageParser.safeParseDouble(string2);
        String string3 = s.substring(slashIndex + 1, closingBraceIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        int total = (int)PercentageParser.safeParseDouble(string3);
        return new PercentageRecord(percent, covered, total);
    }

    @JvmStatic
    public static final double safeParseDouble(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            double d;
            int begin = 0;
            int end = -1;
            int i = s.length();
            while (--i >= 0) {
                boolean isDigit;
                char c = s.charAt(i);
                boolean bl = isDigit = ('0' <= c ? c < ':' : false) || c == '.';
                if (isDigit) {
                    if (end == -1) {
                        end = i + 1;
                    }
                    begin = i;
                    continue;
                }
                if (end == -1) continue;
            }
            if (end == -1) {
                return 0.0;
            }
            try {
                String string = s.substring(begin, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException e1) {
                d = 0.0;
            }
            return d;
        }
    }
}

