/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.html.attributes;

import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.PolySymbolModifier;
import com.intellij.polySymbols.PolySymbolProperty;
import com.intellij.polySymbols.html.HtmlSymbolKinds;
import com.intellij.polySymbols.html.PolySymbolHtmlAttributeValue;
import com.intellij.polySymbols.html.StandardHtmlSymbol;
import com.intellij.polySymbols.query.PolySymbolListSymbolsQueryParams;
import com.intellij.polySymbols.query.PolySymbolQueryStack;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.html.HtmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001BB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J(\u0010.\u001a\u0004\u0018\u0001H/\"\b\b\u0000\u0010/*\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/02H\u0096\u0002\u00a2\u0006\u0002\u00103J&\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00000<H\u0016J\u0014\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u000100H\u0096\u0082\u0004J\n\u0010@\u001a\u00020AH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001aR\u0016\u0010&\u001a\u0004\u0018\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006C"}, d2={"Lcom/intellij/polySymbols/html/attributes/HtmlAttributeDescriptorBasedSymbol;", "Lcom/intellij/polySymbols/html/StandardHtmlSymbol;", "descriptor", "Lcom/intellij/xml/XmlAttributeDescriptor;", "tag", "Lcom/intellij/psi/html/HtmlTag;", "tagName", "", "<init>", "(Lcom/intellij/xml/XmlAttributeDescriptor;Lcom/intellij/psi/html/HtmlTag;Ljava/lang/String;)V", "(Lcom/intellij/xml/XmlAttributeDescriptor;Lcom/intellij/psi/html/HtmlTag;)V", "(Lcom/intellij/xml/XmlAttributeDescriptor;Ljava/lang/String;)V", "getDescriptor", "()Lcom/intellij/xml/XmlAttributeDescriptor;", "getMdnDocumentation", "Lcom/intellij/documentation/mdn/MdnSymbolDocumentation;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "name", "getName", "()Ljava/lang/String;", "priority", "Lcom/intellij/polySymbols/PolySymbol$Priority;", "getPriority", "()Lcom/intellij/polySymbols/PolySymbol$Priority;", "modifiers", "", "Lcom/intellij/polySymbols/PolySymbolModifier;", "getModifiers", "()Ljava/util/Set;", "defaultValue", "getDefaultValue", "source", "Lcom/intellij/psi/PsiElement;", "getSource", "()Lcom/intellij/psi/PsiElement;", "attributeValue", "Lcom/intellij/polySymbols/html/PolySymbolHtmlAttributeValue;", "getAttributeValue", "()Lcom/intellij/polySymbols/html/PolySymbolHtmlAttributeValue;", "get", "T", "", "property", "Lcom/intellij/polySymbols/PolySymbolProperty;", "(Lcom/intellij/polySymbols/PolySymbolProperty;)Ljava/lang/Object;", "getSymbols", "", "Lcom/intellij/polySymbols/PolySymbol;", "params", "Lcom/intellij/polySymbols/query/PolySymbolListSymbolsQueryParams;", "stack", "Lcom/intellij/polySymbols/query/PolySymbolQueryStack;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "hashCode", "", "HtmlAttributeValueSymbol", "intellij.xml.psi.impl"})
@SourceDebugExtension(value={"SMAP\nHtmlAttributeDescriptorBasedSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlAttributeDescriptorBasedSymbol.kt\ncom/intellij/polySymbols/html/attributes/HtmlAttributeDescriptorBasedSymbol\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n11705#2:138\n12052#2,3:139\n1#3:142\n*S KotlinDebug\n*F\n+ 1 HtmlAttributeDescriptorBasedSymbol.kt\ncom/intellij/polySymbols/html/attributes/HtmlAttributeDescriptorBasedSymbol\n*L\n97#1:138\n97#1:139,3\n*E\n"})
public final class HtmlAttributeDescriptorBasedSymbol
extends StandardHtmlSymbol {
    @NotNull
    private final XmlAttributeDescriptor descriptor;
    @Nullable
    private final HtmlTag tag;
    @NotNull
    private final String tagName;
    @NotNull
    private final String name;

    private HtmlAttributeDescriptorBasedSymbol(XmlAttributeDescriptor descriptor, HtmlTag tag, String tagName) {
        this.descriptor = descriptor;
        this.tag = tag;
        this.tagName = tagName;
        String string = this.descriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
    }

    @NotNull
    public final XmlAttributeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public HtmlAttributeDescriptorBasedSymbol(@NotNull XmlAttributeDescriptor descriptor, @NotNull HtmlTag tag) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String string = tag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this(descriptor, tag, string);
    }

    public HtmlAttributeDescriptorBasedSymbol(@NotNull XmlAttributeDescriptor descriptor, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        this(descriptor, null, tagName);
    }

    @Override
    @Nullable
    protected MdnSymbolDocumentation getMdnDocumentation() {
        HtmlTag htmlTag = this.tag;
        return MdnDocumentationKt.getHtmlMdnAttributeDocumentation(MdnDocumentationKt.getHtmlApiNamespace(htmlTag != null ? htmlTag.getNamespace() : null, (PsiElement)this.tag, this.tagName), this.tagName, this.getName());
    }

    @Override
    @Nullable
    public Project getProject() {
        Object object = this.tag;
        if (object == null || (object = object.getProject()) == null) {
            PsiElement psiElement = this.descriptor.getDeclaration();
            object = psiElement != null ? psiElement.getProject() : null;
        }
        return object;
    }

    @NotNull
    public PolySymbolKind getKind() {
        return HtmlSymbolKinds.HTML_ATTRIBUTES;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public PolySymbol.Priority getPriority() {
        return PolySymbol.Priority.LOW;
    }

    @NotNull
    public Set<PolySymbolModifier> getModifiers() {
        return SetsKt.setOf((Object)(this.descriptor.isRequired() ? PolySymbolModifier.REQUIRED : PolySymbolModifier.OPTIONAL));
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.descriptor.getDefaultValue();
    }

    @Nullable
    public PsiElement getSource() {
        return this.descriptor.getDeclaration();
    }

    @NotNull
    public final PolySymbolHtmlAttributeValue getAttributeValue() {
        boolean isBooleanAttribute = HtmlUtil.isBooleanAttribute(this.descriptor, null);
        return PolySymbolHtmlAttributeValue.Companion.create(null, isBooleanAttribute ? PolySymbolHtmlAttributeValue.Type.BOOLEAN : (this.descriptor.isEnumerated() ? PolySymbolHtmlAttributeValue.Type.ENUM : PolySymbolHtmlAttributeValue.Type.STRING), Boolean.valueOf(!isBooleanAttribute), this.descriptor.getDefaultValue(), null);
    }

    @Nullable
    public <T> T get(@NotNull PolySymbolProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return (T)(Intrinsics.areEqual(property, (Object)HtmlSymbolKinds.PROP_HTML_ATTRIBUTE_VALUE) ? property.tryCast((Object)this.getAttributeValue()) : super.get(property));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PolySymbol> getSymbols(@NotNull PolySymbolKind kind, @NotNull PolySymbolListSymbolsQueryParams params, @NotNull PolySymbolQueryStack stack) {
        List list;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (Intrinsics.areEqual((Object)kind, (Object)HtmlSymbolKinds.HTML_ATTRIBUTE_VALUES) && this.descriptor.isEnumerated()) {
            String[] stringArray = this.descriptor.getEnumeratedValues();
            if (stringArray != null) {
                void $this$mapTo$iv$iv;
                String[] $this$map$iv = stringArray;
                boolean $i$f$map = false;
                String[] stringArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(new HtmlAttributeValueSymbol((String)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public Pointer<HtmlAttributeDescriptorBasedSymbol> createPointer() {
        XmlAttributeDescriptor descriptor = this.descriptor;
        HtmlTag htmlTag = this.tag;
        SmartPsiElementPointer tagPtr = htmlTag != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)htmlTag)) : null;
        String tagName = this.tagName;
        return () -> HtmlAttributeDescriptorBasedSymbol.createPointer$lambda$0(tagPtr, descriptor, tagName);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof HtmlAttributeDescriptorBasedSymbol && Intrinsics.areEqual((Object)((HtmlAttributeDescriptorBasedSymbol)other).tag, (Object)this.tag) && Intrinsics.areEqual((Object)((HtmlAttributeDescriptorBasedSymbol)other).descriptor, (Object)this.descriptor) && Intrinsics.areEqual((Object)((HtmlAttributeDescriptorBasedSymbol)other).tagName, (Object)this.tagName);
    }

    public int hashCode() {
        int result = 31;
        result = 31 * result + this.descriptor.hashCode();
        HtmlTag htmlTag = this.tag;
        result = 31 * result + (htmlTag != null ? htmlTag.hashCode() : 0);
        result = 31 * result + this.tagName.hashCode();
        return result;
    }

    private static final HtmlAttributeDescriptorBasedSymbol createPointer$lambda$0(SmartPsiElementPointer $tagPtr, XmlAttributeDescriptor $descriptor, String $tagName) {
        HtmlTag htmlTag;
        SmartPsiElementPointer smartPsiElementPointer = $tagPtr;
        if (smartPsiElementPointer != null) {
            SmartPsiElementPointer it = smartPsiElementPointer;
            boolean bl = false;
            htmlTag = (HtmlTag)it.dereference();
            if (htmlTag == null) {
                return null;
            }
        } else {
            htmlTag = null;
        }
        HtmlTag tag = htmlTag;
        return new HtmlAttributeDescriptorBasedSymbol($descriptor, tag, $tagName);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000eH\u0016R\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/polySymbols/html/attributes/HtmlAttributeDescriptorBasedSymbol$HtmlAttributeValueSymbol;", "Lcom/intellij/polySymbols/PolySymbol;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "createPointer", "Lcom/intellij/model/Pointer;", "intellij.xml.psi.impl"})
    private static final class HtmlAttributeValueSymbol
    implements PolySymbol {
        @NotNull
        private final String name;

        public HtmlAttributeValueSymbol(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public PolySymbolKind getKind() {
            return HtmlSymbolKinds.HTML_ATTRIBUTE_VALUES;
        }

        @NotNull
        public Pointer<HtmlAttributeValueSymbol> createPointer() {
            Pointer pointer = Pointer.hardPointer((Object)this);
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
            return pointer;
        }
    }
}

