/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class InspectionProfileWrapper {
    private static final Logger LOG = Logger.getInstance(InspectionProfileWrapper.class);
    private static final Key<Function<? super InspectionProfile, ? extends InspectionProfileWrapper>> CUSTOMIZATION_KEY = Key.create((String)"Inspection Profile Wrapper Customization");
    public static final Key<Map<Class<? extends PsiElement>, Set<PsiElement>>> PSI_ELEMENTS_BEING_COMMITTED = Key.create((String)"PsiElements that are being committed");
    private static boolean alreadyChecked;
    private static boolean runDuplicateCheck;
    protected final InspectionProfile myProfile;
    protected final InspectionProfileManager myProfileManager;

    public InspectionProfileWrapper(@NotNull InspectionProfileImpl profile) {
        if (profile == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(0);
        }
        this.myProfile = profile;
        this.myProfileManager = profile.getProfileManager();
    }

    public InspectionProfileWrapper(@NotNull InspectionProfile profile, @NotNull InspectionProfileManager profileManager) {
        if (profile == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(1);
        }
        if (profileManager == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(2);
        }
        this.myProfile = profile;
        this.myProfileManager = profileManager;
    }

    public InspectionProfileManager getProfileManager() {
        return this.myProfileManager;
    }

    public static void checkInspectionsDuplicates(@NotNull List<? extends InspectionToolWrapper<?, ?>> toolWrappers) {
        if (toolWrappers == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(3);
        }
        if (!runDuplicateCheck || alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        HashSet<InspectionProfileEntry> uniqueTools = new HashSet<InspectionProfileEntry>(toolWrappers.size());
        for (InspectionToolWrapper<?, ?> toolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            if (uniqueTools.add(toolWrapper.getTool())) continue;
            LOG.error("Inspection " + toolWrapper.getDisplayName() + " (" + String.valueOf(toolWrapper.getTool().getClass()) + ") already registered");
        }
    }

    public boolean isToolEnabled(@Nullable HighlightDisplayKey key, PsiElement element) {
        return this.myProfile.isToolEnabled(key, element);
    }

    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        if (inspectionToolKey == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(4);
        }
        HighlightDisplayLevel highlightDisplayLevel = this.myProfile.getErrorLevel(inspectionToolKey, element);
        if (highlightDisplayLevel == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(5);
        }
        return highlightDisplayLevel;
    }

    public InspectionToolWrapper<?, ?> getInspectionTool(@NotNull String shortName, @Nullable PsiElement element) {
        if (shortName == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(6);
        }
        return this.myProfile.getInspectionTool(shortName, element);
    }

    @NotNull
    public InspectionProfile getInspectionProfile() {
        InspectionProfile inspectionProfile = this.myProfile;
        if (inspectionProfile == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(7);
        }
        return inspectionProfile;
    }

    public static void runWithCustomInspectionWrapper(@NotNull PsiFile file, @NotNull Function<? super InspectionProfile, ? extends InspectionProfileWrapper> customizer, @NotNull Runnable runnable) {
        if (file == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(8);
        }
        if (customizer == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(9);
        }
        if (runnable == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(10);
        }
        file.putUserData(CUSTOMIZATION_KEY, customizer);
        try {
            runnable.run();
        }
        finally {
            file.putUserData(CUSTOMIZATION_KEY, null);
        }
    }

    public static Function<? super InspectionProfile, ? extends InspectionProfileWrapper> getCustomInspectionProfileWrapper(@NotNull PsiFile file) {
        if (file == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(11);
        }
        return (Function)file.getUserData(CUSTOMIZATION_KEY);
    }

    @Deprecated
    public static void setCustomInspectionProfileWrapperTemporarily(@NotNull PsiFile file, @NotNull Function<? super InspectionProfile, ? extends InspectionProfileWrapper> function) {
        if (file == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(12);
        }
        if (function == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(13);
        }
        file.putUserData(CUSTOMIZATION_KEY, function);
    }

    @TestOnly
    @ApiStatus.Internal
    public static void runWithNoDuplicateCheckInTests(@NotNull Runnable runnable) {
        if (runnable == null) {
            InspectionProfileWrapper.$$$reportNull$$$0(14);
        }
        runDuplicateCheck = false;
        try {
            runnable.run();
        }
        finally {
            runDuplicateCheck = true;
        }
    }

    static {
        runDuplicateCheck = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolKey";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionProfileWrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionProfileWrapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorLevel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkInspectionsDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorLevel";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTool";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithCustomInspectionWrapper";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomInspectionProfileWrapper";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCustomInspectionProfileWrapperTemporarily";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runWithNoDuplicateCheckInTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

