/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\u00020\u0005\"\u0004\b\u0000\u0010\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\n\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\n0\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0014\u0010\u0015\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/IndexDataPresenter;", "", "<init>", "()V", "getPresentableIndexKey", "", "K", "key", "(Ljava/lang/Object;)Ljava/lang/String;", "getPresentableIndexValue", "V", "value", "getPresentableSerializedStubTree", "Lcom/intellij/psi/stubs/SerializedStubTree;", "getPresentableKeyValueMap", "keyValueMap", "", "getPresentableStub", "node", "Lcom/intellij/psi/stubs/Stub;", "indent", "withIndent", "intellij.platform.indexing.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIndexDataPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexDataPresenter.kt\ncom/intellij/util/indexing/IndexDataPresenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1068#2:86\n1068#2:87\n1586#2:88\n1661#2,3:89\n*S KotlinDebug\n*F\n+ 1 IndexDataPresenter.kt\ncom/intellij/util/indexing/IndexDataPresenter\n*L\n41#1:86\n43#1:87\n44#1:88\n44#1:89,3\n*E\n"})
public final class IndexDataPresenter {
    @NotNull
    public static final IndexDataPresenter INSTANCE = new IndexDataPresenter();

    private IndexDataPresenter() {
    }

    @NotNull
    public final <K> String getPresentableIndexKey(K key) {
        return String.valueOf(key);
    }

    @NotNull
    public final <V> String getPresentableIndexValue(@Nullable V value) {
        String string;
        V v = value;
        if (v == null) {
            string = "<no value>";
        } else if (v instanceof SerializedStubTree) {
            string = this.getPresentableSerializedStubTree((SerializedStubTree)value);
        } else if (v instanceof ByteArraySequence) {
            String string2 = Base64.getEncoder().encodeToString(((ByteArraySequence)value).toBytes());
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = value.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPresentableSerializedStubTree(@NotNull SerializedStubTree value) {
        StringBuilder stringBuilder;
        block5: {
            Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            StringBuilder $this$getPresentableSerializedStubTree_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getPresentableSerializedStubTree_u24lambda_u240.append("Stub tree:").append('\n');
            StringBuilder stringBuilder2 = $this$getPresentableSerializedStubTree_u24lambda_u240;
            Stub stub = value.getStub();
            Intrinsics.checkNotNullExpressionValue((Object)stub, (String)"getStub(...)");
            stringBuilder2.append(INSTANCE.getPresentableStub(stub, "  ")).append('\n');
            try {
                map = value.getStubIndicesValueMap();
                Intrinsics.checkNotNull(map);
            }
            catch (Exception e) {
                $this$getPresentableSerializedStubTree_u24lambda_u240.append("Failed-to-read stub tree forward index: (message = " + e.getMessage() + ") (exception class = " + e.getClass().getSimpleName() + ")").append('\n');
                break block5;
            }
            Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> stubIndicesValueMap = map;
            $this$getPresentableSerializedStubTree_u24lambda_u240.append("Stub tree forward index:").append('\n');
            Iterable $this$sortedBy$iv = stubIndicesValueMap.entrySet();
            boolean $i$f$sortedBy = false;
            for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((StubIndexKey)it.getKey()).getName());
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((StubIndexKey)it.getKey()).getName())));
                }
            })) {
                StubIndexKey stubIndexKey = (StubIndexKey)entry.getKey();
                Map stubIndexValues = (Map)entry.getValue();
                $this$getPresentableSerializedStubTree_u24lambda_u240.append("    " + stubIndexKey.getName()).append('\n');
                Iterable $this$sortedBy$iv2 = stubIndexValues.entrySet();
                boolean $i$f$sortedBy2 = false;
                for (Map.Entry entry2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getKey().toString());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey().toString())));
                    }
                })) {
                    void $this$mapTo$iv$iv;
                    Object key = entry2.getKey();
                    StubIdList stubIdList = (StubIdList)entry2.getValue();
                    Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)stubIdList.size());
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(stubIdList.get((int)it));
                    }
                    List stubIds = (List)destination$iv$iv;
                    $this$getPresentableSerializedStubTree_u24lambda_u240.append("        " + key + " -> " + CollectionsKt.joinToString$default((Iterable)stubIds, null, null, null, (int)0, null, null, (int)63, null)).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final <K, V> String getPresentableKeyValueMap(@NotNull Map<K, ? extends V> keyValueMap) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(keyValueMap, (String)"keyValueMap");
        if (keyValueMap.isEmpty()) {
            return "{empty map}";
        }
        StringBuilder $this$getPresentableKeyValueMap_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Map.Entry<K, V> entry : keyValueMap.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            $this$getPresentableKeyValueMap_u24lambda_u240.append(INSTANCE.getPresentableIndexKey(key)).append('\n');
            $this$getPresentableKeyValueMap_u24lambda_u240.append(INSTANCE.withIndent(INSTANCE.getPresentableIndexValue(value), "  ")).append('\n');
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String getPresentableStub(@NotNull Stub node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getPresentableStub(node, "");
    }

    private final String getPresentableStub(Stub node, String indent) {
        StringBuilder stringBuilder;
        StringBuilder $this$getPresentableStub_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getPresentableStub_u24lambda_u240.append(indent);
        StubElement stubElement = node instanceof StubElement ? (StubElement)node : null;
        IElementType elementType = stubElement != null ? stubElement.getElementType() : null;
        ObjectStubSerializer stubSerializer = node.getStubSerializer();
        if (elementType != null) {
            $this$getPresentableStub_u24lambda_u240.append(elementType.toString()).append(':');
        }
        if (stubSerializer != null && stubSerializer != elementType) {
            $this$getPresentableStub_u24lambda_u240.append(stubSerializer.toString()).append(':');
        }
        $this$getPresentableStub_u24lambda_u240.append(node.toString());
        if (node instanceof ObjectStubBase) {
            $this$getPresentableStub_u24lambda_u240.append(" (id = ").append(((ObjectStubBase)node).getStubId()).append(")");
        }
        for (Stub child : node.getChildrenStubs()) {
            Intrinsics.checkNotNull((Object)child);
            $this$getPresentableStub_u24lambda_u240.append(INSTANCE.getPresentableStub(child, indent + "  ")).append('\n');
        }
        return stringBuilder.toString();
    }

    private final String withIndent(String $this$withIndent, String indent) {
        return SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)$this$withIndent), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> IndexDataPresenter.withIndent$lambda$0(indent, arg_0), (int)30, null);
    }

    private static final CharSequence withIndent$lambda$0(String $indent, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $indent + it;
    }
}

