/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class FileScope
extends GlobalSearchScope
implements VirtualFileEnumeration {
    private final VirtualFile myVirtualFile;
    @Nullable
    @Nls
    private final String myDisplayName;
    private final Module myModule;

    FileScope(@NotNull Project project, @Nullable VirtualFile virtualFile, @Nullable @Nls String displayName) {
        if (project == null) {
            FileScope.$$$reportNull$$$0(0);
        }
        super(project);
        this.myVirtualFile = virtualFile;
        this.myDisplayName = displayName;
        FileIndexFacade facade = project.isDefault() ? null : FileIndexFacade.getInstance(project);
        this.myModule = virtualFile == null || facade == null ? null : facade.getModuleForFile(virtualFile);
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<VirtualFile> getFilesIfCollection() {
        Set<VirtualFile> set = Collections.singleton(this.myVirtualFile);
        if (set == null) {
            FileScope.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            FileScope.$$$reportNull$$$0(2);
        }
        return Comparing.equal((Object)((Object)this.myVirtualFile), (Object)((Object)file));
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            FileScope.$$$reportNull$$$0(3);
        }
        return aModule == this.myModule;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myModule == null;
    }

    public String toString() {
        return "File: " + (Object)((Object)this.myVirtualFile);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName != null ? this.myDisplayName : super.getDisplayName();
        if (string == null) {
            FileScope.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FileScope files = (FileScope)o;
        return Objects.equals((Object)this.myVirtualFile, (Object)files.myVirtualFile) && Objects.equals(this.myDisplayName, files.myDisplayName) && Objects.equals(this.myModule, files.myModule);
    }

    @Override
    protected int calcHashCode() {
        return Objects.hash(new Object[]{this.myVirtualFile, this.myModule, this.myDisplayName});
    }

    @Override
    public boolean contains(int fileId) {
        return this.myVirtualFile instanceof VirtualFileWithId && ((VirtualFileWithId)((Object)this.myVirtualFile)).getId() == fileId;
    }

    @Override
    public int @NotNull [] asArray() {
        int[] nArray;
        if (this.myVirtualFile instanceof VirtualFileWithId) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = ((VirtualFileWithId)((Object)this.myVirtualFile)).getId();
        } else {
            nArray = ArrayUtil.EMPTY_INT_ARRAY;
        }
        if (nArray == null) {
            FileScope.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FileScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FileScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesIfCollection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

