/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.ui.EDT;
import java.awt.EventQueue;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ThreadingAssertions {
    private static final String DOCUMENTATION_URL = "https://jb.gg/ij-platform-threading";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_READ_ACTION = "Read access is allowed from inside read-action only (see Application.runReadAction())";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String READ_ACCESS_REQUIRED_WHILE_LOCKS_ARE_FORBIDDEN = "This thread requested read access, but it does not have permission to use locks.";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String WRITE_ACCESS_REQUIRED_WHILE_LOCKS_ARE_FORBIDDEN = "This thread requested write access, but it does not have permission to use locks.";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String WRITE_INTENT_ACCESS_REQUIRED_WHILE_LOCKS_ARE_FORBIDDEN = "This thread requested write-intent access, but it does not have permission to use locks.";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_NOT_EXECUTE_IN_READ_ACTION = "Must not execute inside read action";
    private static final String MUST_EXECUTE_IN_WRITE_INTENT_READ_ACTION = "Access is allowed from write thread only";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_WRITE_ACTION = "Write access is allowed inside write-action only (see Application.runWriteAction())";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_EDT = "Access is allowed from Event Dispatch Thread (EDT) only";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_NOT_EXECUTE_IN_EDT = "Access from Event Dispatch Thread (EDT) is not allowed";
    @ApiStatus.Internal
    public static final ThreadLocal<@Nullable Consumer<Throwable>> inputEventWithoutWriteIntentLock = ThreadLocal.withInitial(() -> null);

    private ThreadingAssertions() {
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ThreadingAssertions.class);
        if (logger == null) {
            ThreadingAssertions.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void assertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt() && !EDT.isDisableEdtChecks()) {
            ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_EDT, false);
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt() && !EDT.isDisableEdtChecks()) {
            ThreadingAssertions.getLogger().error((Throwable)ThreadingAssertions.createThreadAccessException(MUST_EXECUTE_IN_EDT));
        }
    }

    public static void assertBackgroundThread() {
        if (EDT.isCurrentThreadEdt() && !EDT.isDisableEdtChecks()) {
            ThreadingAssertions.throwThreadAccessException(MUST_NOT_EXECUTE_IN_EDT, false);
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertBackgroundThread() {
        if (EDT.isCurrentThreadEdt() && !EDT.isDisableEdtChecks()) {
            ThreadingAssertions.getLogger().error((Throwable)ThreadingAssertions.createThreadAccessException(MUST_NOT_EXECUTE_IN_EDT));
        }
    }

    public static void assertReadAccess() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (!application.isReadAccessAllowed()) {
                ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_READ_ACTION, true);
            } else {
                ThreadingAssertions.trySoftAssertReadAccessWhenLocksAreForbidden(application);
            }
        }
    }

    private static void trySoftAssertReadAccessWhenLocksAreForbidden(@NotNull Application application) {
        String advice;
        if (application == null) {
            ThreadingAssertions.$$$reportNull$$$0(1);
        }
        if ((advice = application.getLockProhibitedAdvice()) != null) {
            ThreadingAssertions.getLogger().error((Throwable)ThreadingAssertions.createLockingForbiddenException("This thread requested read access, but it does not have permission to use locks.\n" + advice));
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertReadAccess() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (!application.isReadAccessAllowed()) {
                RuntimeExceptionWithAttachments exception = ThreadingAssertions.createThreadAccessException(MUST_EXECUTE_IN_READ_ACTION);
                ThreadingAssertions.processExceptionWithThreadLocal((Throwable)exception);
                ThreadingAssertions.getLogger().error((Throwable)exception);
            } else {
                ThreadingAssertions.trySoftAssertReadAccessWhenLocksAreForbidden(application);
            }
        }
    }

    public static void assertNoReadAccess() {
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isReadAccessAllowed()) {
            ThreadingAssertions.throwThreadAccessException(MUST_NOT_EXECUTE_IN_READ_ACTION, true);
        }
    }

    public static void assertNoOwnReadAccess() {
        Application application = ApplicationManager.getApplication();
        if (application != null && application.holdsReadLock()) {
            ThreadingAssertions.throwThreadAccessException(MUST_NOT_EXECUTE_IN_READ_ACTION, true);
        }
    }

    public static void assertWriteIntentReadAccess() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (!application.isWriteIntentLockAcquired()) {
                ThreadingAssertions.throwWriteIntentReadAccess();
            } else {
                ThreadingAssertions.trySoftAssertWriteIntentAccessWhenLocksAreForbidden(application);
            }
        }
    }

    private static void trySoftAssertWriteIntentAccessWhenLocksAreForbidden(@NotNull Application application) {
        String advice;
        if (application == null) {
            ThreadingAssertions.$$$reportNull$$$0(2);
        }
        if ((advice = application.getLockProhibitedAdvice()) != null) {
            ThreadingAssertions.getLogger().error((Throwable)ThreadingAssertions.createLockingForbiddenException("This thread requested write-intent access, but it does not have permission to use locks.\n" + advice));
        }
    }

    public static void throwWriteIntentReadAccess() {
        ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_WRITE_INTENT_READ_ACTION, true);
    }

    public static void assertWriteAccess() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (!application.isWriteAccessAllowed()) {
                ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_WRITE_ACTION, true);
            } else {
                ThreadingAssertions.trySoftAssertWriteAccessWhenLocksAreForbidden(application);
            }
        }
    }

    private static void trySoftAssertWriteAccessWhenLocksAreForbidden(@NotNull Application application) {
        String advice;
        if (application == null) {
            ThreadingAssertions.$$$reportNull$$$0(3);
        }
        if ((advice = application.getLockProhibitedAdvice()) != null) {
            ThreadingAssertions.getLogger().error((Throwable)ThreadingAssertions.createLockingForbiddenException("This thread requested write access, but it does not have permission to use locks.\n" + advice));
        }
    }

    private static void throwThreadAccessException(@NotNull @NonNls String message, boolean isThreading) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(4);
        }
        RuntimeExceptionWithAttachments exception = ThreadingAssertions.createThreadAccessException(message);
        if (isThreading) {
            ThreadingAssertions.processExceptionWithThreadLocal((Throwable)exception);
        }
        throw exception;
    }

    @NotNull
    private static RuntimeExceptionWithAttachments createThreadAccessException(@NonNls @NotNull String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(5);
        }
        boolean skipReadAction = EDT.isCurrentThreadEdt() && ThreadContext.currentThreadContextOrNull() != null;
        return new RuntimeExceptionWithAttachments(message + "; If you access or modify model on EDT consider wrapping your code in WriteIntentReadAction " + (skipReadAction ? "" : " or ReadAction") + "; see " + DOCUMENTATION_URL + " for details\n" + ThreadingAssertions.getThreadDetails(), new Attachment[0]);
    }

    @NotNull
    private static RuntimeExceptionWithAttachments createLockingForbiddenException(@NonNls @NotNull String advice) {
        if (advice == null) {
            ThreadingAssertions.$$$reportNull$$$0(6);
        }
        return new RuntimeExceptionWithAttachments(advice + "\nSee " + DOCUMENTATION_URL + " for details\n" + ThreadingAssertions.getThreadDetails(), new Attachment[0]);
    }

    @NotNull
    private static String getThreadDetails() {
        Thread current = Thread.currentThread();
        Thread edt = EDT.getEventDispatchThreadOrNull();
        String string = "Current thread: " + ThreadingAssertions.describe(current) + " (EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + ")\nSystemEventQueueThread: " + (edt == current ? "(same)" : ThreadingAssertions.describe(edt));
        if (string == null) {
            ThreadingAssertions.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String describe(@Nullable Thread o) {
        String string = o == null ? "null" : o + " " + System.identityHashCode(o);
        if (string == null) {
            ThreadingAssertions.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void processExceptionWithThreadLocal(Throwable e) {
        Consumer<Throwable> consumer = inputEventWithoutWriteIntentLock.get();
        if (consumer != null) {
            consumer.accept(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "advice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDetails";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trySoftAssertReadAccessWhenLocksAreForbidden";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "trySoftAssertWriteIntentAccessWhenLocksAreForbidden";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "trySoftAssertWriteAccessWhenLocksAreForbidden";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "throwThreadAccessException";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createThreadAccessException";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLockingForbiddenException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

