/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.ui;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ServerAccount;
import com.intellij.collaboration.auth.ui.LoadingAccountsDetailsProvider;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ClientProperty;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UiScopeKt;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import com.intellij.util.ui.cloneDialog.AccountMenuPopupStep;
import com.intellij.util.ui.cloneDialog.AccountsMenuListPopup;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003\u0010\u0011\u0012B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory;", "A", "Lcom/intellij/collaboration/auth/Account;", "", "accountsListModel", "Ljavax/swing/ListModel;", "<init>", "(Ljavax/swing/ListModel;)V", "create", "Ljavax/swing/JComponent;", "detailsProvider", "Lcom/intellij/collaboration/auth/ui/LoadingAccountsDetailsProvider;", "listAvatarSize", "", "popupConfig", "Lcom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory$PopupConfig;", "IconCellRenderer", "PopupConfig", "PopupMenuListener", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nCompactAccountsPanelFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompactAccountsPanelFactory.kt\ncom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1586#2:122\n1661#2,3:123\n*S KotlinDebug\n*F\n+ 1 CompactAccountsPanelFactory.kt\ncom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory\n*L\n36#1:122\n36#1:123,3\n*E\n"})
public final class CompactAccountsPanelFactory<A extends Account> {
    @NotNull
    private final ListModel<A> accountsListModel;

    public CompactAccountsPanelFactory(@NotNull ListModel<A> accountsListModel) {
        Intrinsics.checkNotNullParameter(accountsListModel, (String)"accountsListModel");
        this.accountsListModel = accountsListModel;
    }

    @NotNull
    public final JComponent create(@NotNull LoadingAccountsDetailsProvider<A, ?> detailsProvider, int listAvatarSize, @NotNull PopupConfig<A> popupConfig) {
        JList<A> jList;
        Intrinsics.checkNotNullParameter(detailsProvider, (String)"detailsProvider");
        Intrinsics.checkNotNullParameter(popupConfig, (String)"popupConfig");
        IconCellRenderer iconRenderer = new IconCellRenderer(detailsProvider, listAvatarSize);
        JList<A> $this$create_u24lambda_u241 = jList = new JList<A>(this.accountsListModel);
        boolean bl = false;
        $this$create_u24lambda_u241.setOpaque(false);
        $this$create_u24lambda_u241.setCellRenderer(iconRenderer);
        ClientProperty.put((JComponent)$this$create_u24lambda_u241, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)CollectionsKt.listOf(iconRenderer));
        $this$create_u24lambda_u241.setSelectionMode(0);
        $this$create_u24lambda_u241.setVisibleRowCount(1);
        $this$create_u24lambda_u241.setLayoutOrientation(2);
        JList<A> accountsList = jList;
        UiScopeKt.launchOnShow$default((Component)accountsList, (String)"AccountsListUpdate", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, accountsList, null){
            Object L$0;
            int label;
            final /* synthetic */ CompactAccountsPanelFactory<A> this$0;
            final /* synthetic */ JList<A> $accountsList;
            {
                this.this$0 = $receiver;
                this.$accountsList = $accountsList;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var listener2 = new ListDataListener(this.$accountsList, this.this$0){
                            final /* synthetic */ JList<A> $accountsList;
                            final /* synthetic */ CompactAccountsPanelFactory<A> this$0;
                            {
                                this.$accountsList = $accountsList;
                                this.this$0 = $receiver;
                            }

                            public void contentsChanged(ListDataEvent e) {
                                this.updateAccountsTooltip();
                            }

                            public void intervalAdded(ListDataEvent e) {
                                this.updateAccountsTooltip();
                            }

                            public void intervalRemoved(ListDataEvent e) {
                                this.updateAccountsTooltip();
                            }

                            public final void updateAccountsTooltip() {
                                this.$accountsList.setToolTipText(CompactAccountsPanelFactory.access$create$buildTooltipHtml(this.this$0));
                            }
                        };
                        CompactAccountsPanelFactory.access$getAccountsListModel$p(this.this$0).addListDataListener(listener2);
                        listener2.updateAccountsTooltip();
                        this.L$0 = listener2;
                        this.label = 1;
                        Object object2 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        Object object2;
                        var listener2 = this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                        catch (Throwable throwable) {
                            CompactAccountsPanelFactory.access$getAccountsListModel$p(this.this$0).removeListDataListener(listener2);
                            throw throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        new PopupMenuListener<A>(this.accountsListModel, detailsProvider, popupConfig).installOn(accountsList);
        return accountsList;
    }

    /*
     * WARNING - void declaration
     */
    private static final <A extends Account> String create$buildTooltipHtml(CompactAccountsPanelFactory<A> this$0) {
        Collection<HtmlChunk> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable<A> iterable = CollaborationToolsUIUtilKt.getItems(this$0.accountsListModel);
        HtmlChunk htmlChunk = (HtmlChunk)HtmlChunk.br();
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Account account = (Account)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HtmlChunk.text((String)it.getName()));
        }
        collection = (List)destination$iv$iv;
        String string = htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ String access$create$buildTooltipHtml(CompactAccountsPanelFactory this$0) {
        return CompactAccountsPanelFactory.create$buildTooltipHtml(this$0);
    }

    public static final /* synthetic */ ListModel access$getAccountsListModel$p(CompactAccountsPanelFactory $this) {
        return $this.accountsListModel;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ?\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0001\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory$IconCellRenderer;", "A", "Lcom/intellij/collaboration/auth/Account;", "Ljavax/swing/ListCellRenderer;", "Ljavax/swing/JLabel;", "iconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "avatarSize", "", "<init>", "(Lcom/intellij/collaboration/ui/icon/IconsProvider;I)V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "isSelected", "", "cellHasFocus", "(Ljavax/swing/JList;Lcom/intellij/collaboration/auth/Account;IZZ)Ljava/awt/Component;", "intellij.platform.collaborationTools"})
    private static final class IconCellRenderer<A extends Account>
    extends JLabel
    implements ListCellRenderer<A> {
        @NotNull
        private final IconsProvider<A> iconsProvider;
        private final int avatarSize;

        public IconCellRenderer(@NotNull IconsProvider<A> iconsProvider, int avatarSize) {
            Intrinsics.checkNotNullParameter(iconsProvider, (String)"iconsProvider");
            this.iconsProvider = iconsProvider;
            this.avatarSize = avatarSize;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<? extends A> list, @NotNull A value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.setIcon(this.iconsProvider.getIcon(value, this.avatarSize));
            return this;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory$PopupConfig;", "A", "Lcom/intellij/collaboration/auth/Account;", "", "avatarSize", "", "getAvatarSize", "()I", "createActions", "", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItem$Action;", "intellij.platform.collaborationTools"})
    public static interface PopupConfig<A extends Account> {
        public int getAvatarSize();

        @NotNull
        public Collection<AccountMenuItem.Action> createActions();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory$PopupMenuListener;", "A", "Lcom/intellij/collaboration/auth/Account;", "Lcom/intellij/ui/ClickListener;", "model", "Ljavax/swing/ListModel;", "detailsProvider", "Lcom/intellij/collaboration/auth/ui/LoadingAccountsDetailsProvider;", "popupConfig", "Lcom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory$PopupConfig;", "<init>", "(Ljavax/swing/ListModel;Lcom/intellij/collaboration/auth/ui/LoadingAccountsDetailsProvider;Lcom/intellij/collaboration/auth/ui/CompactAccountsPanelFactory$PopupConfig;)V", "onClick", "", "event", "Ljava/awt/event/MouseEvent;", "clickCount", "", "showPopupMenu", "", "parentComponent", "Ljavax/swing/JComponent;", "intellij.platform.collaborationTools"})
    private static final class PopupMenuListener<A extends Account>
    extends ClickListener {
        @NotNull
        private final ListModel<A> model;
        @NotNull
        private final LoadingAccountsDetailsProvider<A, ?> detailsProvider;
        @NotNull
        private final PopupConfig<A> popupConfig;

        public PopupMenuListener(@NotNull ListModel<A> model, @NotNull LoadingAccountsDetailsProvider<A, ?> detailsProvider, @NotNull PopupConfig<A> popupConfig) {
            Intrinsics.checkNotNullParameter(model, (String)"model");
            Intrinsics.checkNotNullParameter(detailsProvider, (String)"detailsProvider");
            Intrinsics.checkNotNullParameter(popupConfig, (String)"popupConfig");
            this.model = model;
            this.detailsProvider = detailsProvider;
            this.popupConfig = popupConfig;
        }

        public boolean onClick(@NotNull MouseEvent event, int clickCount) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object parentComponent = event.getSource();
            if (!(parentComponent instanceof JComponent)) {
                return false;
            }
            this.showPopupMenu((JComponent)parentComponent);
            return true;
        }

        private final void showPopupMenu(JComponent parentComponent) {
            List menuItems = new ArrayList();
            Iterator<A> iterator = CollaborationToolsUIUtilKt.getItems(this.model).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                Account account = (Account)iterator.next();
                Object obj = this.detailsProvider.getDetails(account);
                if (obj == null || (obj = obj.getName()) == null) {
                    obj = account.getName();
                }
                Object accountTitle = obj;
                String serverInfo = account instanceof ServerAccount ? CollaborationToolsUIUtil.INSTANCE.cleanupUrl(((ServerAccount)account).getServer().toString()) : "";
                Icon avatar = this.detailsProvider.getIcon(account, this.popupConfig.getAvatarSize());
                boolean showSeparatorAbove = index != 0;
                ((Collection)menuItems).add(new AccountMenuItem.Account(accountTitle, serverInfo, avatar, CollectionsKt.emptyList(), showSeparatorAbove));
            }
            CollectionsKt.addAll((Collection)menuItems, (Iterable)this.popupConfig.createActions());
            new AccountsMenuListPopup(null, new AccountMenuPopupStep(menuItems), null, null, 12, null).showUnderneathOf((Component)parentComponent);
        }
    }
}

