/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.settings.JavaDebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CustomizeContextViewActionUtils {
    private static int ourLastSelectedTabIndex = 0;

    public static void showDialog(Project project) {
        final MyTabbedConfigurable configurable = new MyTabbedConfigurable();
        SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)configurable){

            protected void doOKAction() {
                ourLastSelectedTabIndex = configurable.getSelectedIndex();
                super.doOKAction();
            }

            public void doCancelAction() {
                ourLastSelectedTabIndex = configurable.getSelectedIndex();
                super.doCancelAction();
            }
        };
        editor.show();
    }

    private static class MyTabbedConfigurable
    extends TabbedConfigurable {
        private MyTabbedConfigurable() {
        }

        @NotNull
        protected List<Configurable> createConfigurables() {
            List<Configurable> list = JavaDebuggerSettings.createDataViewsConfigurable();
            if (list == null) {
                MyTabbedConfigurable.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void apply() throws ConfigurationException {
            super.apply();
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }

        public String getDisplayName() {
            return JavaDebuggerBundle.message((String)"title.customize.data.views", (Object[])new Object[0]);
        }

        public String getHelpTopic() {
            return "reference.debug.customize.data.view";
        }

        protected void createConfigurableTabs() {
            for (Configurable configurable : this.getConfigurables()) {
                JComponent component = configurable.createComponent();
                assert (component != null);
                component.setBorder((Border)JBUI.Borders.empty((int)8, (int)8));
                this.myTabbedPane.addTab(configurable.getDisplayName(), component);
            }
            this.myTabbedPane.setSelectedIndex(ourLastSelectedTabIndex);
        }

        int getSelectedIndex() {
            return this.myTabbedPane.getSelectedIndex();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/CustomizeContextViewActionUtils$MyTabbedConfigurable", "createConfigurables"));
        }
    }
}

