/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoErrorReporter;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.statistics.DebuggerStatistics;
import com.intellij.debugger.statistics.Engine;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Range;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class JavaSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    private static final Logger LOG = Logger.getInstance(JavaSmartStepIntoHandler.class);

    @Override
    public boolean isAvailable(SourcePosition position) {
        PsiFile file = position.getFile();
        return file.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    private Promise<List<SmartStepTarget>> findSmartStepTargetsAsync(final SourcePosition position, DebuggerSession session, final boolean smart) {
        final AsyncPromise res = new AsyncPromise();
        DebuggerContextImpl context = session.getContextManager().getContext();
        Objects.requireNonNull(context.getManagerThread()).schedule(new DebuggerContextCommandImpl(context){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!Objects.equals(ContextUtil.getSourcePosition((StackFrameContext)suspendContext), position)) {
                    res.cancel();
                    return;
                }
                Promises.compute((AsyncPromise)res, () -> (List)ReadAction.nonBlocking(() -> JavaSmartStepIntoHandler.this.findStepTargets(position, suspendContext, this.getDebuggerContext(), smart)).executeSynchronously());
            }

            @Override
            protected void commandCancelled() {
                res.cancel();
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/JavaSmartStepIntoHandler$1", "threadAction"));
            }
        });
        AsyncPromise asyncPromise = res;
        if (asyncPromise == null) {
            JavaSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public Promise<List<SmartStepTarget>> findSmartStepTargetsAsync(SourcePosition position, DebuggerSession session) {
        return this.findSmartStepTargetsAsync(position, session, true);
    }

    @Override
    @NotNull
    public Promise<List<SmartStepTarget>> findStepIntoTargets(SourcePosition position, DebuggerSession session) {
        if (DebuggerSettings.getInstance().ALWAYS_SMART_STEP_INTO) {
            return this.findSmartStepTargetsAsync(position, session, false);
        }
        Promise promise = Promises.rejectedPromise();
        if (promise == null) {
            JavaSmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        return promise;
    }

    @Override
    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(SourcePosition position) {
        throw new IllegalStateException("Should not be used");
    }

    protected List<SmartStepTarget> findStepTargets(SourcePosition position, @Nullable SuspendContextImpl suspendContext, @NotNull DebuggerContextImpl debuggerContext, boolean smart) {
        if (debuggerContext == null) {
            JavaSmartStepIntoHandler.$$$reportNull$$$0(2);
        }
        return JavaSmartStepIntoHandler.reorderWithSteppingFilters(this.findStepTargetsInt(position, suspendContext, debuggerContext, smart));
    }

    private List<SmartStepTarget> findStepTargetsInt(final SourcePosition position, @Nullable SuspendContextImpl suspendContext, final @NotNull DebuggerContextImpl debuggerContext, boolean smart) {
        StackFrameProxyImpl frameProxy;
        TextRange lineRange;
        int line;
        if (debuggerContext == null) {
            JavaSmartStepIntoHandler.$$$reportNull$$$0(3);
        }
        if ((line = position.getLine()) < 0) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection(debuggerContext.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.INVALID_POSITION);
            return Collections.emptyList();
        }
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection(debuggerContext.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.INVALID_POSITION);
            return Collections.emptyList();
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null || line >= doc.getLineCount()) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection(debuggerContext.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.INVALID_POSITION);
            return Collections.emptyList();
        }
        TextRange curLineRange = DocumentUtil.getLineTextRange((Document)doc, (int)line);
        PsiElement element = position.getElementAt();
        PsiElement body = DebuggerUtilsEx.getBody(DebuggerUtilsEx.getContainingMethod(element));
        TextRange textRange = lineRange = body != null ? curLineRange.intersection(body.getTextRange()) : curLineRange;
        if (lineRange == null || lineRange.isEmpty() || element == null || element instanceof PsiCompiledElement) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection(debuggerContext.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.INVALID_POSITION);
            return Collections.emptyList();
        }
        PsiElement initial = element;
        element = JavaSmartStepIntoHandler.getTopmostParentAfterOffset(element, lineRange.getStartOffset());
        PsiElement statementParent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)initial, (Class[])new Class[]{PsiStatement.class, PsiField.class});
        if (statementParent != null && (body == null || body.getTextRange().contains(statementParent.getTextRange())) && statementParent.getTextRange().contains(element.getTextRange())) {
            element = statementParent;
        }
        final ArrayList<SmartStepTarget> targets = new ArrayList<SmartStepTarget>();
        final Ref textRange2 = new Ref((Object)lineRange);
        JavaRecursiveElementVisitor methodCollector = new JavaRecursiveElementVisitor(this){
            final Deque<PsiMethod> myContextStack = new LinkedList<PsiMethod>();
            final Deque<String> myParamNameStack = new LinkedList<String>();
            private int myNextLambdaExpressionOrdinal = 0;
            private boolean myInsideLambda = false;

            @Nullable
            private String getCurrentParamName() {
                return this.myParamNameStack.peekFirst();
            }

            public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
                if (aClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!this.matchLine((PsiElement)aClass)) {
                    return;
                }
                PsiExpressionList argumentList = aClass.getArgumentList();
                if (argumentList != null) {
                    argumentList.accept((PsiElementVisitor)this);
                }
                for (PsiMethod psiMethod : aClass.getMethods()) {
                    targets.add(0, new MethodSmartStepTarget(psiMethod, this.getCurrentParamName(), (PsiElement)psiMethod.getBody(), true, null));
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(1);
                }
                boolean inLambda = this.myInsideLambda;
                this.myInsideLambda = true;
                super.visitLambdaExpression(expression);
                this.myInsideLambda = inLambda;
                if (!this.matchLine((PsiElement)expression)) {
                    return;
                }
                targets.add(0, new LambdaSmartStepTarget(expression, this.getCurrentParamName(), expression.getBody(), this.myNextLambdaExpressionOrdinal++, null, !this.myInsideLambda));
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                PsiElement navMethod;
                if (expression == null) {
                    2.$$$reportNull$$$0(2);
                }
                PsiElement element = expression.resolve();
                if (this.matchLine((PsiElement)expression) && element instanceof PsiMethod && (navMethod = element.getNavigationElement()) instanceof PsiMethod) {
                    targets.add(0, new MethodSmartStepTarget((PsiMethod)navMethod, null, (PsiElement)expression, true, null));
                }
            }

            public void visitField(@NotNull PsiField field) {
                if (field == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (this.checkTextRange((PsiElement)field, true)) {
                    super.visitField(field);
                }
            }

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (this.checkTextRange((PsiElement)method, false)) {
                    super.visitMethod(method);
                }
            }

            public void visitStatement(@NotNull PsiStatement statement) {
                if (statement == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (this.checkTextRange((PsiElement)statement, true)) {
                    super.visitStatement(statement);
                }
            }

            public void visitIfStatement(@NotNull PsiIfStatement statement) {
                if (statement == null) {
                    2.$$$reportNull$$$0(6);
                }
                this.visitConditional((PsiElement)statement.getCondition(), (PsiElement)statement.getThenBranch(), (PsiElement)statement.getElseBranch());
            }

            public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(7);
                }
                this.visitConditional((PsiElement)expression.getCondition(), (PsiElement)expression.getThenExpression(), (PsiElement)expression.getElseExpression());
            }

            private void visitConditional(@Nullable PsiElement condition, @Nullable PsiElement thenBranch, @Nullable PsiElement elseBranch) {
                ThreeState conditionRes;
                if (condition != null && this.checkTextRange(condition, true)) {
                    condition.accept((PsiElementVisitor)this);
                }
                if ((conditionRes = this.evaluateCondition(condition)) != ThreeState.NO && thenBranch != null && this.checkTextRange(thenBranch, true)) {
                    thenBranch.accept((PsiElementVisitor)this);
                }
                if (conditionRes != ThreeState.YES && elseBranch != null && this.checkTextRange(elseBranch, true)) {
                    elseBranch.accept((PsiElementVisitor)this);
                }
            }

            private ThreeState evaluateCondition(@Nullable PsiElement condition) {
                if (condition != null && !DebuggerUtils.hasSideEffects((PsiElement)condition)) {
                    try {
                        ExpressionEvaluator evaluator = EvaluatorBuilderImpl.getInstance().build(condition, position);
                        return ThreeState.fromBoolean((boolean)DebuggerUtilsEx.evaluateBoolean(evaluator, debuggerContext.createEvaluationContext()));
                    }
                    catch (EvaluateException e) {
                        LOG.info((Throwable)e);
                    }
                }
                return ThreeState.UNSURE;
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(8);
                }
                this.checkTextRange((PsiElement)expression, true);
                super.visitExpression(expression);
            }

            boolean checkTextRange(@NotNull PsiElement expression, boolean expand) {
                TextRange range;
                if (expression == null) {
                    2.$$$reportNull$$$0(9);
                }
                if (lineRange.intersects(range = expression.getTextRange())) {
                    if (expand) {
                        TextRange current = (TextRange)textRange2.get();
                        int delta = range.getEndOffset() - current.getEndOffset();
                        if (delta > 0) {
                            textRange2.set((Object)current.grown(delta));
                        }
                    }
                    return true;
                }
                return false;
            }

            boolean matchLine(@NotNull PsiElement elem) {
                if (elem == null) {
                    2.$$$reportNull$$$0(10);
                }
                return lineRange.getStartOffset() <= elem.getTextRange().getStartOffset();
            }

            public void visitExpressionList(@NotNull PsiExpressionList expressionList) {
                if (expressionList == null) {
                    2.$$$reportNull$$$0(11);
                }
                this.visitArguments(expressionList, this.myContextStack.peekFirst());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void visitArguments(PsiExpressionList expressionList, PsiMethod psiMethod) {
                if (psiMethod != null) {
                    String methodName = psiMethod.getName();
                    PsiExpression[] expressions = expressionList.getExpressions();
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    for (int idx = 0; idx < expressions.length; ++idx) {
                        PsiExpression argExpression = expressions[idx];
                        if (!this.matchLine((PsiElement)argExpression)) continue;
                        String paramName = idx < parameters.length && !parameters[idx].isVarArgs() ? parameters[idx].getName() : "arg" + (idx + 1);
                        this.myParamNameStack.push(methodName + ": " + paramName + ".");
                        try {
                            argExpression.accept((PsiElementVisitor)this);
                            continue;
                        }
                        finally {
                            this.myParamNameStack.pop();
                        }
                    }
                } else {
                    super.visitExpressionList(expressionList);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCallExpression(@NotNull PsiCallExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(12);
                }
                int pos = -1;
                if (this.myContextStack.isEmpty()) {
                    pos = targets.size();
                }
                PsiMethod psiMethod = expression.resolveMethod();
                if (expression instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression callExpr = (PsiMethodCallExpression)expression;
                    PsiExpression qualifier = callExpr.getMethodExpression().getQualifierExpression();
                    if (qualifier != null) {
                        qualifier.accept((PsiElementVisitor)this);
                    }
                    this.visitArguments(expression.getArgumentList(), psiMethod);
                }
                if (psiMethod != null) {
                    this.myContextStack.push(psiMethod);
                }
                try {
                    PsiCallExpression callExpression;
                    if (expression instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression callExpr = (PsiMethodCallExpression)expression;
                        v0 = callExpr.getMethodExpression().getReferenceNameElement();
                    } else if (expression instanceof PsiNewExpression) {
                        PsiNewExpression newExpr = (PsiNewExpression)expression;
                        v0 = newExpr.getClassOrAnonymousClassReference();
                    } else {
                        v0 = callExpression = expression;
                    }
                    if (psiMethod != null && (callExpression == null || this.matchLine((PsiElement)callExpression))) {
                        PsiNewExpression newExpr;
                        MethodSmartStepTarget target = new MethodSmartStepTarget(psiMethod, null, (PsiElement)callExpression, this.myInsideLambda || expression instanceof PsiNewExpression && (newExpr = (PsiNewExpression)expression).getAnonymousClass() != null, null);
                        target.setOrdinal(Math.toIntExact(JavaSmartStepIntoHandler.existingMethodCalls(targets, psiMethod).count()));
                        if (pos != -1) {
                            targets.add(pos, target);
                        } else {
                            targets.add(target);
                        }
                    }
                    if (expression instanceof PsiMethodCallExpression) {
                        this.checkTextRange((PsiElement)expression, true);
                    } else {
                        super.visitCallExpression(expression);
                    }
                }
                finally {
                    if (psiMethod != null) {
                        this.myContextStack.pop();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elem";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expressionList";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/actions/JavaSmartStepIntoHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnonymousClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitStatement";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIfStatement";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConditionalExpression";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTextRange";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "matchLine";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpressionList";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        element.accept((PsiElementVisitor)methodCollector);
        for (PsiElement sibling = element.getNextSibling(); sibling != null && lineRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
            sibling.accept((PsiElementVisitor)methodCollector);
        }
        if (targets.isEmpty()) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection(debuggerContext.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.NO_TARGETS);
            return Collections.emptyList();
        }
        Range sourceLines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)textRange2.get()).getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)textRange2.get()).getEndOffset())));
        targets.forEach(t -> t.setCallingExpressionLines((Range<Integer>)sourceLines));
        Set lines = new HashSet();
        IntStream.rangeClosed((Integer)sourceLines.getFrom(), (Integer)sourceLines.getTo()).forEach(lines::add);
        LineNumbersMapping mapping = (LineNumbersMapping)vFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY);
        if (mapping != null) {
            lines = ((StreamEx)StreamEx.of(lines).map(l -> mapping.sourceToBytecode(l + 1) - 1).filter(l -> l >= 0)).toSet();
        }
        StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContext != null ? suspendContext.getFrameProxy() : null;
        if (frameProxy == null) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection(debuggerContext.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.SUCCESS);
            return targets;
        }
        VirtualMachineProxyImpl virtualMachine = frameProxy.getVirtualMachine();
        if (!virtualMachine.canGetConstantPool() || !virtualMachine.canGetBytecodes()) {
            if (smart) {
                DebuggerStatistics.logSmartStepIntoTargetsDetection(debuggerContext.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.SUCCESS);
                return targets;
            }
            DebuggerStatistics.logSmartStepIntoTargetsDetection(debuggerContext.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.BYTECODE_NOT_AVAILABLE);
            return Collections.emptyList();
        }
        try {
            final DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
            final Location location = frameProxy.location();
            final long currentBytecodeOffset = location.codeIndex();
            ArrayList<SmartStepTarget> all = new ArrayList<SmartStepTarget>(targets);
            final ArrayList targetsWithCollisions = new ArrayList();
            final Set finalLines = lines;
            class BytecodeVisitor
            extends MethodVisitor
            implements MethodBytecodeUtil.InstructionOffsetReader {
                private boolean myLineMatch;
                private int myOffset;
                private int endOfBasicBlock;
                private final Object2IntMap<String> myCounter;
                final Set<SmartStepTarget> foundTargets;
                final Set<SmartStepTarget> alreadyExecutedTargets;
                final Set<SmartStepTarget> anotherBasicBlockTargets;

                BytecodeVisitor() {
                    super(589824);
                    this.myLineMatch = false;
                    this.myOffset = -1;
                    this.endOfBasicBlock = Integer.MAX_VALUE;
                    this.myCounter = new Object2IntOpenHashMap();
                    this.foundTargets = new HashSet<SmartStepTarget>();
                    this.alreadyExecutedTargets = new HashSet<SmartStepTarget>();
                    this.anotherBasicBlockTargets = new HashSet<SmartStepTarget>();
                }

                @Override
                public void readBytecodeInstructionOffset(int bytecodeOffset) {
                    this.myOffset = bytecodeOffset;
                }

                public void visitLineNumber(int line, Label start) {
                    this.myLineMatch = finalLines.contains(line - 1);
                }

                public void visitJumpInsn(int opcode, Label label) {
                    if (this.myLineMatch) {
                        assert (this.myOffset != -1);
                        int oldValue = this.endOfBasicBlock;
                        if (currentBytecodeOffset <= (long)this.myOffset && this.myOffset < oldValue) {
                            assert (oldValue == Integer.MAX_VALUE);
                            this.endOfBasicBlock = this.myOffset;
                        }
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    if (this.myLineMatch) {
                        assert (this.myOffset != -1);
                        String key = owner + "." + name + desc;
                        final int currentCount = this.myCounter.mergeInt((Object)key, 1, Math::addExact) - 1;
                        if (name.startsWith("access$")) {
                            Method method;
                            ReferenceType cls = (ReferenceType)ContainerUtil.getFirstItem(location.virtualMachine().classesByName(Type.getObjectType((String)owner).getClassName()));
                            if (cls != null && (method = DebuggerUtils.findMethod((ReferenceType)cls, (String)name, (String)desc)) != null) {
                                MethodBytecodeUtil.visit(method, new MethodVisitor(589824){

                                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                                        if ("java/lang/AbstractMethodError".equals(owner)) {
                                            return;
                                        }
                                        this.visitMethodInstInt(owner, name, desc, currentCount, myOffset);
                                    }
                                }, false);
                            }
                        } else {
                            this.visitMethodInstInt(owner, name, desc, currentCount, this.myOffset);
                        }
                    }
                }

                private void visitMethodInstInt(String owner, String name, String desc, int ordinal, int bcOffs) {
                    for (SmartStepTarget t : targets) {
                        PsiMethod method;
                        MethodSmartStepTarget mt;
                        if (!(t instanceof MethodSmartStepTarget) || (mt = (MethodSmartStepTarget)t).getOrdinal() != ordinal || !DebuggerUtilsEx.methodMatches(method = mt.getMethod(), owner.replace("/", "."), name, desc, debugProcess)) continue;
                        if (this.foundTargets.contains(mt)) {
                            targetsWithCollisions.add(mt);
                            continue;
                        }
                        this.foundTargets.add(mt);
                        if ((long)bcOffs < currentBytecodeOffset) {
                            this.alreadyExecutedTargets.add(mt);
                        }
                        if (bcOffs <= this.endOfBasicBlock) continue;
                        this.anotherBasicBlockTargets.add(mt);
                    }
                }
            }
            BytecodeVisitor bytecodeVisitor = new BytecodeVisitor();
            MethodBytecodeUtil.visit(location.method(), bytecodeVisitor, true);
            ArrayList<SmartStepTarget> notFoundTargets = new ArrayList<SmartStepTarget>();
            for (SmartStepTarget t2 : targets) {
                if (!JavaSmartStepIntoHandler.isImmediateMethodCall(t2) || bytecodeVisitor.foundTargets.contains(t2)) continue;
                notFoundTargets.add(t2);
            }
            StringBuilder errorMessage = new StringBuilder();
            if (!targetsWithCollisions.isEmpty()) {
                errorMessage.append("Target occurred multiple times in bytecode: ").append(JvmSmartStepIntoErrorReporter.joinTargetInfo(targetsWithCollisions));
            }
            if (!notFoundTargets.isEmpty()) {
                if (!errorMessage.isEmpty()) {
                    errorMessage.append('\n');
                }
                errorMessage.append("Target not found in bytecode: ").append(JvmSmartStepIntoErrorReporter.joinTargetInfo(notFoundTargets));
            }
            if (!errorMessage.isEmpty()) {
                JvmSmartStepIntoErrorReporter.report(element, debuggerContext.getDebuggerSession(), position, errorMessage.toString());
                DebuggerStatistics.logSmartStepIntoTargetsDetection(element.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.TARGETS_MISMATCH);
                return Collections.emptyList();
            }
            targets.removeAll(bytecodeVisitor.alreadyExecutedTargets);
            if (!(smart || targets.isEmpty() || bytecodeVisitor.anotherBasicBlockTargets.isEmpty())) {
                int oldSize = targets.size();
                targets.removeAll(bytecodeVisitor.anotherBasicBlockTargets);
                assert (oldSize == targets.size() + bytecodeVisitor.anotherBasicBlockTargets.size());
                if (!targets.isEmpty() && JavaSmartStepIntoHandler.immediateMethodCalls(targets).findAny().isEmpty()) {
                    targets.addAll(bytecodeVisitor.anotherBasicBlockTargets);
                }
            }
            ArrayList<SmartStepTarget> removed = new ArrayList<SmartStepTarget>(all);
            removed.removeAll(targets);
            for (SmartStepTarget m : removed) {
                MethodSmartStepTarget target = (MethodSmartStepTarget)m;
                JavaSmartStepIntoHandler.existingMethodCalls(all, target.getMethod()).forEach(t -> {
                    int ordinal = t.getOrdinal();
                    if (ordinal > target.getOrdinal()) {
                        t.setOrdinal(ordinal - 1);
                    }
                });
            }
            DebuggerStatistics.logSmartStepIntoTargetsDetection(element.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.SUCCESS);
            return targets;
        }
        catch (Exception e) {
            DebuggerUtilsImpl.logError(e);
            DebuggerStatistics.logSmartStepIntoTargetsDetection(element.getProject(), Engine.JAVA, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.INTERNAL_ERROR);
            return Collections.emptyList();
        }
    }

    private static PsiElement getTopmostParentAfterOffset(PsiElement element, int offset) {
        if (element == null) {
            return null;
        }
        PsiElement parent;
        while ((parent = element.getParent()) != null && parent.getTextRange().getStartOffset() >= offset) {
            element = parent;
        }
        return element;
    }

    private static boolean isImmediateMethodCall(SmartStepTarget target) {
        return !target.needsBreakpointRequest();
    }

    private static StreamEx<MethodSmartStepTarget> immediateMethodCalls(List<SmartStepTarget> targets) {
        return (StreamEx)StreamEx.of(targets).select(MethodSmartStepTarget.class).filter(JavaSmartStepIntoHandler::isImmediateMethodCall);
    }

    private static StreamEx<MethodSmartStepTarget> existingMethodCalls(List<SmartStepTarget> targets, PsiMethod psiMethod) {
        return (StreamEx)JavaSmartStepIntoHandler.immediateMethodCalls(targets).filter(t -> psiMethod.getManager().areElementsEquivalent((PsiElement)psiMethod, (PsiElement)t.getMethod()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/JavaSmartStepIntoHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findSmartStepTargetsAsync";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findStepIntoTargets";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/JavaSmartStepIntoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findStepTargets";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findStepTargetsInt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

