/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerThreadDispatcher;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.DebuggerManagerThread;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.DebuggerTask;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.InvokeAndWaitThread;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.statistics.StatisticsStorage;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.platform.util.progress.StepsKt;
import com.intellij.util.CoroutinesKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.DapMode;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 L2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u00032\u00020\u0004:\u0001LB\u0019\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0007J\b\u0010\u001c\u001a\u00020\u0016H\u0016JF\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u000b\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"2\u000b\u0010#\u001a\u00070!\u00a2\u0006\u0002\b$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160(H\u0007J\b\u0010)\u001a\u00020\u0007H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0002H\u0016J\u000e\u0010,\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0002J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0002H\u0007J\u001c\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\n\u00100\u001a\u000601j\u0002`2H\u0007J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0002H\u0016J\u001a\u00104\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\n\u00100\u001a\u000601j\u0002`2J\u0010\u00104\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0002H\u0016J\u0016\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u000208J\u0010\u00109\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0002H\u0014J/\u0010:\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u000b\u0010;\u001a\u00070!\u00a2\u0006\u0002\b<2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00020>J\u0012\u0010@\u001a\u00020\u00162\n\u0010A\u001a\u000601j\u0002`2J\u0010\u0010B\u001a\u00020\u00162\u0006\u00106\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\u000bH\u0007J\r\u0010E\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bFJ\u0006\u0010G\u001a\u00020\u000bJ\b\u0010H\u001a\u00020\u0016H\u0007J\b\u0010I\u001a\u00020\u0016H\u0007J\u0014\u0010J\u001a\u00020\u00162\n\u0010K\u001a\u000601j\u0002`2H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00078\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006M"}, d2={"Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;", "Lcom/intellij/debugger/impl/InvokeAndWaitThread;", "Lcom/intellij/debugger/engine/events/DebuggerCommandImpl;", "Lcom/intellij/debugger/engine/managerThread/DebuggerManagerThread;", "Lcom/intellij/openapi/Disposable;", "parent", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/Disposable;Lkotlinx/coroutines/CoroutineScope;)V", "myDisposed", "", "debuggerThreadDispatcher", "Lcom/intellij/debugger/engine/DebuggerThreadDispatcher;", "getDebuggerThreadDispatcher$intellij_java_debugger_impl", "()Lcom/intellij/debugger/engine/DebuggerThreadDispatcher;", "_vmProxy", "Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "vmProxy", "getVmProxy", "()Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "setVmProxy", "", "proxy", "value", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "dispose", "makeCancelable", "project", "Lcom/intellij/openapi/project/Project;", "progressTitle", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "progressText", "Lorg/jetbrains/annotations/Nls;", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "howToCancel", "Lkotlin/Function0;", "createScope", "invokeAndWait", "managerCommand", "invokeNow", "invoke", "priority", "Lcom/intellij/debugger/impl/PrioritizedTask$Priority;", "runnable", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "pushBack", "schedule", "terminateAndInvoke", "command", "terminateTimeoutMillis", "", "processEvent", "startCommandWithModalProgress", "title", "Lcom/intellij/openapi/util/NlsContexts$ModalProgressTitle;", "commandProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "startLongProcessAndFork", "process", "invokeCommand", "Lcom/intellij/debugger/engine/managerThread/DebuggerCommand;", "isIdle", "hasDispatchedCommands", "hasDispatchedCommands$intellij_java_debugger_impl", "hasAsyncCommands", "restartIfNeeded", "cancelScope", "afterScopeCancellation", "callback", "Companion", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nDebuggerManagerThreadImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerManagerThreadImpl.kt\ncom/intellij/debugger/engine/DebuggerManagerThreadImpl\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,762:1\n45#2,3:763\n60#3,5:766\n*S KotlinDebug\n*F\n+ 1 DebuggerManagerThreadImpl.kt\ncom/intellij/debugger/engine/DebuggerManagerThreadImpl\n*L\n227#1:763,3\n288#1:766,5\n*E\n"})
public final class DebuggerManagerThreadImpl
extends InvokeAndWaitThread<DebuggerCommandImpl>
implements DebuggerManagerThread,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope parentScope;
    private volatile boolean myDisposed;
    @NotNull
    private final DebuggerThreadDispatcher debuggerThreadDispatcher;
    @Nullable
    private VirtualMachineProxyImpl _vmProxy;
    @ApiStatus.Internal
    @NotNull
    private CoroutineScope coroutineScope;
    @NotNull
    private static final Logger LOG;
    private static final ThreadLocal<ArrayDeque<DebuggerCommandImpl>> myCurrentCommands;
    public static final int COMMAND_TIMEOUT = 3000;

    @ApiStatus.Internal
    public DebuggerManagerThreadImpl(@NotNull Disposable parent, @NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        this.parentScope = parentScope;
        this.debuggerThreadDispatcher = new DebuggerThreadDispatcher(this);
        this.coroutineScope = this.createScope();
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public final DebuggerThreadDispatcher getDebuggerThreadDispatcher$intellij_java_debugger_impl() {
        return this.debuggerThreadDispatcher;
    }

    @ApiStatus.Internal
    @Nullable
    public final VirtualMachineProxyImpl getVmProxy() {
        return this._vmProxy;
    }

    @ApiStatus.Internal
    public final void setVmProxy(@Nullable VirtualMachineProxyImpl proxy) {
        VirtualMachineProxyImpl current = this.getVmProxy();
        if (current != null && proxy != null && current.getVirtualMachine() != proxy.getVirtualMachine()) {
            LOG.error("VM proxy changed from " + current + " to " + proxy);
        }
        this._vmProxy = proxy;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @ApiStatus.Internal
    public final void makeCancelable(@NotNull Project project, @NotNull String progressTitle, @NotNull String progressText, @NotNull CompletableDeferred<Unit> deferred, @NotNull Function0<Unit> howToCancel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        Intrinsics.checkNotNullParameter((Object)progressText, (String)"progressText");
        Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
        Intrinsics.checkNotNullParameter(howToCancel, (String)"howToCancel");
        if (DapMode.isDap()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, progressTitle, progressText, deferred, howToCancel, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $progressTitle;
            final /* synthetic */ String $progressText;
            final /* synthetic */ CompletableDeferred<Unit> $deferred;
            final /* synthetic */ Function0<Unit> $howToCancel;
            {
                this.$project = $project;
                this.$progressTitle = $progressTitle;
                this.$progressText = $progressText;
                this.$deferred = $deferred;
                this.$howToCancel = $howToCancel;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)this.$progressTitle, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$progressText, this.$deferred, this.$howToCancel, null){
                            int label;
                            final /* synthetic */ String $progressText;
                            final /* synthetic */ CompletableDeferred<Unit> $deferred;
                            final /* synthetic */ Function0<Unit> $howToCancel;
                            {
                                this.$progressText = $progressText;
                                this.$deferred = $deferred;
                                this.$howToCancel = $howToCancel;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = StepsKt.withProgressText((String)this.$progressText, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$deferred, this.$howToCancel, null){
                                            int label;
                                            final /* synthetic */ CompletableDeferred<Unit> $deferred;
                                            final /* synthetic */ Function0<Unit> $howToCancel;
                                            {
                                                this.$deferred = $deferred;
                                                this.$howToCancel = $howToCancel;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.label = 1;
                                                        Object object2 = this.$deferred.await((Continuation)this);
                                                        if (object2 != object) return Unit.INSTANCE;
                                                        return object;
                                                    }
                                                    case 1: {
                                                        Object object2;
                                                        try {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            object2 = $result;
                                                            return Unit.INSTANCE;
                                                        }
                                                        catch (CancellationException e) {
                                                            this.$howToCancel.invoke();
                                                            throw e;
                                                        }
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final CoroutineScope createScope() {
        return CoroutineScopeKt.childScope$default((CoroutineScope)this.parentScope, (String)"DebuggerManagerThreadImpl", null, (boolean)false, (int)6, null);
    }

    @Override
    public void invokeAndWait(@NotNull DebuggerCommandImpl managerCommand) {
        Intrinsics.checkNotNullParameter((Object)managerCommand, (String)"managerCommand");
        LOG.assertTrue(!Companion.isManagerThread(), (Object)"Should be invoked outside manager thread, use DebuggerManagerThreadImpl.schedule(...)");
        super.invokeAndWait((DebuggerTask)managerCommand);
    }

    public final void invokeNow(@NotNull DebuggerCommandImpl managerCommand) {
        Intrinsics.checkNotNullParameter((Object)managerCommand, (String)"managerCommand");
        Companion.assertIsManagerThread();
        LOG.assertTrue(InvokeAndWaitThread.currentThread() == this, DebuggerManagerThreadImpl::invokeNow$lambda$0);
        this.setCommandManagerThread((PrioritizedTask)managerCommand);
        this.processEvent(managerCommand);
    }

    @Deprecated(message="Use invokeNow if in DebuggerManagerThread or schedule otherwise", replaceWith=@ReplaceWith(expression="invokeNow(managerCommand)", imports={}))
    public final void invoke(@NotNull DebuggerCommandImpl managerCommand) {
        Intrinsics.checkNotNullParameter((Object)managerCommand, (String)"managerCommand");
        if (InvokeAndWaitThread.currentThread() == this) {
            this.invokeNow(managerCommand);
        } else {
            if (Companion.isManagerThread()) {
                LOG.error("Schedule from a different DebuggerManagerThread");
            }
            this.schedule(managerCommand);
        }
    }

    @Deprecated(message="Use invokeNow if in DebuggerManagerThread or schedule otherwise", replaceWith=@ReplaceWith(expression="schedule(priority, runnable)", imports={}))
    public final void invoke(@NotNull PrioritizedTask.Priority priority, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.invoke(new DebuggerCommandImpl(priority, runnable){
            final /* synthetic */ Runnable $runnable;
            {
                this.$runnable = $runnable;
                super($priority);
            }

            protected void action() {
                this.$runnable.run();
            }
        });
    }

    @Override
    public boolean pushBack(@NotNull DebuggerCommandImpl managerCommand) {
        Intrinsics.checkNotNullParameter((Object)managerCommand, (String)"managerCommand");
        boolean pushed = super.pushBack((PrioritizedTask)managerCommand);
        if (!pushed) {
            managerCommand.notifyCancelled();
        }
        return pushed;
    }

    public final void schedule(@NotNull PrioritizedTask.Priority priority, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.schedule(new DebuggerCommandImpl(priority, runnable){
            final /* synthetic */ Runnable $runnable;
            {
                this.$runnable = $runnable;
                super($priority);
            }

            protected void action() {
                this.$runnable.run();
            }
        });
    }

    @Override
    public boolean schedule(@NotNull DebuggerCommandImpl managerCommand) {
        boolean scheduled;
        Intrinsics.checkNotNullParameter((Object)managerCommand, (String)"managerCommand");
        boolean bl = scheduled = kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.coroutineScope) && super.schedule((PrioritizedTask)managerCommand);
        if (!scheduled) {
            managerCommand.notifyCancelled();
        }
        return scheduled;
    }

    public final void terminateAndInvoke(@NotNull DebuggerCommandImpl command2, int terminateTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        DebuggerCommandImpl currentCommand = (DebuggerCommandImpl)this.myEvents.getCurrentEvent();
        this.schedule(command2);
        if (currentCommand != null) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> DebuggerManagerThreadImpl.terminateAndInvoke$lambda$0(currentCommand, this), (long)terminateTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEvent(@NotNull DebuggerCommandImpl managerCommand) {
        Intrinsics.checkNotNullParameter((Object)managerCommand, (String)"managerCommand");
        Companion.assertIsManagerThread();
        ArrayDeque<DebuggerCommandImpl> threadCommands = myCurrentCommands.get();
        threadCommands.add(managerCommand);
        try {
            if (this.myEvents.isClosed()) {
                managerCommand.notifyCancelled();
            } else {
                boolean $i$f$measureNanoTime = false;
                long start$iv = System.nanoTime();
                boolean bl = false;
                managerCommand.invokeCommand$intellij_java_debugger_impl();
                long commandTimeNs = System.nanoTime() - start$iv;
                UserDataHolderBase userDataHolderBase = this.getVmProxy();
                if (userDataHolderBase != null && (userDataHolderBase = userDataHolderBase.getDebugProcess()) != null) {
                    UserDataHolderBase debugProcess = userDataHolderBase;
                    boolean bl2 = false;
                    long commandTimeMs = TimeUnit.NANOSECONDS.toMillis(commandTimeNs);
                    StatisticsStorage.Companion.addCommandTime((DebugProcess)debugProcess, commandTimeMs);
                }
            }
        }
        catch (VMDisconnectedException e) {
            LOG.debug((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Throwable unwrap = DebuggerUtilsAsync.unwrap(e);
            if (unwrap instanceof InterruptedException) {
                throw new RuntimeException(unwrap);
            }
            LOG.error((Throwable)e);
        }
        finally {
            threadCommands.removeLast();
        }
    }

    public final void startCommandWithModalProgress(@NotNull Project project, @NotNull String title, @NotNull Function1<? super ProgressIndicator, ? extends DebuggerCommandImpl> commandProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(commandProvider, (String)"commandProvider");
        ExecutorService executorService = ProcessIOExecutorService.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"INSTANCE");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, title, commandProvider, this, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ Function1<ProgressIndicator, DebuggerCommandImpl> $commandProvider;
            final /* synthetic */ DebuggerManagerThreadImpl this$0;
            {
                this.$project = $project;
                this.$title = $title;
                this.$commandProvider = $commandProvider;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TasksKt.withModalProgress((Project)this.$project, (String)this.$title, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$commandProvider, this.this$0, null){
                            int label;
                            final /* synthetic */ Function1<ProgressIndicator, DebuggerCommandImpl> $commandProvider;
                            final /* synthetic */ DebuggerManagerThreadImpl this$0;
                            {
                                this.$commandProvider = $commandProvider;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = com.intellij.openapi.progress.CoroutinesKt.coroutineToIndicator(arg_0 -> startCommandWithModalProgress.1.invokeSuspend$lambda$0(this.$commandProvider, this.this$0, arg_0), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Unit invokeSuspend$lambda$0(Function1 $commandProvider, DebuggerManagerThreadImpl this$0, ProgressIndicator indicator) {
                                DebuggerCommandImpl command2 = (DebuggerCommandImpl)$commandProvider.invoke((Object)indicator);
                                this$0.invokeAndWait(command2);
                                return Unit.INSTANCE;
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startLongProcessAndFork(@NotNull Runnable process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Companion.assertIsManagerThread();
        this.startNewWorkerThread();
        try {
            process.run();
        }
        catch (Throwable throwable) {
            InvokeThread.WorkerThreadRequest<?> request = InvokeAndWaitThread.getCurrentThreadRequest();
            Logger $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Switching back to " + request, t$iv);
            }
            Ref.BooleanRef cancelled = new Ref.BooleanRef();
            super.invokeAndWait((DebuggerTask)new DebuggerCommandImpl(this, request, cancelled){
                final /* synthetic */ DebuggerManagerThreadImpl this$0;
                final /* synthetic */ InvokeThread.WorkerThreadRequest<?> $request;
                final /* synthetic */ Ref.BooleanRef $cancelled;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    this.$cancelled = $cancelled;
                    super(null, 1, null);
                }

                protected void action() {
                    DebuggerManagerThreadImpl.access$switchToRequest(this.this$0, this.$request);
                }

                /*
                 * WARNING - void declaration
                 */
                protected void commandCancelled() {
                    void $this$debug_u24default$iv;
                    this.$cancelled.element = true;
                    Logger logger = DebuggerManagerThreadImpl.access$getLOG$cp();
                    InvokeThread.WorkerThreadRequest<?> workerThreadRequest = this.$request;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var6_5 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var6_5.debug("Event queue was closed, killing request " + workerThreadRequest, t$iv);
                    }
                    this.$request.requestStop();
                }
            });
            if (cancelled.element) {
                throw new VMDisconnectedException();
            }
            throw throwable;
        }
        InvokeThread.WorkerThreadRequest<?> request = InvokeAndWaitThread.getCurrentThreadRequest();
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Switching back to " + request, t$iv);
        }
        Ref.BooleanRef cancelled = new Ref.BooleanRef();
        super.invokeAndWait((DebuggerTask)new /* invalid duplicate definition of identical inner class */);
        if (cancelled.element) {
            throw new VMDisconnectedException();
        }
    }

    public void invokeCommand(@NotNull DebuggerCommand command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        if (command2 instanceof SuspendContextCommand) {
            SuspendContext suspendContext = ((SuspendContextCommand)command2).getSuspendContext();
            v0 = this.schedule(new SuspendContextCommandImpl(command2, suspendContext){
                final /* synthetic */ DebuggerCommand $command;
                {
                    this.$command = $command;
                    Intrinsics.checkNotNull((Object)$super_call_param$1, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.SuspendContextImpl");
                    super((SuspendContextImpl)$super_call_param$1);
                }

                public void contextAction(SuspendContextImpl suspendContext) {
                    Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
                    this.$command.action();
                }

                protected void commandCancelled() {
                    this.$command.commandCancelled();
                }
            });
        } else {
            v0 = this.schedule(new DebuggerCommandImpl(command2){
                final /* synthetic */ DebuggerCommand $command;
                {
                    this.$command = $command;
                    super(null, 1, null);
                }

                protected void action() {
                    this.$command.action();
                }

                protected void commandCancelled() {
                    this.$command.commandCancelled();
                }
            });
        }
    }

    @ApiStatus.Internal
    public final boolean isIdle() {
        return this.myEvents.isEmpty() && !this.hasDispatchedCommands$intellij_java_debugger_impl();
    }

    public final boolean hasDispatchedCommands$intellij_java_debugger_impl() {
        return this.debuggerThreadDispatcher.hasDispatchedCommands$intellij_java_debugger_impl();
    }

    public final boolean hasAsyncCommands() {
        return this.myEvents.hasAsyncCommands();
    }

    @ApiStatus.Internal
    public final void restartIfNeeded() {
        if (this.myEvents.isClosed()) {
            this.myEvents.reopen();
            LOG.assertTrue(!kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.coroutineScope), (Object)"Coroutine scope should be cancelled");
            this.coroutineScope = this.createScope();
            this.startNewWorkerThread();
        }
    }

    @ApiStatus.Internal
    public final void cancelScope() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    @ApiStatus.Internal
    public final void afterScopeCancellation(@NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.coroutineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(callback, null){
            int label;
            final /* synthetic */ Runnable $callback;
            {
                this.$callback = $callback;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$callback.run();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final String invokeNow$lambda$0() {
        return "invokeNow from a different DebuggerManagerThread";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void terminateAndInvoke$lambda$0(DebuggerCommandImpl $currentCommand, DebuggerManagerThreadImpl this$0) {
        if ($currentCommand == this$0.myEvents.getCurrentEvent()) {
            InvokeThread.WorkerThreadRequest request = this$0.getCurrentRequest();
            request.requestStop();
            try {
                request.join();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!this$0.myDisposed) {
                    this$0.startNewWorkerThread();
                }
            }
        }
    }

    private static final ArrayDeque myCurrentCommands$lambda$0() {
        return new ArrayDeque();
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static final DebuggerManagerThreadImpl createTestInstance(@NotNull Disposable parent, @Nullable Project project) {
        return Companion.createTestInstance(parent, project);
    }

    @JvmStatic
    public static final boolean isManagerThread() {
        return Companion.isManagerThread();
    }

    @JvmStatic
    public static final void assertIsManagerThread() {
        Companion.assertIsManagerThread();
    }

    @JvmStatic
    @Nullable
    public static final DebuggerCommandImpl getCurrentCommand() {
        return Companion.getCurrentCommand();
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final DebuggerManagerThreadImpl getCurrentThread() {
        return Companion.getCurrentThread();
    }

    public static final /* synthetic */ void access$switchToRequest(DebuggerManagerThreadImpl $this, InvokeThread.WorkerThreadRequest newRequest) {
        $this.switchToRequest(newRequest);
    }

    static {
        Logger logger = Logger.getInstance(DebuggerManagerThreadImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        myCurrentCommands = ThreadLocal.withInitial(DebuggerManagerThreadImpl::myCurrentCommands$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\n\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u0019\u001a\u00020\u0015H\u0007J\b\u0010\u001a\u001a\u00020\u000fH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u0007\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \u000b*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "myCurrentCommands", "Ljava/lang/ThreadLocal;", "Ljava/util/ArrayDeque;", "Lcom/intellij/debugger/engine/events/DebuggerCommandImpl;", "kotlin.jvm.PlatformType", "COMMAND_TIMEOUT", "", "createTestInstance", "Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;", "parent", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "isManagerThread", "", "assertIsManagerThread", "", "getCurrentCommand", "hasNonDefaultProgressIndicator", "getCurrentThread", "intellij.java.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nDebuggerManagerThreadImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerManagerThreadImpl.kt\ncom/intellij/debugger/engine/DebuggerManagerThreadImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,762:1\n1#2:763\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @TestOnly
        @NotNull
        public final DebuggerManagerThreadImpl createTestInstance(@NotNull Disposable parent, @Nullable Project project) {
            DebuggerManagerThreadImpl debuggerManagerThreadImpl;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Ref.ObjectRef thread = new Ref.ObjectRef();
            Disposable disposable = () -> Companion.createTestInstance$lambda$0(thread);
            Disposer.register((Disposable)parent, (Disposable)disposable);
            Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            DebuggerManagerThreadImpl it = debuggerManagerThreadImpl = new DebuggerManagerThreadImpl(disposable, ((ComponentManagerEx)project).getCoroutineScope());
            boolean bl = false;
            thread.element = it;
            return debuggerManagerThreadImpl;
        }

        @JvmStatic
        public final boolean isManagerThread() {
            return InvokeAndWaitThread.currentThread() instanceof DebuggerManagerThreadImpl;
        }

        @JvmStatic
        public final void assertIsManagerThread() {
            LOG.assertTrue(this.isManagerThread(), (Object)"Should be invoked in manager thread, use DebuggerManagerThreadImpl.schedule(...)");
        }

        @JvmStatic
        @Nullable
        public final DebuggerCommandImpl getCurrentCommand() {
            return (DebuggerCommandImpl)((ArrayDeque)myCurrentCommands.get()).peekLast();
        }

        @ApiStatus.Internal
        public final boolean hasNonDefaultProgressIndicator() {
            boolean hasProgressIndicator = ProgressManager.getInstance().hasProgressIndicator();
            if (!hasProgressIndicator) {
                return false;
            }
            if (!this.isManagerThread()) {
                return true;
            }
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            ProgressIndicator progressIndicator = InvokeAndWaitThread.currentThread().getCurrentRequest().getProgressIndicator();
            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
            ProgressIndicator debuggerIndicator = progressIndicator;
            return currentIndicator != debuggerIndicator;
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final DebuggerManagerThreadImpl getCurrentThread() {
            this.assertIsManagerThread();
            InvokeThread<?> invokeThread = InvokeAndWaitThread.currentThread();
            Intrinsics.checkNotNull(invokeThread, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebuggerManagerThreadImpl");
            return (DebuggerManagerThreadImpl)invokeThread;
        }

        private static final void createTestInstance$lambda$0(Ref.ObjectRef $thread) {
            block3: {
                Object object;
                try {
                    DebuggerManagerThreadImpl debuggerManagerThreadImpl = (DebuggerManagerThreadImpl)$thread.element;
                    if (debuggerManagerThreadImpl != null) {
                        debuggerManagerThreadImpl.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((object = (DebuggerManagerThreadImpl)$thread.element) == null || (object = ((InvokeThread)object).getCurrentRequest()) == null) break block3;
                ((InvokeThread.WorkerThreadRequest)object).join();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

