/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/debugger/engine/RemoteDebugProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "myProject", "Lcom/intellij/openapi/project/Project;", "myAutoRestart", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "myClosedByUser", "Ljava/util/concurrent/atomic/AtomicBoolean;", "startNotify", "", "destroyProcessImpl", "detachProcessImpl", "detachIsDefault", "getProcessInput", "Ljava/io/OutputStream;", "intellij.java.debugger.impl"})
public class RemoteDebugProcessHandler
extends ProcessHandler {
    @NotNull
    private final Project myProject;
    private final boolean myAutoRestart;
    @NotNull
    private final AtomicBoolean myClosedByUser;

    @JvmOverloads
    public RemoteDebugProcessHandler(@NotNull Project myProject, boolean myAutoRestart) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myAutoRestart = myAutoRestart;
        this.myClosedByUser = new AtomicBoolean();
    }

    public /* synthetic */ RemoteDebugProcessHandler(Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(project, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNotify() {
        DebugProcessListener listener2 = new DebugProcessAdapterImpl(this){
            final /* synthetic */ RemoteDebugProcessHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void processDetached(DebugProcessImpl process, boolean closedByUser) {
                Intrinsics.checkNotNullParameter((Object)((Object)process), (String)"process");
                if (!RemoteDebugProcessHandler.access$getMyAutoRestart$p(this.this$0) || closedByUser || RemoteDebugProcessHandler.access$getMyClosedByUser$p(this.this$0).get()) {
                    process.removeDebugProcessListener(this);
                    RemoteDebugProcessHandler.access$notifyProcessDetached(this.this$0);
                } else {
                    process.reattach(process.getSession().getDebugEnvironment());
                }
            }
        };
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        debugProcess.addDebugProcessListener(listener2);
        try {
            super.startNotify();
        }
        finally {
            if (debugProcess.isDetached()) {
                debugProcess.removeDebugProcessListener(listener2);
                this.notifyProcessDetached();
            }
        }
    }

    protected void destroyProcessImpl() {
        this.myClosedByUser.set(true);
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(true);
        }
    }

    protected void detachProcessImpl() {
        this.myClosedByUser.set(true);
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(false);
        }
    }

    public boolean detachIsDefault() {
        return true;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    @JvmOverloads
    public RemoteDebugProcessHandler(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this(myProject, false, 2, null);
    }

    public static final /* synthetic */ boolean access$getMyAutoRestart$p(RemoteDebugProcessHandler $this) {
        return $this.myAutoRestart;
    }

    public static final /* synthetic */ AtomicBoolean access$getMyClosedByUser$p(RemoteDebugProcessHandler $this) {
        return $this.myClosedByUser;
    }

    public static final /* synthetic */ void access$notifyProcessDetached(RemoteDebugProcessHandler $this) {
        $this.notifyProcessDetached();
    }
}

