/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.TrackedSteppingData;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.ui.MessageType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\f\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/debugger/engine/SteppingProgressTracker;", "", "debuggerProcessImpl", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "<init>", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "trackedStepping", "", "Lcom/intellij/debugger/engine/TrackedSteppingData;", "isSteppingInProgress", "", "()Z", "isSuspendAllStepping", "onPaused", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContext;", "addStepping", "", "stepCompetedStatus", "Lkotlinx/coroutines/CompletableDeferred;", "filter", "Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "processTheadDeath", "thread", "Lcom/sun/jdi/ThreadReference;", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nSteppingProgressTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteppingProgressTracker.kt\ncom/intellij/debugger/engine/SteppingProgressTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1807#2,3:135\n777#2:138\n873#2,2:139\n777#2:141\n873#2,2:142\n*S KotlinDebug\n*F\n+ 1 SteppingProgressTracker.kt\ncom/intellij/debugger/engine/SteppingProgressTracker\n*L\n38#1:135,3\n44#1:138\n44#1:139,2\n59#1:141\n59#1:142,2\n*E\n"})
public final class SteppingProgressTracker {
    @NotNull
    private final DebugProcessImpl debuggerProcessImpl;
    @NotNull
    private final List<TrackedSteppingData> trackedStepping;

    public SteppingProgressTracker(@NotNull DebugProcessImpl debuggerProcessImpl) {
        Intrinsics.checkNotNullParameter((Object)((Object)debuggerProcessImpl), (String)"debuggerProcessImpl");
        this.debuggerProcessImpl = debuggerProcessImpl;
        this.trackedStepping = new ArrayList();
    }

    public final boolean isSteppingInProgress() {
        return !((Collection)this.trackedStepping).isEmpty();
    }

    public final boolean isSuspendAllStepping() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.trackedStepping;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TrackedSteppingData it = (TrackedSteppingData)element$iv;
                    boolean bl2 = false;
                    if (!it.isSuspendAllStepping()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean onPaused(@NotNull SuspendContext suspendContext) {
        List list;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        ThreadReferenceProxy thread = suspendContext.getThread();
        if (suspendContext.getSuspendPolicy() == 2) {
            list = this.trackedStepping;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.trackedStepping;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TrackedSteppingData it = (TrackedSteppingData)element$iv$iv;
                boolean bl = false;
                if (!it.isFit(thread, (SuspendContextImpl)suspendContext)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List completedSteps = list;
        Iterator<TrackedSteppingData> iterator = completedSteps.iterator();
        while (iterator.hasNext()) {
            CompletableDeferred<Unit> stepCompetedStatus = iterator.next().component1();
            stepCompetedStatus.complete((Object)Unit.INSTANCE);
        }
        this.trackedStepping.removeAll(completedSteps);
        return !((Collection)completedSteps).isEmpty();
    }

    public final void addStepping(@NotNull CompletableDeferred<Unit> stepCompetedStatus, boolean isSuspendAllStepping, @Nullable LightOrRealThreadInfo filter) {
        Intrinsics.checkNotNullParameter(stepCompetedStatus, (String)"stepCompetedStatus");
        this.trackedStepping.add(new TrackedSteppingData(stepCompetedStatus, isSuspendAllStepping, filter));
    }

    /*
     * WARNING - void declaration
     */
    public final void processTheadDeath(@NotNull ThreadReference thread) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Iterable $this$filter$iv = this.trackedStepping;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TrackedSteppingData it = (TrackedSteppingData)element$iv$iv;
            boolean bl = false;
            if (!it.isThreadStepping(thread)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List needToEndTracking = (List)destination$iv$iv;
        if (needToEndTracking.isEmpty()) {
            return;
        }
        for (TrackedSteppingData steppingData : needToEndTracking) {
            steppingData.getStepCompetedStatus().complete((Object)Unit.INSTANCE);
            this.trackedStepping.remove(steppingData);
        }
        String string = JavaDebuggerBundle.message((String)"message.stepping.thread.has.been.stopped", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        notificationGroup.createNotification(message, messageType).notify(this.debuggerProcessImpl.getProject());
    }
}

