/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.statistics.JavaDebuggerEvaluatorStatisticsCollector;
import com.intellij.debugger.ui.impl.watch.EvaluationDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0014\u001a\u00020\u00112\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0015\u0010\u0019\u001a\u00020\u00112\u000b\u0010\u001a\u001a\u00070\u0016\u00a2\u0006\u0002\b\u001bH\u0016J\u001d\u0010\u0019\u001a\u00020\u00112\u000b\u0010\u001a\u001a\u00070\u0016\u00a2\u0006\u0002\b\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0016\u0010\u001c\u001a\u00020\u0011*\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/debugger/engine/evaluation/ReportingEvaluationCallback;", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "Lcom/intellij/xdebugger/Obsolescent;", "project", "Lcom/intellij/openapi/project/Project;", "delegate", "evaluationOrigin", "Lcom/intellij/xdebugger/impl/evaluate/XEvaluationOrigin;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;Lcom/intellij/xdebugger/impl/evaluate/XEvaluationOrigin;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDelegate", "()Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "getEvaluationOrigin", "()Lcom/intellij/xdebugger/impl/evaluate/XEvaluationOrigin;", "evaluated", "", "result", "Lcom/intellij/xdebugger/frame/XValue;", "errorOccurred", "errorMessage", "", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/EvaluationDescriptor;", "invalidExpression", "error", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "logEvaluationResult", "success", "", "isObsolete", "intellij.java.debugger.impl"})
public final class ReportingEvaluationCallback
implements XDebuggerEvaluator.XEvaluationCallback,
Obsolescent {
    @NotNull
    private final Project project;
    @NotNull
    private final XDebuggerEvaluator.XEvaluationCallback delegate;
    @NotNull
    private final XEvaluationOrigin evaluationOrigin;

    public ReportingEvaluationCallback(@NotNull Project project, @NotNull XDebuggerEvaluator.XEvaluationCallback delegate, @NotNull XEvaluationOrigin evaluationOrigin) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)evaluationOrigin, (String)"evaluationOrigin");
        this.project = project;
        this.delegate = delegate;
        this.evaluationOrigin = evaluationOrigin;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final XDebuggerEvaluator.XEvaluationCallback getDelegate() {
        return this.delegate;
    }

    @NotNull
    public final XEvaluationOrigin getEvaluationOrigin() {
        return this.evaluationOrigin;
    }

    public void evaluated(@NotNull XValue result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result instanceof NodeDescriptorProvider) {
            NodeDescriptorImpl nodeDescriptorImpl = ((NodeDescriptorProvider)result).getDescriptor();
            EvaluationDescriptor evaluationDescriptor = nodeDescriptorImpl instanceof EvaluationDescriptor ? (EvaluationDescriptor)nodeDescriptorImpl : null;
            if (evaluationDescriptor != null) {
                this.logEvaluationResult(evaluationDescriptor, true);
            }
        }
        this.delegate.evaluated(result);
    }

    public void errorOccurred(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.delegate.errorOccurred(errorMessage);
    }

    public final void errorOccurred(@NlsContexts.DialogMessage @NotNull String errorMessage, @Nullable EvaluationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.logEvaluationResult(descriptor, false);
        this.errorOccurred(errorMessage);
    }

    public void invalidExpression(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.delegate.invalidExpression(error);
    }

    public final void invalidExpression(@NotNull String error, @Nullable EvaluationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.logEvaluationResult(descriptor, false);
        this.invalidExpression(error);
    }

    private final void logEvaluationResult(EvaluationDescriptor $this$logEvaluationResult, boolean success) {
        EvaluationDescriptor evaluationDescriptor = $this$logEvaluationResult;
        ExpressionEvaluator evaluator = evaluationDescriptor != null ? evaluationDescriptor.getUserData(EvaluationDescriptor.EXPRESSION_EVALUATOR_KEY) : null;
        JavaDebuggerEvaluatorStatisticsCollector.logEvaluationResult(this.project, evaluator, success, this.evaluationOrigin);
    }

    public boolean isObsolete() {
        return this.delegate instanceof Obsolescent && ((Obsolescent)this.delegate).isObsolete();
    }
}

