/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;

class LiteralEvaluator
implements Evaluator {
    private final Object myValue;
    private final String myExpectedType;

    LiteralEvaluator(Object value, String expectedType) {
        this.myValue = value;
        this.myExpectedType = expectedType;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (this.myValue == null) {
            return null;
        }
        VirtualMachineProxyImpl vm = context.getVirtualMachineProxy();
        if (this.myValue instanceof Boolean) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, (Boolean)this.myValue);
        }
        if (this.myValue instanceof Character) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Character)this.myValue).charValue());
        }
        if (this.myValue instanceof Double) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).doubleValue());
        }
        if (this.myValue instanceof Float) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).floatValue());
        }
        if (this.myValue instanceof Number) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).longValue());
        }
        Object object = this.myValue;
        if (object instanceof String) {
            String stringValue = (String)object;
            return vm.mirrorOfStringLiteral(stringValue, context);
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{this.myExpectedType}));
    }

    public String toString() {
        return this.myValue != null ? this.myValue.toString() : "null";
    }
}

