/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableValue;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntheticVariableEvaluator
implements ModifiableEvaluator {
    private static final Logger LOG = Logger.getInstance(SyntheticVariableEvaluator.class);
    private final CodeFragmentEvaluator myCodeFragmentEvaluator;
    private final String myLocalName;
    private final JVMName myTypeName;
    @Deprecated
    private String myTypeNameString = null;

    public SyntheticVariableEvaluator(CodeFragmentEvaluator codeFragmentEvaluator, String localName, @Nullable JVMName typeName) {
        this.myCodeFragmentEvaluator = codeFragmentEvaluator;
        this.myLocalName = localName;
        this.myTypeName = typeName;
    }

    @Override
    @NotNull
    public ModifiableValue evaluateModifiable(EvaluationContextImpl context) throws EvaluateException {
        String typeNameString;
        this.myTypeNameString = typeNameString = this.myTypeName != null ? this.myTypeName.getName(context.getDebugProcess()) : null;
        return new ModifiableValue(this.myCodeFragmentEvaluator.getValue(this.myLocalName, context), new MyModifier(typeNameString));
    }

    @Override
    public Modifier getModifier() {
        return new MyModifier(this.myTypeNameString);
    }

    public String toString() {
        return this.myLocalName;
    }

    private class MyModifier
    implements Modifier {
        private final String myTypeNameString;

        private MyModifier(String typeNameString) {
            this.myTypeNameString = typeNameString;
        }

        public boolean canInspect() {
            return false;
        }

        public boolean canSetValue() {
            return false;
        }

        public void setValue(Value value) throws EvaluateException {
            if (value == null) {
                if (this.myTypeNameString != null && DebuggerUtils.isPrimitiveType((String)this.myTypeNameString)) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.set.primitive.to.null", (Object[])new Object[0]));
                }
            } else {
                Type type = value.type();
                if (this.myTypeNameString != null && !DebuggerUtils.instanceOf((Type)type, (String)this.myTypeNameString)) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.cast.object", (Object[])new Object[]{type.name(), this.myTypeNameString}));
                }
            }
            SyntheticVariableEvaluator.this.myCodeFragmentEvaluator.setValue(SyntheticVariableEvaluator.this.myLocalName, value);
        }

        public Type getExpectedType() {
            LOG.assertTrue(false);
            return null;
        }

        public NodeDescriptorImpl getInspectItem(Project project) {
            return null;
        }
    }
}

