/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.hotswap.HotSwapFailureReason;
import com.intellij.xdebugger.impl.hotswap.HotSwapStatistics;
import com.jetbrains.jdi.JDWPUnsupportedOperationException;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

class ReloadClassesWorker {
    private static final Logger LOG = Logger.getInstance(ReloadClassesWorker.class);
    @NotNull
    private final DebuggerSession myDebuggerSession;
    @NotNull
    private final HotSwapProgress myProgress;

    ReloadClassesWorker(@NotNull DebuggerSession session, @NotNull HotSwapProgress progress) {
        if (session == null) {
            ReloadClassesWorker.$$$reportNull$$$0(0);
        }
        if (progress == null) {
            ReloadClassesWorker.$$$reportNull$$$0(1);
        }
        this.myDebuggerSession = session;
        this.myProgress = progress;
    }

    private void processException(@NotNull Throwable e) {
        if (e == null) {
            ReloadClassesWorker.$$$reportNull$$$0(2);
        }
        if (e instanceof ProcessCanceledException) {
            this.myProgress.addMessage(this.myDebuggerSession, 3, JavaDebuggerBundle.message((String)"error.operation.canceled", (Object[])new Object[0]));
            return;
        }
        String reason = e.getLocalizedMessage();
        HotSwapFailureReason failureReason = ReloadClassesWorker.getFailureReason(e);
        HotSwapStatistics.logFailureReason((Project)this.myProgress.getProject(), (HotSwapFailureReason)failureReason);
        String message = e instanceof UnsupportedOperationException ? JavaDebuggerBundle.message((String)"error.operation.not.supported.by.vm", (Object[])new Object[]{reason}) : (e instanceof NoClassDefFoundError ? JavaDebuggerBundle.message((String)"error.class.def.not.found", (Object[])new Object[]{reason}) : (e instanceof VerifyError ? JavaDebuggerBundle.message((String)"error.verification.error", (Object[])new Object[]{reason}) : (e instanceof UnsupportedClassVersionError ? JavaDebuggerBundle.message((String)"error.unsupported.class.version", (Object[])new Object[]{reason}) : (e instanceof ClassFormatError ? JavaDebuggerBundle.message((String)"error.class.format.error", (Object[])new Object[]{reason}) : (e instanceof ClassCircularityError ? JavaDebuggerBundle.message((String)"error.class.circularity.error", (Object[])new Object[]{reason}) : JavaDebuggerBundle.message((String)"error.exception.while.reloading", (Object[])new Object[]{e.getClass().getName(), reason}))))));
        this.myProgress.addMessage(this.myDebuggerSession, 4, message);
    }

    @NotNull
    private static HotSwapFailureReason getFailureReason(Throwable e) {
        if (!(e instanceof JDWPUnsupportedOperationException)) {
            HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.OTHER;
            if (hotSwapFailureReason == null) {
                ReloadClassesWorker.$$$reportNull$$$0(3);
            }
            return hotSwapFailureReason;
        }
        JDWPUnsupportedOperationException exception = (JDWPUnsupportedOperationException)e;
        switch (exception.getErrorCode()) {
            case 63: {
                HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.METHOD_ADDED;
                if (hotSwapFailureReason == null) {
                    ReloadClassesWorker.$$$reportNull$$$0(4);
                }
                return hotSwapFailureReason;
            }
            case 67: {
                HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.METHOD_REMOVED;
                if (hotSwapFailureReason == null) {
                    ReloadClassesWorker.$$$reportNull$$$0(5);
                }
                return hotSwapFailureReason;
            }
            case 64: {
                HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.SIGNATURE_MODIFIED;
                if (hotSwapFailureReason == null) {
                    ReloadClassesWorker.$$$reportNull$$$0(6);
                }
                return hotSwapFailureReason;
            }
            case 66: {
                HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.STRUCTURE_MODIFIED;
                if (hotSwapFailureReason == null) {
                    ReloadClassesWorker.$$$reportNull$$$0(7);
                }
                return hotSwapFailureReason;
            }
            case 70: {
                HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.CLASS_MODIFIERS_CHANGED;
                if (hotSwapFailureReason == null) {
                    ReloadClassesWorker.$$$reportNull$$$0(8);
                }
                return hotSwapFailureReason;
            }
            case 71: {
                HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.METHOD_MODIFIERS_CHANGED;
                if (hotSwapFailureReason == null) {
                    ReloadClassesWorker.$$$reportNull$$$0(9);
                }
                return hotSwapFailureReason;
            }
            case 72: {
                HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.CLASS_ATTRIBUTES_CHANGED;
                if (hotSwapFailureReason == null) {
                    ReloadClassesWorker.$$$reportNull$$$0(10);
                }
                return hotSwapFailureReason;
            }
        }
        HotSwapFailureReason hotSwapFailureReason = HotSwapFailureReason.OTHER;
        if (hotSwapFailureReason == null) {
            ReloadClassesWorker.$$$reportNull$$$0(11);
        }
        return hotSwapFailureReason;
    }

    public void reloadClasses(@NotNull @NotNull Map<@NotNull String, @NotNull HotSwapFile> modifiedClasses) {
        if (modifiedClasses == null) {
            ReloadClassesWorker.$$$reportNull$$$0(12);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (modifiedClasses.isEmpty()) {
            this.myProgress.addMessage(this.myDebuggerSession, 3, JavaDebuggerBundle.message((String)"status.hotswap.loaded.classes.up.to.date", (Object[])new Object[0]));
            return;
        }
        DebugProcessImpl debugProcess = this.myDebuggerSession.getProcess();
        VirtualMachineProxyImpl virtualMachineProxy = VirtualMachineProxyImpl.getCurrent();
        Project project = debugProcess.getProject();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
        breakpointManager.disableBreakpoints(debugProcess);
        StackCapturingLineBreakpoint.deleteAll(debugProcess);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Threads before hotswap:\n", new Object[]{StreamEx.of(ThreadDumpAction.buildThreadStates(virtualMachineProxy)).map(ThreadState::getStackTrace).joining((CharSequence)"\n")});
        }
        if (Registry.is((String)"debugger.resume.yourkit.threads")) {
            virtualMachineProxy.allThreads().stream().filter(ThreadReferenceProxyImpl::isResumeOnHotSwap).filter(ThreadReferenceProxyImpl::isSuspended).forEach(t -> IntStream.range(0, t.getSuspendCount()).forEach(i -> {
                t.setIgnoreModelSuspendCount(true);
                t.resume();
            }));
        }
        try {
            RedefineProcessor redefineProcessor = new RedefineProcessor(virtualMachineProxy);
            int processedEntriesCount = 0;
            for (Map.Entry<String, HotSwapFile> entry : modifiedClasses.entrySet()) {
                if (debugProcess.isDetached() || debugProcess.isDetaching() || redefineProcessor.mayCancel() && this.myProgress.isCancelled()) break;
                String qualifiedName = entry.getKey();
                this.myProgress.setText(qualifiedName);
                this.myProgress.setFraction((double)(++processedEntriesCount) / (double)modifiedClasses.size());
                try {
                    redefineProcessor.processClass(qualifiedName, entry.getValue().file);
                }
                catch (IOException e) {
                    this.reportProblem(qualifiedName, e);
                }
            }
            if (redefineProcessor.mayCancel() && this.myProgress.isCancelled()) {
                return;
            }
            redefineProcessor.processPending();
            this.myProgress.setFraction(1.0);
            int partiallyRedefinedClassesCount = redefineProcessor.getPartiallyRedefinedClassesCount();
            if (partiallyRedefinedClassesCount == 0) {
                if (!Registry.is((String)"debugger.hotswap.floating.toolbar")) {
                    this.myProgress.addMessage(this.myDebuggerSession, 3, JavaDebuggerBundle.message((String)"status.classes.reloaded", (Object[])new Object[]{redefineProcessor.getProcessedClassesCount()}));
                }
            } else {
                String message = JavaDebuggerBundle.message((String)"status.classes.not.all.versions.reloaded", (Object[])new Object[]{partiallyRedefinedClassesCount, redefineProcessor.getProcessedClassesCount()});
                this.myProgress.addMessage(this.myDebuggerSession, 5, message);
            }
            LOG.debug("classes reloaded");
        }
        catch (Throwable e) {
            this.processException(e);
        }
        debugProcess.onHotSwapFinished();
        Semaphore waitSemaphore = new Semaphore();
        waitSemaphore.down();
        DebuggerInvocationUtil.invokeLaterAnyModality(() -> {
            try {
                if (!project.isDisposed()) {
                    debugProcess.getRequestsManager().clearWarnings();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("requests updated");
                        LOG.debug("time stamp set");
                    }
                    this.myDebuggerSession.refresh(false);
                    XDebugSession session = this.myDebuggerSession.getXDebugSession();
                    if (session != null) {
                        session.rebuildViews();
                    }
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            finally {
                waitSemaphore.up();
            }
        });
        waitSemaphore.waitFor();
        if (!project.isDisposed()) {
            try {
                breakpointManager.enableBreakpoints(debugProcess);
                StackCapturingLineBreakpoint.createAll(debugProcess);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
    }

    private void reportProblem(String qualifiedName, @Nullable Exception ex) {
        String reason;
        String string = reason = ex != null ? ex.getLocalizedMessage() : null;
        if (reason == null || reason.isEmpty()) {
            reason = JavaDebuggerBundle.message((String)"error.io.error", (Object[])new Object[0]);
        }
        this.myProgress.addMessage(this.myDebuggerSession, 4, qualifiedName + " : " + reason);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/ReloadClassesWorker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/ReloadClassesWorker";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailureReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processException";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reloadClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static class RedefineProcessor {
        private static final int CLASSES_CHUNK_SIZE = 100;
        @NotNull
        private final VirtualMachineProxyImpl myVirtualMachineProxy;
        @NotNull
        private final @NotNull Map<@NotNull ReferenceType, byte @NotNull []> myRedefineMap;
        private @Range(from=0L, to=0x7FFFFFFFL) int myProcessedClassesCount;
        private @Range(from=0L, to=0x7FFFFFFFL) int myPartiallyRedefinedClassesCount;

        RedefineProcessor(@NotNull VirtualMachineProxyImpl virtualMachineProxy) {
            if (virtualMachineProxy == null) {
                RedefineProcessor.$$$reportNull$$$0(0);
            }
            this.myRedefineMap = new HashMap<ReferenceType, byte[]>();
            this.myVirtualMachineProxy = virtualMachineProxy;
        }

        public void processClass(@NotNull String qualifiedName, @NotNull File file) throws IOException, LinkageError, UnsupportedOperationException {
            List<ReferenceType> vmClasses;
            if (qualifiedName == null) {
                RedefineProcessor.$$$reportNull$$$0(1);
            }
            if (file == null) {
                RedefineProcessor.$$$reportNull$$$0(2);
            }
            if ((vmClasses = this.myVirtualMachineProxy.classesByName(qualifiedName)).isEmpty()) {
                return;
            }
            byte[] content = FileUtil.loadFileBytes((File)file);
            if (vmClasses.size() == 1) {
                this.myRedefineMap.put(vmClasses.get(0), content);
                if (this.myRedefineMap.size() >= 100) {
                    this.processChunk();
                }
                return;
            }
            int redefinedVersionsCount = 0;
            LinkageError error = null;
            UnsupportedOperationException exception = null;
            for (ReferenceType vmClass : vmClasses) {
                try {
                    this.myVirtualMachineProxy.redefineClasses(Collections.singletonMap(vmClass, content));
                    ++redefinedVersionsCount;
                }
                catch (LinkageError e) {
                    error = e;
                }
                catch (UnsupportedOperationException e) {
                    exception = e;
                }
            }
            if (redefinedVersionsCount == 0) {
                if (error != null) {
                    throw error;
                }
                assert (exception != null);
                throw exception;
            }
            if (redefinedVersionsCount < vmClasses.size()) {
                ++this.myPartiallyRedefinedClassesCount;
            }
            ++this.myProcessedClassesCount;
        }

        public void processPending() throws LinkageError, UnsupportedOperationException {
            if (!this.myRedefineMap.isEmpty()) {
                this.processChunk();
            }
        }

        private void processChunk() throws LinkageError, UnsupportedOperationException {
            try {
                this.myVirtualMachineProxy.redefineClasses(this.myRedefineMap);
                this.myProcessedClassesCount += this.myRedefineMap.size();
            }
            finally {
                this.myRedefineMap.clear();
            }
        }

        public boolean mayCancel() {
            return this.myProcessedClassesCount == 0;
        }

        public int getProcessedClassesCount() {
            return this.myProcessedClassesCount;
        }

        public int getPartiallyRedefinedClassesCount() {
            return this.myPartiallyRedefinedClassesCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualMachineProxy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/impl/ReloadClassesWorker$RedefineProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

