/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.project.Project;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class StackFrameData
extends DescriptorData<StackFrameDescriptorImpl> {
    private final StackFrameProxyImpl myFrame;
    private final FrameDisplayKey myDisplayKey;

    public StackFrameData(@NotNull StackFrameProxyImpl frame) {
        if (frame == null) {
            StackFrameData.$$$reportNull$$$0(0);
        }
        this.myFrame = frame;
        this.myDisplayKey = new FrameDisplayKey(NodeManagerImpl.getContextKeyForFrame(frame));
    }

    @Override
    protected StackFrameDescriptorImpl createDescriptorImpl(@NotNull Project project) {
        if (project == null) {
            StackFrameData.$$$reportNull$$$0(1);
        }
        return new StackFrameDescriptorImpl(this.myFrame);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof StackFrameData)) {
            return false;
        }
        return ((StackFrameData)object).myFrame == this.myFrame;
    }

    @Override
    public int hashCode() {
        return this.myFrame.hashCode();
    }

    @Override
    public DisplayKey<StackFrameDescriptorImpl> getDisplayKey() {
        return this.myDisplayKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/impl/descriptors/data/StackFrameData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createDescriptorImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FrameDisplayKey
    implements DisplayKey<StackFrameDescriptorImpl> {
        private final String myContextKey;

        FrameDisplayKey(String contextKey) {
            this.myContextKey = contextKey;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrameDisplayKey that = (FrameDisplayKey)o;
            return Objects.equals(this.myContextKey, that.myContextKey);
        }

        @Override
        public int hashCode() {
            return this.myContextKey == null ? 0 : this.myContextKey.hashCode();
        }
    }
}

