/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.hotswap;

import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.hotswap.FileExtensionFilter;
import com.intellij.debugger.impl.hotswap.InProjectFilter;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmMetaLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.hotswap.HotSwapProvider;
import com.intellij.xdebugger.hotswap.HotSwapSession;
import com.intellij.xdebugger.hotswap.SourceFileChangesCollector;
import com.intellij.xdebugger.hotswap.SourceFileChangesListener;
import com.intellij.xdebugger.impl.hotswap.SourceFileChangeFilter;
import com.intellij.xdebugger.impl.hotswap.SourceFileChangesCollectorImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/debugger/impl/hotswap/JvmHotSwapProvider;", "Lcom/intellij/xdebugger/hotswap/HotSwapProvider;", "Lcom/intellij/openapi/vfs/VirtualFile;", "debuggerSession", "Lcom/intellij/debugger/impl/DebuggerSession;", "<init>", "(Lcom/intellij/debugger/impl/DebuggerSession;)V", "createChangesCollector", "Lcom/intellij/xdebugger/hotswap/SourceFileChangesCollector;", "session", "Lcom/intellij/xdebugger/hotswap/HotSwapSession;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "listener", "Lcom/intellij/xdebugger/hotswap/SourceFileChangesListener;", "performHotSwap", "", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nJvmHotSwapProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmHotSwapProvider.kt\ncom/intellij/debugger/impl/hotswap/JvmHotSwapProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,48:1\n1642#2,10:49\n1915#2:59\n1916#2:61\n1652#2:62\n1#3:60\n37#4,2:63\n*S KotlinDebug\n*F\n+ 1 JvmHotSwapProvider.kt\ncom/intellij/debugger/impl/hotswap/JvmHotSwapProvider\n*L\n27#1:49,10\n27#1:59\n27#1:61\n27#1:62\n27#1:60\n36#1:63,2\n*E\n"})
public final class JvmHotSwapProvider
implements HotSwapProvider<VirtualFile> {
    @NotNull
    private final DebuggerSession debuggerSession;

    public JvmHotSwapProvider(@NotNull DebuggerSession debuggerSession) {
        Intrinsics.checkNotNullParameter((Object)debuggerSession, (String)"debuggerSession");
        this.debuggerSession = debuggerSession;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SourceFileChangesCollector<VirtualFile> createChangesCollector(@NotNull HotSwapSession<VirtualFile> session, @NotNull CoroutineScope coroutineScope, @NotNull SourceFileChangesListener listener2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Collection collection = ((JvmMetaLanguage)Language.findInstance(JvmMetaLanguage.class)).getMatchingLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getMatchingLanguages(...)");
        SourceFileChangeFilter[] sourceFileChangeFilterArray = (SourceFileChangeFilter[])collection;
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Language it = (Language)element$iv$iv;
            boolean bl2 = false;
            LanguageFileType languageFileType = it.getAssociatedFileType();
            if ((languageFileType != null ? languageFileType.getDefaultExtension() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List jvmExtensions = (List)destination$iv$iv;
        sourceFileChangeFilterArray = new SourceFileChangeFilter[]{new FileExtensionFilter(jvmExtensions), new InProjectFilter(session.getProject())};
        return (SourceFileChangesCollector)new SourceFileChangesCollectorImpl(coroutineScope, listener2, sourceFileChangeFilterArray);
    }

    public void performHotSwap(@NotNull HotSwapSession<VirtualFile> session) {
        Intrinsics.checkNotNullParameter(session, (String)"session");
        Collection $this$toTypedArray$iv = session.getChanges();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        HotSwapUI.getInstance(session.getProject()).compileAndReload(this.debuggerSession, Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }
}

