/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyEx;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class StackFrameProxyImpl
extends JdiProxy
implements StackFrameProxyEx {
    private static final Logger LOG = Logger.getInstance(StackFrameProxyImpl.class);
    public static final int FRAMES_BATCH_MAX = 20;
    private final ThreadReferenceProxyImpl myThreadProxy;
    private final int myFrameFromBottomIndex;
    private volatile int myFrameIndex;
    private volatile StackFrame myStackFrame;
    private ObjectReference myThisReference;
    private ClassLoaderReference myClassLoader;
    private volatile ThreeState myIsObsolete;
    private Map<LocalVariable, Value> myAllValues;

    public StackFrameProxyImpl(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull StackFrame frame, int fromBottomIndex) {
        if (threadProxy == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(1);
        }
        super(threadProxy.getVirtualMachine());
        this.myFrameIndex = -1;
        this.myIsObsolete = ThreeState.UNSURE;
        this.myThreadProxy = threadProxy;
        this.myFrameFromBottomIndex = fromBottomIndex;
        this.myStackFrame = frame;
    }

    public CompletableFuture<Boolean> isObsolete() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.getVirtualMachine().canRedefineClasses()) {
            return CompletableFuture.completedFuture(false);
        }
        this.checkValid();
        if (this.myIsObsolete != ThreeState.UNSURE) {
            return CompletableFuture.completedFuture(this.myIsObsolete.toBoolean());
        }
        return ((CompletableFuture)DebuggerUtilsAsync.method(this.location()).thenCompose(method -> {
            if (method == null) {
                this.myIsObsolete = ThreeState.YES;
                return CompletableFuture.completedFuture(true);
            }
            return DebuggerUtilsAsync.isObsolete(method).thenApply(res -> {
                this.myIsObsolete = ThreeState.fromBoolean((boolean)res);
                return res;
            });
        })).exceptionally(throwable -> {
            Throwable exception = DebuggerUtilsAsync.unwrap(throwable);
            if (exception instanceof InternalException && ((InternalException)exception).errorCode() == 23) {
                this.myIsObsolete = ThreeState.YES;
                return true;
            }
            throw (RuntimeException)throwable;
        });
    }

    @Override
    @TestOnly
    public boolean isValid() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!super.isValid()) {
            return false;
        }
        try {
            if (this.myStackFrame != null) {
                this.myStackFrame.location();
            }
            return true;
        }
        catch (InvalidStackFrameException e) {
            return false;
        }
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("caches cleared " + super.toString());
        }
        this.myFrameIndex = -1;
        this.myStackFrame = null;
        this.myIsObsolete = ThreeState.UNSURE;
        this.myThisReference = null;
        this.myClassLoader = null;
        this.myAllValues = null;
    }

    public StackFrame getStackFrame() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myStackFrame == null) {
            try {
                ThreadReference threadRef = this.myThreadProxy.getThreadReference();
                int index = this.getFrameIndex();
                this.myStackFrame = index > 0 && index < 20 ? threadRef.frames(0, Math.min(this.myThreadProxy.frameCount(), 20)).get(index) : threadRef.frame(index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new EvaluateException(e.getMessage(), (Throwable)e);
            }
            catch (ObjectCollectedException ignored) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.thread.collected", (Object[])new Object[0]));
            }
            catch (IncompatibleThreadStateException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        return this.myStackFrame;
    }

    public CompletableFuture<StackFrame> getStackFrameAsync() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myStackFrame == null) {
            ThreadReference threadRef = this.myThreadProxy.getThreadReference();
            return ((CompletableFuture)this.getFrameIndexAsync().thenCompose(index -> {
                if (index > 0 && index < 20) {
                    try {
                        return DebuggerUtilsAsync.frames(threadRef, 0, Math.min(this.myThreadProxy.frameCount(), 20)).thenApply(frames -> {
                            this.myStackFrame = (StackFrame)frames.get((int)index);
                            return this.myStackFrame;
                        });
                    }
                    catch (EvaluateException e) {
                        return CompletableFuture.failedFuture(e);
                    }
                }
                return DebuggerUtilsAsync.frame(threadRef, index).thenApply(f -> {
                    this.myStackFrame = f;
                    return this.myStackFrame;
                });
            })).exceptionally(throwable -> {
                if (DebuggerUtilsAsync.unwrap(throwable) instanceof ObjectCollectedException) {
                    throw new CompletionException(EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.thread.collected", (Object[])new Object[0])));
                }
                throw (RuntimeException)throwable;
            });
        }
        return CompletableFuture.completedFuture(this.myStackFrame);
    }

    public int getFrameIndex() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameIndex == -1) {
            int count = this.myThreadProxy.frameCount();
            if (this.myFrameFromBottomIndex > count) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
            this.myFrameIndex = count - this.myFrameFromBottomIndex;
        }
        return this.myFrameIndex;
    }

    public CompletableFuture<Integer> getFrameIndexAsync() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameIndex == -1) {
            return this.myThreadProxy.frameCountAsync().thenApply(count -> {
                if (this.myFrameFromBottomIndex > count) {
                    throw new CompletionException(EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException()));
                }
                this.myFrameIndex = count - this.myFrameFromBottomIndex;
                return this.myFrameIndex;
            });
        }
        return CompletableFuture.completedFuture(this.myFrameIndex);
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
        if (virtualMachineProxyImpl == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(2);
        }
        return virtualMachineProxyImpl;
    }

    public Location location() throws EvaluateException {
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                return this.getStackFrame().location();
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    public CompletableFuture<Location> locationAsync() {
        return this.locationAsync(1);
    }

    private CompletableFuture<Location> locationAsync(int attempt) {
        return this.getStackFrameAsync().thenCompose(frame -> {
            try {
                return CompletableFuture.completedFuture(frame.location());
            }
            catch (InvalidStackFrameException e) {
                if (attempt > 0) {
                    return this.locationAsync(attempt - 1);
                }
                throw new CompletionException(new EvaluateException(e.getMessage(), (Throwable)e));
            }
        });
    }

    @NotNull
    public ThreadReferenceProxyImpl threadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.myThreadProxy;
        if (threadReferenceProxyImpl == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(3);
        }
        return threadReferenceProxyImpl;
    }

    @NonNls
    public String toString() {
        try {
            return "StackFrameProxyImpl: " + this.getStackFrame().toString();
        }
        catch (EvaluateException e) {
            return "StackFrameProxyImpl: " + e.getMessage() + "; frameFromBottom = " + this.myFrameFromBottomIndex + " threadName = " + this.threadProxy().name();
        }
    }

    @Override
    @Nullable
    public ObjectReference thisObject() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        try {
            for (int attempt = 0; attempt < 2; ++attempt) {
                try {
                    if (this.myThisReference == null) {
                        this.myThisReference = this.getStackFrame().thisObject();
                    }
                    break;
                }
                catch (InvalidStackFrameException ignored) {
                    this.clearCaches();
                    continue;
                }
            }
        }
        catch (InternalException e) {
            if (e.errorCode() != 23 && e.errorCode() != 35) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            LOG.info("Exception while getting this object", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Exception while getting this object", (Throwable)e);
        }
        catch (Exception e) {
            if (!this.getVirtualMachine().canBeModified()) {
                LOG.debug((Throwable)e);
            }
            throw e;
        }
        return this.myThisReference;
    }

    @NotNull
    public List<LocalVariableProxyImpl> visibleVariables() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            ArrayList<LocalVariableProxyImpl> arrayList;
            try {
                List<LocalVariable> list = this.getStackFrame().visibleVariables();
                ArrayList<LocalVariableProxyImpl> locals = new ArrayList<LocalVariableProxyImpl>(list.size());
                for (LocalVariable localVariable : list) {
                    LOG.assertTrue(localVariable != null);
                    locals.add(new LocalVariableProxyImpl(this, localVariable));
                }
                arrayList = locals;
            }
            catch (InvalidStackFrameException | IllegalArgumentException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (AbsentInformationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            if (arrayList == null) {
                StackFrameProxyImpl.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    public LocalVariableProxyImpl visibleVariableByName(String name) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LocalVariable variable = this.visibleVariableByNameInt(name);
        return variable != null ? new LocalVariableProxyImpl(this, variable) : null;
    }

    @Nullable
    public Value visibleValueByName(@NotNull String name) throws EvaluateException {
        LocalVariable variable;
        if (name == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(5);
        }
        return (variable = this.visibleVariableByNameInt(name)) != null ? this.getValue(new LocalVariableProxyImpl(this, variable)) : null;
    }

    protected LocalVariable visibleVariableByNameInt(String name) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                return this.getStackFrame().visibleVariableByName(name);
            }
            catch (InvalidStackFrameException e) {
                try {
                    error = e;
                    this.clearCaches();
                    continue;
                }
                catch (AbsentInformationException | InvalidStackFrameException e2) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e2);
                }
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    @Override
    public Value getVariableValue(@NotNull LocalVariableProxy localVariable) throws EvaluateException {
        if (localVariable == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(6);
        }
        if (localVariable instanceof LocalVariableProxyImpl) {
            return this.getValue((LocalVariableProxyImpl)localVariable);
        }
        throw new EvaluateException("Variable doesn't belong to this frame: " + String.valueOf(localVariable));
    }

    public Value getValue(LocalVariableProxyImpl localVariable) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                Map<LocalVariable, Value> values;
                LocalVariable variable = localVariable.getVariable();
                try {
                    values = this.getAllValues();
                }
                catch (InconsistentDebugInfoException ignored) {
                    return this.getSingleValue(variable);
                }
                if (values.containsKey(variable)) {
                    return values.get(variable);
                }
                return this.getSingleValue(variable);
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (InconsistentDebugInfoException ignored) {
                this.clearCaches();
                throw EvaluateExceptionUtil.INCONSISTEND_DEBUG_INFO;
            }
            catch (InternalException e) {
                if (e.errorCode() == 35 || e.errorCode() == 101) {
                    throw new EvaluateException(JavaDebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
                throw e;
            }
            catch (Exception e) {
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug((Throwable)e);
                    throw new EvaluateException("Debug data corrupted");
                }
                throw e;
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    private Value getSingleValue(@NotNull LocalVariable variable) throws EvaluateException {
        if (variable == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(7);
        }
        return this.getStackFrame().getValue(variable);
    }

    @NotNull
    public List<Value> getArgumentValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            List list;
            try {
                StackFrame stackFrame = this.getStackFrame();
                list = stackFrame != null ? ContainerUtil.notNullize(DebuggerUtilsEx.getArgumentValues(stackFrame)) : Collections.emptyList();
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            if (list == null) {
                StackFrameProxyImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    private Map<LocalVariable, Value> getAllValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myAllValues == null) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                this.myAllValues = new HashMap<LocalVariable, Value>(stackFrame.getValues(stackFrame.visibleVariables()));
            }
            catch (AbsentInformationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (InternalException e) {
                if (e.errorCode() == 35 || e.errorCode() == 101) {
                    LOG.info((Throwable)e);
                    this.myAllValues = new HashMap<LocalVariable, Value>();
                }
                throw e;
            }
            catch (Exception e) {
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug((Throwable)e);
                    this.myAllValues = new HashMap<LocalVariable, Value>();
                }
                throw e;
            }
        }
        return this.myAllValues;
    }

    public void setValue(LocalVariableProxyImpl localVariable, Value value) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                LocalVariable variable = localVariable.getVariable();
                StackFrame stackFrame = this.getStackFrame();
                stackFrame.setValue(variable, value);
                if (this.myAllValues != null) {
                    this.myAllValues.put(variable, stackFrame.getValue(variable));
                }
                return;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    public int hashCode() {
        return 31 * this.myThreadProxy.hashCode() + this.myFrameFromBottomIndex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackFrameProxyImpl)) {
            return false;
        }
        StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)obj;
        if (frameProxy == this) {
            return true;
        }
        return this.myFrameFromBottomIndex == frameProxy.myFrameFromBottomIndex && this.myThreadProxy.equals(frameProxy.myThreadProxy);
    }

    public boolean isLocalVariableVisible(LocalVariableProxyImpl var) throws EvaluateException {
        try {
            return var.getVariable().isVisible(this.getStackFrame());
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    public ClassLoaderReference getClassLoader() throws EvaluateException {
        if (this.myClassLoader == null) {
            this.myClassLoader = this.location().declaringType().classLoader();
        }
        return this.myClassLoader;
    }

    public boolean isBottom() {
        return this.myFrameFromBottomIndex == 1;
    }

    public int getIndexFromBottom() {
        return this.myFrameFromBottomIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/StackFrameProxyImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVariable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/StackFrameProxyImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "threadProxy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "visibleVariables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visibleValueByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSingleValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8 -> new IllegalStateException(string);
        };
    }
}

