/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentActionResult;
import com.intellij.debugger.memory.agent.ui.RetainedSizeDialog;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.ObjectReference;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CalculateRetainedSizeActionUtil {
    private static final Logger LOG = Logger.getInstance(CalculateRetainedSizeActionUtil.class);

    public static void showDialog(@NotNull XValue xValue, @NotNull String nodeName, DebugProcessImpl debugProcess) {
        if (xValue == null) {
            CalculateRetainedSizeActionUtil.$$$reportNull$$$0(0);
        }
        if (nodeName == null) {
            CalculateRetainedSizeActionUtil.$$$reportNull$$$0(1);
        }
        final ObjectReference reference = DebuggerTreeAction.getObjectReference(xValue);
        if (debugProcess == null || reference == null) {
            return;
        }
        XDebugSession session = debugProcess.getSession().getXDebugSession();
        if (session == null) {
            return;
        }
        final RetainedSizeDialog dialog = new RetainedSizeDialog(session.getProject(), session.getDebugProcess().getEditorsProvider(), session.getCurrentPosition(), nodeName, xValue, ((XDebugSessionImpl)session).getValueMarkers(), session, true);
        dialog.show();
        SuspendContextImpl suspendContext = debugProcess.getSuspendManager().getPausedContext();
        suspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    if (dialog.isDisposed()) {
                        return;
                    }
                    EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
                    MemoryAgent memoryAgent = MemoryAgent.get(evaluationContext);
                    if (memoryAgent.isDisabled()) {
                        dialog.setAgentCouldntBeLoadedMessage();
                        return;
                    }
                    Disposer.register((Disposable)dialog.getDisposable(), () -> memoryAgent.cancelAction());
                    memoryAgent.setProgressIndicator(dialog.createProgressIndicator());
                    MemoryAgentActionResult<Pair<long[], ObjectReference[]>> result = memoryAgent.estimateObjectSize(evaluationContext, reference, Registry.get((String)"debugger.memory.agent.action.timeout").asInteger());
                    if (dialog.isDisposed()) {
                        return;
                    }
                    1.interpretResult(result, dialog);
                }
                catch (EvaluateException e) {
                    XDebuggerManagerImpl.getNotificationGroup().createNotification(JavaDebuggerBundle.message((String)"action.failed", (Object[])new Object[0]), NotificationType.ERROR);
                }
            }

            private static void interpretResult(@NotNull MemoryAgentActionResult<Pair<long[], ObjectReference[]>> result, @NotNull RetainedSizeDialog dialog2) {
                if (result == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (dialog2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (result.executedSuccessfully()) {
                    Pair<long[], ObjectReference[]> sizesAndHeldObjects = result.getResult();
                    long[] sizes = (long[])sizesAndHeldObjects.getFirst();
                    dialog2.setHeldObjectsAndSizes(Arrays.asList((ObjectReference[])sizesAndHeldObjects.getSecond()), sizes[0], sizes[1]);
                } else {
                    dialog2.setCalculationTimeoutMessage();
                }
            }

            @Override
            public void commandCancelled() {
                LOG.info("command cancelled");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dialog";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/memory/action/CalculateRetainedSizeActionUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contextAction";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "interpretResult";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "xValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeName";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/memory/action/CalculateRetainedSizeActionUtil";
        objectArray[2] = "showDialog";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

