/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.google.gson.Gson;
import com.intellij.openapi.util.InvalidDataException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class MemoryAgentProgressPoint {
    private final String message;
    private final int minValue;
    private final int maxValue;
    private final int currentValue;

    private MemoryAgentProgressPoint(@NotNull String message, int minValue, int maxValue, int currentValue) {
        if (message == null) {
            MemoryAgentProgressPoint.$$$reportNull$$$0(0);
        }
        this.message = message;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.currentValue = currentValue;
    }

    @NotNull
    public static MemoryAgentProgressPoint fromJson(@NotNull String fileName) throws IOException {
        Gson gson;
        MemoryAgentProgressPoint progressPoint;
        if (fileName == null) {
            MemoryAgentProgressPoint.$$$reportNull$$$0(1);
        }
        if (!(progressPoint = (MemoryAgentProgressPoint)(gson = new Gson()).fromJson((Reader)new FileReader(fileName, StandardCharsets.UTF_8), MemoryAgentProgressPoint.class)).isValid()) {
            throw new InvalidDataException("Invalid format of progress point");
        }
        MemoryAgentProgressPoint memoryAgentProgressPoint = progressPoint;
        if (memoryAgentProgressPoint == null) {
            MemoryAgentProgressPoint.$$$reportNull$$$0(2);
        }
        return memoryAgentProgressPoint;
    }

    public boolean isFinished() {
        return this.maxValue == this.currentValue;
    }

    public String getMessage() {
        return this.message;
    }

    public double getFraction() {
        return (double)this.currentValue / (double)(this.maxValue - this.minValue);
    }

    private boolean isValid() {
        return this.maxValue > this.minValue && this.currentValue >= this.minValue && this.currentValue <= this.maxValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentProgressPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentProgressPoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromJson";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

