/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.parsers;

import com.intellij.debugger.memory.agent.UnexpectedValueFormatException;
import com.intellij.debugger.memory.agent.parsers.LongArrayParser;
import com.intellij.debugger.memory.agent.parsers.ResultParser;
import com.intellij.openapi.util.Pair;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002 \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/debugger/memory/agent/parsers/ShallowAndRetainedSizeParser;", "Lcom/intellij/debugger/memory/agent/parsers/ResultParser;", "Lcom/intellij/openapi/util/Pair;", "", "", "<init>", "()V", "parse", "value", "Lcom/sun/jdi/Value;", "intellij.java.debugger.impl"})
public final class ShallowAndRetainedSizeParser
implements ResultParser<Pair<List<? extends Long>, List<? extends Long>>> {
    @NotNull
    public static final ShallowAndRetainedSizeParser INSTANCE = new ShallowAndRetainedSizeParser();

    private ShallowAndRetainedSizeParser() {
    }

    @Override
    @NotNull
    public Pair<List<Long>, List<Long>> parse(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueFormatException("Array expected");
        }
        if (((ArrayReference)value).length() < 2) {
            throw new UnexpectedValueFormatException("Two arrays expected");
        }
        Value value2 = ((ArrayReference)value).getValue(0);
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"getValue(...)");
        Object object = LongArrayParser.INSTANCE.parse(value2);
        Value value3 = ((ArrayReference)value).getValue(1);
        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"getValue(...)");
        return new Pair(object, LongArrayParser.INSTANCE.parse(value3));
    }
}

