/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.ui;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightableTree
extends XDebuggerTree {
    private final Map<TreePath, Color> myPathToBackgroundColor;

    public HighlightableTree(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, @NotNull String popupActionGroupId, @Nullable XValueMarkers<?, ?> valueMarkers) {
        if (project == null) {
            HighlightableTree.$$$reportNull$$$0(0);
        }
        if (editorsProvider == null) {
            HighlightableTree.$$$reportNull$$$0(1);
        }
        if (popupActionGroupId == null) {
            HighlightableTree.$$$reportNull$$$0(2);
        }
        super(project, editorsProvider, sourcePosition, popupActionGroupId, valueMarkers);
        this.myPathToBackgroundColor = new HashMap<TreePath, Color>();
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path) {
        Color color;
        if (path == null) {
            HighlightableTree.$$$reportNull$$$0(3);
        }
        return (color = this.myPathToBackgroundColor.get(path)) != null ? color : super.getFileColorForPath(path);
    }

    public void dispose() {
        super.dispose();
        this.clearColoredPaths();
    }

    public void addColoredPath(TreePath path, Color color) {
        this.myPathToBackgroundColor.put(path, color);
    }

    public void removeColoredPath(TreePath path) {
        this.myPathToBackgroundColor.remove(path);
    }

    public void removeColoredPaths(TreePath[] paths) {
        for (TreePath path : paths) {
            this.myPathToBackgroundColor.remove(path);
        }
    }

    public void clearColoredPaths() {
        this.myPathToBackgroundColor.clear();
    }

    public boolean isFileColorsEnabled() {
        return !this.myPathToBackgroundColor.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActionGroupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/agent/ui/HighlightableTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileColorForPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

