/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.memory.filtering.ConditionCheckerImpl;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XExpression;
import org.jetbrains.annotations.NotNull;

public class FilteringTask
implements Runnable {
    private final ValuesList myValues;
    private final ConditionChecker myChecker;
    private final FilteringTaskCallback myCallback;
    private volatile boolean myIsCancelled;

    public FilteringTask(@NotNull String className, @NotNull DebugProcessImpl debugProcess, @NotNull XExpression expression, @NotNull ValuesList values, @NotNull FilteringTaskCallback callback) {
        if (className == null) {
            FilteringTask.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            FilteringTask.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            FilteringTask.$$$reportNull$$$0(2);
        }
        if (values == null) {
            FilteringTask.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            FilteringTask.$$$reportNull$$$0(4);
        }
        this.myChecker = FilteringTask.isEmptyFilter(expression) ? ConditionChecker.ALL_MATCHED_CHECKER : new ConditionCheckerImpl(debugProcess, expression, className);
        this.myValues = values;
        this.myCallback = callback;
    }

    public void cancel() {
        this.myIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.myIsCancelled;
    }

    @Override
    public void run() {
        int proceedCount;
        this.myCallback.started(this.myValues.size());
        for (proceedCount = 0; proceedCount < this.myValues.size() && !this.myIsCancelled; ++proceedCount) {
            FilteringTaskCallback.Action action;
            JavaReferenceInfo info = this.myValues.get(proceedCount);
            CheckingResult result = this.myChecker.check(info.getObjectReference());
            switch (result.getResult()) {
                default: {
                    throw new MatchException(null, null);
                }
                case MATCH: {
                    FilteringTaskCallback.Action action2 = this.myCallback.matched(info);
                    break;
                }
                case NO_MATCH: {
                    FilteringTaskCallback.Action action2 = this.myCallback.notMatched(info);
                    break;
                }
                case ERROR: {
                    FilteringTaskCallback.Action action2 = action = this.myCallback.error(info, result.getFailureDescription());
                }
            }
            if (action == FilteringTaskCallback.Action.STOP) break;
        }
        FilteringResult reason = this.myIsCancelled ? FilteringResult.INTERRUPTED : (proceedCount == this.myValues.size() ? FilteringResult.ALL_CHECKED : FilteringResult.LIMIT_REACHED);
        this.myCallback.completed(reason);
    }

    public static boolean isEmptyFilter(@NotNull XExpression expression) {
        if (expression == null) {
            FilteringTask.$$$reportNull$$$0(5);
        }
        return StringUtil.isEmptyOrSpaces((String)expression.getExpression());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/filtering/FilteringTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmptyFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ValuesList {
        public int size();

        public JavaReferenceInfo get(int var1);
    }
}

