/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiTypeCodeFragmentImpl;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

class CompoundRendererConfigurable
extends JPanel {
    private CompoundReferenceRenderer myRenderer;
    private CompoundReferenceRenderer myOriginalRenderer;
    private Project myProject;
    private final ClassNameEditorWithBrowseButton myClassNameField;
    private final JRadioButton myRbDefaultLabel;
    private final JRadioButton myRbExpressionLabel;
    private final JBCheckBox myShowTypeCheckBox;
    private final JBCheckBox myOnDemandCheckBox;
    private final JRadioButton myRbDefaultChildrenRenderer;
    private final JRadioButton myRbExpressionChildrenRenderer;
    private final JRadioButton myRbListChildrenRenderer;
    private final XDebuggerExpressionEditor myLabelEditor;
    private final XDebuggerExpressionEditor myChildrenEditor;
    private final XDebuggerExpressionEditor myChildrenExpandedEditor;
    private XDebuggerExpressionEditor myListChildrenEditor;
    private final JLabel myExpandedLabel;
    private JBTable myTable;
    private final JBCheckBox myAppendDefaultChildren;
    @NonNls
    private static final String EMPTY_PANEL_ID = "EMPTY";
    @NonNls
    private static final String DATA_PANEL_ID = "DATA";
    private static final int NAME_TABLE_COLUMN = 0;
    private static final int EXPRESSION_TABLE_COLUMN = 1;
    private static final int ONDEMAND_TABLE_COLUMN = 2;

    CompoundRendererConfigurable(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            CompoundRendererConfigurable.$$$reportNull$$$0(0);
        }
        super(new CardLayout());
        this.myProject = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        this.myRbDefaultLabel = new JRadioButton(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.use.default.renderer", (Object[])new Object[0]));
        this.myRbExpressionLabel = new JRadioButton(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression", (Object[])new Object[0]));
        ButtonGroup labelButtonsGroup = new ButtonGroup();
        labelButtonsGroup.add(this.myRbDefaultLabel);
        labelButtonsGroup.add(this.myRbExpressionLabel);
        this.myShowTypeCheckBox = new JBCheckBox(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.show.type", (Object[])new Object[0]));
        this.myOnDemandCheckBox = new JBCheckBox(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.ondemand", (Object[])new Object[0]));
        this.myRbDefaultChildrenRenderer = new JRadioButton(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.use.default.renderer", (Object[])new Object[0]));
        this.myRbExpressionChildrenRenderer = new JRadioButton(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression", (Object[])new Object[0]));
        this.myRbListChildrenRenderer = new JRadioButton(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression.list", (Object[])new Object[0]));
        ButtonGroup childrenButtonGroup = new ButtonGroup();
        childrenButtonGroup.add(this.myRbDefaultChildrenRenderer);
        childrenButtonGroup.add(this.myRbExpressionChildrenRenderer);
        childrenButtonGroup.add(this.myRbListChildrenRenderer);
        JavaDebuggerEditorsProvider editorsProvider = new JavaDebuggerEditorsProvider();
        this.myLabelEditor = new XDebuggerExpressionEditor(this.myProject, (XDebuggerEditorsProvider)editorsProvider, "ClassLabelExpression", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, true);
        this.myChildrenEditor = new XDebuggerExpressionEditor(this.myProject, (XDebuggerEditorsProvider)editorsProvider, "ClassChildrenExpression", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, true);
        this.myChildrenExpandedEditor = new XDebuggerExpressionEditor(this.myProject, (XDebuggerEditorsProvider)editorsProvider, "ClassChildrenExpression", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, true);
        JComponent myChildrenListEditor = this.createChildrenListEditor(editorsProvider);
        ItemListener updateListener = new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CompoundRendererConfigurable.this.updateEnabledState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CompoundRendererConfigurable$1", "itemStateChanged"));
            }
        };
        this.myRbExpressionLabel.addItemListener(updateListener);
        this.myRbListChildrenRenderer.addItemListener(updateListener);
        this.myRbExpressionChildrenRenderer.addItemListener(updateListener);
        this.myClassNameField = new ClassNameEditorWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                PsiClass psiClass;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((psiClass = DebuggerUtils.getInstance().chooseClassDialog(JavaDebuggerBundle.message((String)"title.compound.renderer.configurable.choose.renderer.reference.type", (Object[])new Object[0]), CompoundRendererConfigurable.this.myProject)) != null) {
                    String qName = JVMNameUtil.getClassVMName(psiClass);
                    CompoundRendererConfigurable.this.myClassNameField.setText(qName);
                    CompoundRendererConfigurable.this.updateContext(qName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CompoundRendererConfigurable$2", "actionPerformed"));
            }
        }, this.myProject);
        EditorTextField editorTextField = this.myClassNameField.getEditorTextField();
        editorTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                CompoundRendererConfigurable.this.updateContext(CompoundRendererConfigurable.this.myClassNameField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CompoundRendererConfigurable$3", "focusLost"));
            }
        });
        final ComponentValidator validator = new ComponentValidator((Disposable)JavaPluginDisposable.getInstance((Project)this.myProject)).withValidator(() -> {
            String text = this.myClassNameField.getText();
            if (StringUtil.containsAnyChar((String)text, (String)"<>")) {
                return new ValidationInfo(JavaDebuggerBundle.message((String)"error.compound.renderer.configurable.fqn.generic", (Object[])new Object[0]), (JComponent)editorTextField);
            }
            return null;
        }).installOn((JComponent)editorTextField);
        this.myClassNameField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                validator.revalidate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/settings/CompoundRendererConfigurable$4", "documentChanged"));
            }
        });
        this.myAppendDefaultChildren = new JBCheckBox(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.append.default.children", (Object[])new Object[0]));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.apply.to", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        panel.add((Component)((Object)this.myClassNameField), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        panel.add((Component)new JLabel(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.when.rendering", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsTop((int)20), 0, 0));
        panel.add((Component)this.myShowTypeCheckBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)7), 0, 0));
        panel.add((Component)this.myRbDefaultLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel.add((Component)this.myRbExpressionLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel.add((Component)this.myLabelEditor.getComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)30), 0, 0));
        panel.add((Component)this.myOnDemandCheckBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)30), 0, 0));
        panel.add((Component)new JLabel(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.when.expanding", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsTop((int)20), 0, 0));
        panel.add((Component)this.myRbDefaultChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel.add((Component)this.myRbExpressionChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel.add((Component)this.myChildrenEditor.getComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)30), 0, 0));
        this.myExpandedLabel = new JLabel(JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.test.can.expand", (Object[])new Object[0]));
        panel.add((Component)this.myExpandedLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)4, (int)30, (int)0, (int)0), 0, 0));
        panel.add((Component)this.myChildrenExpandedEditor.getComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)30), 0, 0));
        panel.add((Component)this.myRbListChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel.add((Component)myChildrenListEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)4, (int)30, (int)0, (int)0), 0, 0));
        panel.add((Component)this.myAppendDefaultChildren, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)25), 0, 0));
        this.add((Component)new JPanel(), EMPTY_PANEL_ID);
        this.add((Component)panel, DATA_PANEL_ID);
    }

    public void setRenderer(NodeRenderer renderer) {
        if (renderer instanceof CompoundReferenceRenderer) {
            this.myRenderer = (CompoundReferenceRenderer)renderer;
            this.myOriginalRenderer = (CompoundReferenceRenderer)renderer.clone();
        } else {
            this.myOriginalRenderer = null;
            this.myRenderer = null;
        }
        this.reset();
    }

    public CompoundReferenceRenderer getRenderer() {
        return this.myRenderer;
    }

    private void updateContext(String qName) {
        if (this.myProject != null) {
            ReadAction.nonBlocking(() -> (PsiElement)DebuggerUtilsImpl.getPsiClassAndType((String)qName, (Project)this.myProject).first).inSmartMode(this.myProject).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.any(), context -> {
                if (context != null) {
                    this.myLabelEditor.setContext(context);
                    this.myChildrenEditor.setContext(context);
                    this.myChildrenExpandedEditor.setContext(context);
                    this.myListChildrenEditor.setContext(context);
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private void updateEnabledState() {
        boolean isLabelRenderer = this.myRbExpressionLabel.isSelected();
        this.myLabelEditor.setEnabled(isLabelRenderer);
        this.myOnDemandCheckBox.setEnabled(isLabelRenderer);
        boolean isChildrenExpression = this.myRbExpressionChildrenRenderer.isSelected();
        this.myChildrenExpandedEditor.setEnabled(isChildrenExpression);
        this.myExpandedLabel.setEnabled(isChildrenExpression);
        this.myChildrenEditor.setEnabled(isChildrenExpression);
        boolean isListChildren = this.myRbListChildrenRenderer.isSelected();
        this.myTable.setEnabled(isListChildren);
        this.myAppendDefaultChildren.setEnabled(isListChildren);
    }

    private JComponent createChildrenListEditor(JavaDebuggerEditorsProvider editorsProvider) {
        final MyTableModel tableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myTable.setShowGrid(false);
        this.myListChildrenEditor = new XDebuggerExpressionEditor(this.myProject, (XDebuggerEditorsProvider)editorsProvider, "NamedChildrenConfigurable", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, false);
        final JComponent editorComponent = this.myListChildrenEditor.getComponent();
        AbstractTableCellEditor editor = new AbstractTableCellEditor(){

            public Object getCellEditorValue() {
                return TextWithImportsImpl.fromXExpression(CompoundRendererConfigurable.this.myListChildrenEditor.getExpression());
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                CompoundRendererConfigurable.this.myListChildrenEditor.setExpression(TextWithImportsImpl.toXExpression((TextWithImports)value));
                return editorComponent;
            }
        };
        editorComponent.registerKeyboardAction(e -> editor.stopCellEditing(), KeyStroke.getKeyStroke(10, 0), 1);
        editorComponent.registerKeyboardAction(e -> editor.cancelCellEditing(), KeyStroke.getKeyStroke(27, 0), 1);
        TableColumn exprColumn = this.myTable.getColumnModel().getColumn(1);
        exprColumn.setCellEditor((TableCellEditor)editor);
        exprColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            @NotNull
            public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TextWithImports textWithImports;
                if (table == null) {
                    6.$$$reportNull$$$0(0);
                }
                String text = (textWithImports = (TextWithImports)value) != null ? textWithImports.getText() : "";
                Component component = super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                if (component == null) {
                    6.$$$reportNull$$$0(1);
                }
                return component;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/settings/CompoundRendererConfigurable$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/settings/CompoundRendererConfigurable$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTableCellRendererComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTableCellRendererComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        return ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                tableModel.addRow("", DebuggerUtils.getInstance().createExpressionWithImports(""));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = CompoundRendererConfigurable.this.myTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < CompoundRendererConfigurable.this.myTable.getRowCount()) {
                    CompoundRendererConfigurable.this.getTableModel().removeRow(selectedRow);
                }
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsUp((JTable)CompoundRendererConfigurable.this.myTable);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsDown((JTable)CompoundRendererConfigurable.this.myTable);
            }
        }).createPanel();
    }

    public boolean isModified() {
        if (this.myRenderer == null) {
            return false;
        }
        CompoundReferenceRenderer cloned = this.myRenderer.clone();
        this.flushDataTo(cloned);
        return !DebuggerUtilsEx.externalizableEqual(cloned, this.myOriginalRenderer);
    }

    public void apply() {
        if (this.myRenderer == null) {
            return;
        }
        this.flushDataTo(this.myRenderer);
        this.myOriginalRenderer = this.myRenderer.clone();
    }

    private void flushDataTo(CompoundReferenceRenderer renderer) {
        LabelRenderer labelRenderer = null;
        renderer.setShowType(this.myShowTypeCheckBox.isSelected());
        if (this.myRbExpressionLabel.isSelected()) {
            labelRenderer = new LabelRenderer();
            labelRenderer.setLabelExpression(TextWithImportsImpl.fromXExpression(this.myLabelEditor.getExpression()));
            labelRenderer.setOnDemand(this.myOnDemandCheckBox.isSelected());
        }
        renderer.setLabelRenderer(labelRenderer);
        ReferenceRenderer childrenRenderer = null;
        if (this.myRbExpressionChildrenRenderer.isSelected()) {
            childrenRenderer = new ExpressionChildrenRenderer();
            childrenRenderer.setChildrenExpression(TextWithImportsImpl.fromXExpression(this.myChildrenEditor.getExpression()));
            childrenRenderer.setChildrenExpandable(TextWithImportsImpl.fromXExpression(this.myChildrenExpandedEditor.getExpression()));
        } else if (this.myRbListChildrenRenderer.isSelected()) {
            EnumerationChildrenRenderer enumerationChildrenRenderer = new EnumerationChildrenRenderer(this.getTableModel().getExpressions());
            enumerationChildrenRenderer.setAppendDefaultChildren(this.myAppendDefaultChildren.isSelected());
            childrenRenderer = enumerationChildrenRenderer;
        }
        renderer.setChildrenRenderer((ChildrenRenderer)((Object)childrenRenderer));
        renderer.setClassName(this.myClassNameField.getText());
    }

    public void reset() {
        TextWithImportsImpl emptyExpressionFragment = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
        ((CardLayout)this.getLayout()).show(this, this.myRenderer == null ? EMPTY_PANEL_ID : DATA_PANEL_ID);
        if (this.myRenderer == null) {
            return;
        }
        String className = this.myRenderer.getClassName();
        this.myClassNameField.setText(className);
        this.updateContext(className);
        ValueLabelRenderer labelRenderer = this.myRenderer.getLabelRenderer();
        ChildrenRenderer childrenRenderer = this.myRenderer.getChildrenRenderer();
        this.myShowTypeCheckBox.setSelected(this.myRenderer.isShowType());
        if (this.myRenderer.isBaseRenderer(labelRenderer)) {
            this.myLabelEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
            this.myRbDefaultLabel.setSelected(true);
            this.myOnDemandCheckBox.setSelected(false);
        } else {
            this.myRbExpressionLabel.setSelected(true);
            LabelRenderer lr = (LabelRenderer)labelRenderer;
            this.myLabelEditor.setExpression(TextWithImportsImpl.toXExpression(lr.getLabelExpression()));
            this.myOnDemandCheckBox.setSelected(lr.isOnDemand());
        }
        this.getTableModel().clear();
        this.myAppendDefaultChildren.setSelected(false);
        if (this.myRenderer.isBaseRenderer(childrenRenderer)) {
            this.myRbDefaultChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
            this.myChildrenExpandedEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
        } else if (childrenRenderer instanceof ExpressionChildrenRenderer) {
            ExpressionChildrenRenderer exprRenderer = (ExpressionChildrenRenderer)childrenRenderer;
            this.myRbExpressionChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setExpression(TextWithImportsImpl.toXExpression(exprRenderer.getChildrenExpression()));
            this.myChildrenExpandedEditor.setExpression(TextWithImportsImpl.toXExpression(exprRenderer.getChildrenExpandable()));
        } else {
            this.myRbListChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
            this.myChildrenExpandedEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
            if (childrenRenderer instanceof EnumerationChildrenRenderer) {
                EnumerationChildrenRenderer enumerationRenderer = (EnumerationChildrenRenderer)childrenRenderer;
                this.getTableModel().init(enumerationRenderer.getChildren());
                this.myAppendDefaultChildren.setSelected(enumerationRenderer.isAppendDefaultChildren());
            }
        }
        this.updateEnabledState();
    }

    private MyTableModel getTableModel() {
        return (MyTableModel)this.myTable.getModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/debugger/settings/CompoundRendererConfigurable", "<init>"));
    }

    private static final class ClassNameEditorWithBrowseButton
    extends ReferenceEditorWithBrowseButton {
        private ClassNameEditorWithBrowseButton(ActionListener browseActionListener, Project project) {
            super(browseActionListener, project, s -> {
                PsiTypeCodeFragmentImpl fragment = new PsiTypeCodeFragmentImpl(project, true, "fragment.java", (CharSequence)s, 0, null){

                    public boolean importClass(@NotNull PsiClass aClass) {
                        if (aClass == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/debugger/settings/CompoundRendererConfigurable$ClassNameEditorWithBrowseButton$1", "importClass"));
                    }
                };
                fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
                return fragment.getViewProvider().getDocument();
            }, "");
        }
    }

    private static final class MyTableModel
    extends AbstractTableModel {
        private final List<EnumerationChildrenRenderer.ChildInfo> myData = new ArrayList<EnumerationChildrenRenderer.ChildInfo>();

        MyTableModel() {
        }

        public void init(List<? extends EnumerationChildrenRenderer.ChildInfo> data) {
            this.myData.clear();
            for (EnumerationChildrenRenderer.ChildInfo childInfo : data) {
                this.myData.add(new EnumerationChildrenRenderer.ChildInfo(childInfo.myName, childInfo.myExpression, childInfo.myOnDemand));
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.myData.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int columnIndex) {
            Class clazz = switch (columnIndex) {
                case 0 -> String.class;
                case 1 -> TextWithImports.class;
                case 2 -> Boolean.class;
                default -> super.getColumnClass(columnIndex);
            };
            if (clazz == null) {
                MyTableModel.$$$reportNull$$$0(0);
            }
            return clazz;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return null;
            }
            EnumerationChildrenRenderer.ChildInfo row = this.myData.get(rowIndex);
            return switch (columnIndex) {
                case 0 -> row.myName;
                case 1 -> row.myExpression;
                case 2 -> row.myOnDemand;
                default -> null;
            };
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return;
            }
            EnumerationChildrenRenderer.ChildInfo row = this.myData.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    row.myName = (String)aValue;
                    break;
                }
                case 1: {
                    row.myExpression = (TextWithImports)aValue;
                    break;
                }
                case 2: {
                    row.myOnDemand = (Boolean)aValue;
                }
            }
        }

        @Override
        @NotNull
        public String getColumnName(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.name", (Object[])new Object[0]);
                case 1 -> JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.expression", (Object[])new Object[0]);
                case 2 -> JavaDebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.ondemand", (Object[])new Object[0]);
                default -> "";
            };
        }

        public void addRow(String name, TextWithImports expressionWithImports) {
            this.myData.add(new EnumerationChildrenRenderer.ChildInfo(name, expressionWithImports, false));
            int lastRow = this.myData.size() - 1;
            this.fireTableRowsInserted(lastRow, lastRow);
        }

        public void removeRow(int row) {
            if (row >= 0 && row < this.myData.size()) {
                this.myData.remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }

        public void clear() {
            this.myData.clear();
            this.fireTableDataChanged();
        }

        public List<EnumerationChildrenRenderer.ChildInfo> getExpressions() {
            return this.myData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CompoundRendererConfigurable$MyTableModel", "getColumnClass"));
        }
    }
}

