/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.reference.SoftReference;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.hotswap.HotSwapStatusNotificationManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class HotSwapProgressImpl
extends HotSwapProgress {
    static final NotificationGroup NOTIFICATION_GROUP = Registry.is((String)"debugger.hotswap.floating.toolbar") ? NotificationGroupManager.getInstance().getNotificationGroup("HotSwap Messages") : NotificationGroup.toolWindowGroup((String)"HotSwap", (String)"Debug");
    private final Int2ObjectMap<Map<DebuggerSession, List<String>>> myMessages = new Int2ObjectOpenHashMap();
    private final ProgressWindow myProgressWindow;
    private @NlsContexts.ProgressTitle String myTitle = JavaDebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]);
    private final MergingUpdateQueue myUpdateQueue;
    private WeakReference<XDebugSession> mySessionRef = null;
    private final List<HotSwapProgressListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public HotSwapProgressImpl(Project project) {
        super(project);
        assert (EDT.isCurrentThreadEdt());
        this.myProgressWindow = new BackgroundableProcessIndicator(this.getProject(), this.myTitle, null, null, true);
        this.myProgressWindow.setIndeterminate(false);
        this.myProgressWindow.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

            public void cancel() {
                super.cancel();
                HotSwapProgressImpl.this.cancel();
            }
        });
        this.myUpdateQueue = new MergingUpdateQueue("HotSwapProgress update queue", 100, true, null, (Disposable)this.myProgressWindow);
    }

    @Override
    public void cancel() {
        super.cancel();
        for (HotSwapProgressListener listener2 : this.myListeners) {
            listener2.onCancel();
        }
    }

    @Override
    public void finished() {
        super.finished();
        for (HotSwapProgressListener listener2 : this.myListeners) {
            listener2.onFinish();
        }
        Set debuggerSessions = this.myMessages.values().stream().flatMap(e -> e.keySet().stream()).collect(Collectors.toUnmodifiableSet());
        boolean addSessionName = debuggerSessions.size() > 1;
        List<String> errors = this.getMessages(4, addSessionName);
        List<String> warnings = this.getMessages(5, addSessionName);
        if (!errors.isEmpty()) {
            this.notifyUser(JavaDebuggerBundle.message((String)"status.hot.swap.completed.with.errors", (Object[])new Object[0]), HotSwapProgressImpl.buildMessage(errors), true, NotificationType.ERROR);
        } else if (!warnings.isEmpty()) {
            this.notifyUser(JavaDebuggerBundle.message((String)"status.hot.swap.completed.with.warnings", (Object[])new Object[0]), HotSwapProgressImpl.buildMessage(warnings), true, NotificationType.WARNING);
        } else if (!this.myMessages.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            IntIterator intIterator = this.myMessages.keySet().iterator();
            while (intIterator.hasNext()) {
                int key = (Integer)intIterator.next();
                messages.addAll(this.getMessages(key, addSessionName));
            }
            this.notifyUser("", HotSwapProgressImpl.buildMessage(messages), false, NotificationType.INFORMATION);
        }
    }

    private void notifyUser(@NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message, boolean withRestart, NotificationType type) {
        Notification notification = NOTIFICATION_GROUP.createNotification(title, message, type);
        HotSwapStatusNotificationManager.getInstance((Project)this.getProject()).trackNotification(notification);
        if (SoftReference.dereference(this.mySessionRef) != null) {
            if (withRestart) {
                notification.addAction((AnAction)new RestartHotSwapNotificationAction(this.mySessionRef));
            }
            notification.addAction((AnAction)new StopHotSwapNotificationAction(this.mySessionRef));
        }
        notification.setImportant(false).notify(this.getProject());
    }

    public void setSessionForActions(@NotNull DebuggerSession session) {
        if (session == null) {
            HotSwapProgressImpl.$$$reportNull$$$0(0);
        }
        this.mySessionRef = new WeakReference<XDebugSession>(session.getXDebugSession());
    }

    @NotNull
    private @Unmodifiable List<String> getMessages(int category, boolean addSessionName) {
        Map sessionMessages = ContainerUtil.notNullize((Map)((Map)this.myMessages.get(category)));
        List<String> list = sessionMessages.entrySet().stream().flatMap(entry -> {
            Stream stream = ((List)entry.getValue()).stream();
            return addSessionName ? stream.map(message -> ((DebuggerSession)entry.getKey()).getSessionName() + ": " + message) : stream;
        }).toList();
        if (list == null) {
            HotSwapProgressImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    boolean hasErrors() {
        return !this.getMessages(4, false).isEmpty();
    }

    @NlsSafe
    private static String buildMessage(List<String> messages) {
        return StreamEx.of(messages).joining((CharSequence)"\n");
    }

    @Override
    public void addMessage(DebuggerSession session, int type, String text) {
        List sessionMessages;
        HashMap<DebuggerSession, List> messages = (HashMap<DebuggerSession, List>)this.myMessages.get(type);
        if (messages == null) {
            messages = new HashMap<DebuggerSession, List>();
            this.myMessages.put(type, messages);
        }
        if ((sessionMessages = (List)messages.get(session)) == null) {
            sessionMessages = new SmartList();
            messages.put(session, sessionMessages);
        }
        sessionMessages.add(text);
    }

    @Override
    public void setText(final @NlsContexts.ProgressText String text) {
        this.myUpdateQueue.queue(new Update("Text"){

            public void run() {
                DebuggerInvocationUtil.invokeLater(HotSwapProgressImpl.this.getProject(), () -> {
                    if (!HotSwapProgressImpl.this.myProgressWindow.isCanceled() && HotSwapProgressImpl.this.myProgressWindow.isRunning()) {
                        HotSwapProgressImpl.this.myProgressWindow.setText(text);
                    }
                }, HotSwapProgressImpl.this.myProgressWindow.getModalityState());
            }
        });
    }

    @Override
    public void setTitle(@NlsContexts.ProgressTitle @NotNull String text) {
        if (text == null) {
            HotSwapProgressImpl.$$$reportNull$$$0(2);
        }
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.myProgressWindow.isCanceled() && this.myProgressWindow.isRunning()) {
                this.myProgressWindow.setTitle(text);
            }
        }, this.myProgressWindow.getModalityState());
    }

    @Override
    public void setFraction(double v) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.myProgressWindow.isCanceled() && this.myProgressWindow.isRunning()) {
                this.myProgressWindow.setFraction(v);
            }
        }, this.myProgressWindow.getModalityState());
    }

    @Override
    public boolean isCancelled() {
        return this.myProgressWindow.isCanceled();
    }

    public ProgressIndicator getProgressIndicator() {
        return this.myProgressWindow;
    }

    @Override
    public void setDebuggerSession(DebuggerSession session) {
        this.myTitle = JavaDebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]) + " : " + session.getSessionName();
        this.myProgressWindow.setTitle(this.myTitle);
    }

    void addProgressListener(@NotNull HotSwapProgressListener listener2) {
        if (listener2 == null) {
            HotSwapProgressImpl.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/HotSwapProgressImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/HotSwapProgressImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSessionForActions";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProgressListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static interface HotSwapProgressListener {
        default public void onCancel() {
        }

        default public void onFinish() {
        }
    }

    private static class RestartHotSwapNotificationAction
    extends NotificationAction {
        private final WeakReference<XDebugSession> mySessionRef;

        private RestartHotSwapNotificationAction(@NotNull WeakReference<XDebugSession> session) {
            if (session == null) {
                RestartHotSwapNotificationAction.$$$reportNull$$$0(0);
            }
            super(JavaDebuggerBundle.message((String)"status.hot.swap.completed.restart", (Object[])new Object[0]));
            this.mySessionRef = session;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            XDebugSession session;
            if (e == null) {
                RestartHotSwapNotificationAction.$$$reportNull$$$0(1);
            }
            if (notification == null) {
                RestartHotSwapNotificationAction.$$$reportNull$$$0(2);
            }
            if ((session = (XDebugSession)SoftReference.dereference(this.mySessionRef)) != null) {
                notification.expire();
                ExecutionEnvironment environment = session.getExecutionEnvironment();
                if (environment != null) {
                    ExecutionUtil.restart((ExecutionEnvironment)environment);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ui/HotSwapProgressImpl$RestartHotSwapNotificationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StopHotSwapNotificationAction
    extends NotificationAction {
        private final WeakReference<XDebugSession> mySessionRef;

        private StopHotSwapNotificationAction(@NotNull WeakReference<XDebugSession> session) {
            if (session == null) {
                StopHotSwapNotificationAction.$$$reportNull$$$0(0);
            }
            super(JavaDebuggerBundle.message((String)"status.hot.swap.completed.stop", (Object[])new Object[0]));
            this.mySessionRef = session;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            XDebugSession session;
            if (e == null) {
                StopHotSwapNotificationAction.$$$reportNull$$$0(1);
            }
            if (notification == null) {
                StopHotSwapNotificationAction.$$$reportNull$$$0(2);
            }
            if ((session = (XDebugSession)SoftReference.dereference(this.mySessionRef)) != null) {
                notification.expire();
                session.stop();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ui/HotSwapProgressImpl$StopHotSwapNotificationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

