/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.PatternFilterEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.classFilter.ClassFilter;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class InstanceFilterEditor
extends PatternFilterEditor {
    public InstanceFilterEditor(Project project) {
        super(project);
    }

    @Override
    protected void addClassFilter() {
        String idString = Messages.showInputDialog((Project)this.myProject, (String)JavaDebuggerBundle.message((String)"add.instance.filter.dialog.prompt", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"add.instance.filter.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), null, (InputValidator)new InputValidatorEx(this){

            @Nullable
            public String getErrorText(String inputString) {
                try {
                    Long.parseLong(inputString);
                    return null;
                }
                catch (NumberFormatException e) {
                    return JavaDebuggerBundle.message((String)"add.instance.filter.dialog.error.numeric.value.expected", (Object[])new Object[0]);
                }
            }

            public boolean canClose(String inputString) {
                return this.getErrorText(inputString) == null;
            }
        });
        if (idString != null) {
            ClassFilter filter = this.createFilter(idString);
            this.myTableModel.addRow(filter);
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
        }
    }
}

