/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.GotoFrameSourceAction;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.ThreadsDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.SingleEdtTaskScheduler;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ThreadsPanel
extends DebuggerTreePanel {
    @NonNls
    private static final String POPUP_ACTION_NAME = "Debugger.ThreadsPanelPopup";
    @NonNls
    private static final String HELP_ID = "debugging.debugThreads";
    private final SingleEdtTaskScheduler updateLabelsAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
    private static final int LABELS_UPDATE_DELAY_MS = 200;

    public ThreadsPanel(Project project, final DebuggerStateManager stateManager) {
        super(project, stateManager);
        Disposable disposable = DebuggerAction.installEditAction((JTree)((Object)this.getThreadsTree()), "Debugger.EditFrameSource");
        this.registerDisposable(disposable);
        this.getThreadsTree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ThreadsPanel.this.getThreadsTree().getSelectionCount() == 1) {
                    GotoFrameSourceAction.doAction(DataManager.getInstance().getDataContext((Component)((Object)ThreadsPanel.this.getThreadsTree())));
                }
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.getThreadsTree()), (boolean)true), "Center");
        stateManager.addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DebuggerSession.Event.ATTACHED == event || DebuggerSession.Event.RESUME == event) {
                    ThreadsPanel.this.startLabelsUpdate();
                } else if (DebuggerSession.Event.PAUSE == event || DebuggerSession.Event.DETACHED == event || DebuggerSession.Event.DISPOSE == event) {
                    ThreadsPanel.this.updateLabelsAlarm.cancel();
                }
                if (DebuggerSession.Event.DETACHED == event || DebuggerSession.Event.DISPOSE == event) {
                    stateManager.removeListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/impl/ThreadsPanel$2", "changeEvent"));
            }
        });
        this.startLabelsUpdate();
    }

    private void startLabelsUpdate() {
        if (this.updateLabelsAlarm.isDisposed()) {
            return;
        }
        this.updateLabelsAlarm.cancelAndRequest(200L, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean updateScheduled = false;
                try {
                    DebuggerManagerThreadImpl managerThread;
                    ThreadsDebuggerTree tree;
                    DebuggerTreeNodeImpl root;
                    if (ThreadsPanel.this.isUpdateEnabled() && (root = (DebuggerTreeNodeImpl)(tree = ThreadsPanel.this.getThreadsTree()).getModel().getRoot()) != null && (managerThread = ThreadsPanel.this.getContext().getManagerThread()) != null) {
                        managerThread.schedule(new DebuggerCommandImpl(){

                            @Override
                            protected void action() {
                                try {
                                    ThreadsPanel.updateNodeLabels(root);
                                }
                                finally {
                                    this.reschedule();
                                }
                            }

                            @Override
                            protected void commandCancelled() {
                                this.reschedule();
                            }
                        });
                        updateScheduled = true;
                    }
                }
                finally {
                    if (!updateScheduled) {
                        this.reschedule();
                    }
                }
            }

            private void reschedule() {
                DebuggerSession session = ThreadsPanel.this.getContext().getDebuggerSession();
                if (session != null && session.isAttached() && !session.isPaused() && !ThreadsPanel.this.updateLabelsAlarm.isDisposed()) {
                    ApplicationManager.getApplication().invokeLater(() -> ThreadsPanel.this.updateLabelsAlarm.request(200L, (Runnable)this), ModalityState.any());
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.updateLabelsAlarm.dispose();
        super.dispose();
    }

    public JComponent getDefaultFocusedComponent() {
        return this.getThreadsTree();
    }

    private static void updateNodeLabels(DebuggerTreeNodeImpl from) {
        Enumeration children = from.children();
        try {
            while (children.hasMoreElements()) {
                DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)children.nextElement();
                child.getDescriptor().updateRepresentation(null, child::labelChanged);
                ThreadsPanel.updateNodeLabels(child);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new ThreadsDebuggerTree(this.getProject());
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction(POPUP_ACTION_NAME);
        return ActionManager.getInstance().createActionPopupMenu(POPUP_ACTION_NAME, (ActionGroup)group);
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ThreadsPanel.$$$reportNull$$$0(0);
        }
        super.uiDataSnapshot(sink);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)HELP_ID);
    }

    public ThreadsDebuggerTree getThreadsTree() {
        return (ThreadsDebuggerTree)this.getTree();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/debugger/ui/impl/ThreadsPanel", "uiDataSnapshot"));
    }
}

