/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.overhead;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverheadTimings {
    public static final Key<OverheadTimings> KEY = Key.create((String)"OVERHEAD_TIMINGS");
    private final EventDispatcher<OverheadTimingsListener> myEventDispatcher = EventDispatcher.create(OverheadTimingsListener.class);
    private final Map<OverheadProducer, Timings> myMap = new ConcurrentHashMap<OverheadProducer, Timings>();
    private final List<Pair<Long, Timings>> myLast10Elements = new LinkedList<Pair<Long, Timings>>(){
        private long totalTime = 0L;

        @Override
        public synchronized boolean add(Pair<Long, Timings> o) {
            if (this.size() > 10) {
                Pair first;
                if (this.isExcessive()) {
                    ((OverheadTimingsListener)OverheadTimings.this.myEventDispatcher.getMulticaster()).excessiveOverheadDetected();
                }
                if ((first = (Pair)this.removeFirst()) != null) {
                    this.totalTime -= ((Long)ObjectUtils.notNull((Object)((Timings)first.getSecond()).myTime, (Object)0L)).longValue();
                }
            }
            this.totalTime += ((Long)ObjectUtils.notNull((Object)((Timings)o.getSecond()).myTime, (Object)0L)).longValue();
            return super.add(o);
        }

        private boolean isExcessive() {
            long timeframe = (Long)((Pair)this.getLast()).first - (Long)((Pair)this.getFirst()).first;
            return this.totalTime > timeframe || timeframe < 5L;
        }
    };

    public static Long getTime(DebugProcess process, OverheadProducer producer) {
        Timings timings = OverheadTimings.getTimings((DebugProcess)process).myMap.get(producer);
        return timings != null ? timings.myTime : null;
    }

    public static long getHits(DebugProcess process, OverheadProducer producer) {
        Timings timings = OverheadTimings.getTimings((DebugProcess)process).myMap.get(producer);
        return timings != null ? timings.myHits : 0L;
    }

    public static Set<OverheadProducer> getProducers(DebugProcess process) {
        return OverheadTimings.getTimings((DebugProcess)process).myMap.keySet();
    }

    public static void add(DebugProcess process, OverheadProducer producer, long hits, @Nullable Long overhead) {
        OverheadTimings timings = OverheadTimings.getTimings(process);
        Timings newTiming = new Timings(hits, overhead);
        timings.myLast10Elements.add((Pair<Long, Timings>)Pair.create((Object)System.currentTimeMillis(), (Object)newTiming));
        timings.myMap.merge(producer, newTiming, (old, value) -> {
            Long newTime = old.myTime;
            if (value.myTime != null) {
                newTime = newTime + value.myTime;
            }
            return new Timings(old.myHits + value.myHits, newTime);
        });
        ((OverheadTimingsListener)timings.myEventDispatcher.getMulticaster()).timingAdded(producer);
    }

    @NotNull
    private static OverheadTimings getTimings(DebugProcess process) {
        OverheadTimings data = (OverheadTimings)process.getUserData(KEY);
        if (data == null) {
            data = new OverheadTimings();
            process.putUserData(KEY, (Object)data);
        }
        OverheadTimings overheadTimings = data;
        if (overheadTimings == null) {
            OverheadTimings.$$$reportNull$$$0(0);
        }
        return overheadTimings;
    }

    static void addListener(OverheadTimingsListener listener2, DebugProcess process) {
        OverheadTimings.getTimings((DebugProcess)process).myEventDispatcher.addListener((EventListener)listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/overhead/OverheadTimings", "getTimings"));
    }

    public static interface OverheadTimingsListener
    extends EventListener {
        public void timingAdded(OverheadProducer var1);

        public void excessiveOverheadDetected();
    }

    private static class Timings {
        final long myHits;
        final Long myTime;

        Timings(long hits, Long time) {
            this.myHits = hits;
            this.myTime = time;
        }
    }
}

