/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.ShowImagePopupUtil;
import com.intellij.rt.debugger.ImageSerializer;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractImageRenderer
extends CompoundRendererProvider {
    private static final Logger LOG = Logger.getInstance(AbstractImageRenderer.class);

    AbstractImageRenderer() {
    }

    @Override
    public boolean isApplicable(Project project) {
        if (!super.isApplicable(project)) {
            return false;
        }
        XDebuggerManagerImpl manager = (XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)project);
        return manager.getFrontendCapabilities().getCanShowImages();
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    static byte @Nullable [] getImageBytes(EvaluationContextImpl evaluationContext, Value obj, String methodName) {
        try {
            EvaluationContextImpl copyContext = evaluationContext.createEvaluationContext(obj);
            StringReference bytes = (StringReference)DebuggerUtilsImpl.invokeHelperMethod(copyContext, ImageSerializer.class, methodName, Collections.singletonList(obj));
            if (bytes != null) {
                return bytes.value().getBytes(StandardCharsets.ISO_8859_1);
            }
        }
        catch (Exception e) {
            DebuggerUtilsImpl.logError("Exception while getting image data", e);
        }
        return null;
    }

    protected XFullValueEvaluator createImagePopupEvaluator(@NotNull @Nls String message, @NotNull EvaluationContextImpl evaluationContext, final Value imageObj, final String getBytesMethodName) {
        if (message == null) {
            AbstractImageRenderer.$$$reportNull$$$0(0);
        }
        if (evaluationContext == null) {
            AbstractImageRenderer.$$$reportNull$$$0(1);
        }
        return new JavaValue.JavaFullValueEvaluator(this, message, evaluationContext){
            {
                super(linkText, evaluationContext);
                this.setShowValuePopup(false);
            }

            @Override
            public void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callback.isObsolete()) {
                    return;
                }
                byte[] imageData = AbstractImageRenderer.getImageBytes(this.getEvaluationContext(), imageObj, getBytesMethodName);
                ShowImagePopupUtil.showOnFrontend((Project)this.getEvaluationContext().getProject(), (byte[])imageData);
                callback.evaluated("");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/tree/render/AbstractImageRenderer$1", "evaluate"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "evaluationContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/ui/tree/render/AbstractImageRenderer";
        objectArray[2] = "createImagePopupEvaluator";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

