/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ValueIconRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.Type;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class CompoundRendererProvider {
    public static final ExtensionPointName<CompoundRendererProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.debugger.compoundRendererProvider");

    protected abstract String getName();

    protected String getClassName() {
        return null;
    }

    protected ValueLabelRenderer getValueLabelRenderer() {
        return null;
    }

    protected ValueIconRenderer getIconRenderer() {
        return null;
    }

    protected ChildrenRenderer getChildrenRenderer() {
        return null;
    }

    protected FullValueEvaluatorProvider getFullValueEvaluatorProvider() {
        return null;
    }

    protected Function<Type, CompletableFuture<Boolean>> getIsApplicableChecker() {
        return null;
    }

    public boolean isApplicable(Project project) {
        return true;
    }

    protected boolean isEnabled() {
        return false;
    }

    @NotNull
    public final NodeRenderer createRenderer() {
        Function<Type, CompletableFuture<Boolean>> isApplicableChecker;
        CompoundReferenceRenderer res = new CompoundReferenceRenderer(this.getName(), this.getValueLabelRenderer(), this.getChildrenRenderer());
        res.setIconRenderer(this.getIconRenderer());
        res.setFullValueEvaluator(this.getFullValueEvaluatorProvider());
        String className = this.getClassName();
        if (!StringUtil.isEmpty((String)className)) {
            res.setClassName(className);
            res.setIsApplicableChecker(type -> DebuggerUtilsAsync.instanceOf(type, res.getClassName()));
        }
        if ((isApplicableChecker = this.getIsApplicableChecker()) != null) {
            res.setIsApplicableChecker(isApplicableChecker);
        }
        res.setEnabled(this.isEnabled());
        CompoundReferenceRenderer compoundReferenceRenderer = res;
        if (compoundReferenceRenderer == null) {
            CompoundRendererProvider.$$$reportNull$$$0(0);
        }
        return compoundReferenceRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/CompoundRendererProvider", "createRenderer"));
    }
}

