/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.actions.MuteRendererUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeEx;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OnDemandRenderer
extends FullValueEvaluatorProvider {
    public static final Key<Boolean> ON_DEMAND_CALCULATED = Key.create((String)"ON_DEMAND_CALCULATED");

    @Override
    @Nullable
    default public XFullValueEvaluator getFullValueEvaluator(@NotNull EvaluationContextImpl evaluationContext, @NotNull ValueDescriptorImpl valueDescriptor) {
        if (evaluationContext == null) {
            OnDemandRenderer.$$$reportNull$$$0(0);
        }
        if (valueDescriptor == null) {
            OnDemandRenderer.$$$reportNull$$$0(1);
        }
        if (this.isOnDemand(evaluationContext, valueDescriptor) && !OnDemandRenderer.isCalculated(valueDescriptor)) {
            return OnDemandRenderer.createFullValueEvaluator(this.getLinkText());
        }
        return null;
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    default public XFullValueEvaluator getFullValueEvaluator(@NotNull XValueNode valueNode, @NotNull EvaluationContextImpl evaluationContext, @NotNull ValueDescriptorImpl valueDescriptor) {
        if (valueNode == null) {
            OnDemandRenderer.$$$reportNull$$$0(2);
        }
        if (evaluationContext == null) {
            OnDemandRenderer.$$$reportNull$$$0(3);
        }
        if (valueDescriptor == null) {
            OnDemandRenderer.$$$reportNull$$$0(4);
        }
        if (this.isOnDemand(evaluationContext, valueDescriptor) && !OnDemandRenderer.isCalculated(valueDescriptor)) {
            return OnDemandRenderer.createFullValueEvaluator(valueNode, valueDescriptor, this.getLinkText());
        }
        return null;
    }

    @Nls
    public String getLinkText();

    default public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        return OnDemandRenderer.isOnDemandForced((DebugProcessImpl)evaluationContext.getDebugProcess());
    }

    default public boolean isShowValue(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext) {
        return !this.isOnDemand(evaluationContext, valueDescriptor) || OnDemandRenderer.isCalculated(valueDescriptor);
    }

    public static XFullValueEvaluator createFullValueEvaluator(@Nls String text) {
        return new XFullValueEvaluator(text){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callback instanceof HeadlessValueEvaluationCallback) {
                    XValueNodeImpl node = ((HeadlessValueEvaluationCallback)callback).getNode();
                    node.clearFullValueEvaluator();
                    OnDemandRenderer.setCalculated(((JavaValue)node.getValueContainer()).getDescriptor());
                    ((XValue)node.getValueContainer()).computePresentation((XValueNode)node, XValuePlace.TREE);
                }
                callback.evaluated("");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/tree/render/OnDemandRenderer$1", "startEvaluation"));
            }
        }.setShowValuePopup(false);
    }

    @ApiStatus.Experimental
    public static XFullValueEvaluator createFullValueEvaluator(final @NotNull XValueNode valueNode, final @NotNull ValueDescriptor valueDescriptor, @Nls String text) {
        if (valueNode == null) {
            OnDemandRenderer.$$$reportNull$$$0(5);
        }
        if (valueDescriptor == null) {
            OnDemandRenderer.$$$reportNull$$$0(6);
        }
        return new XFullValueEvaluator(text){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (valueNode instanceof XValueNodeEx) {
                    XValueNodeEx xValueNodeEx = (XValueNodeEx)valueNode;
                    xValueNodeEx.clearFullValueEvaluator();
                    OnDemandRenderer.setCalculated(valueDescriptor);
                    xValueNodeEx.getXValue().computePresentation(valueNode, XValuePlace.TREE);
                }
                callback.evaluated("");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/tree/render/OnDemandRenderer$2", "startEvaluation"));
            }
        }.setShowValuePopup(false);
    }

    public static boolean isCalculated(ValueDescriptor descriptor) {
        return (Boolean)ON_DEMAND_CALCULATED.get((UserDataHolder)descriptor, (Object)false);
    }

    public static void setCalculated(ValueDescriptor descriptor) {
        ON_DEMAND_CALCULATED.set((UserDataHolder)descriptor, (Object)true);
    }

    public static boolean isOnDemandForced(DebugProcessImpl debugProcess) {
        JavaDebugProcess process = debugProcess.getXdebugProcess();
        return process != null && MuteRendererUtils.isMuted(((XDebugSessionImpl)process.getSession()).getSessionData());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/tree/render/OnDemandRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFullValueEvaluator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createFullValueEvaluator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

