/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.history.ImportTestOutputExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AntTestContentHandler
extends DefaultHandler {
    private static final String TESTSUITES = "testsuites";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String NAME = "name";
    private static final String PACKAGE = "package";
    private static final String CLASSNAME = "classname";
    private static final String DURATION = "time";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String SKIPPED = "skipped";
    private static final String IGNORED = "ignored";
    private static final String OUT = "system-out";
    private static final String ERR = "system-err";
    private final GeneralTestEventsProcessor myProcessor;
    private final Stack<String> mySuites = new Stack();
    private String myCurrentTest;
    private String myDuration;
    private String myStatus;
    private final StringBuilder currentValue = new StringBuilder();
    private boolean myErrorOutput = false;

    public AntTestContentHandler(GeneralTestEventsProcessor processor) {
        this.myProcessor = processor;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (TESTSUITE.equals(qName)) {
            String nameValue = attributes.getValue(NAME);
            String suiteName = nameValue == null ? "" : StringUtil.unescapeXmlEntities((String)nameValue);
            String packageValue = attributes.getValue(PACKAGE);
            String packageName = packageValue == null ? null : StringUtil.unescapeXmlEntities((String)packageValue);
            this.myProcessor.onSuiteStarted(new TestSuiteStartedEvent(suiteName, "java:suite://" + StringUtil.getQualifiedName((String)packageName, (String)StringUtil.notNullize((String)suiteName))));
            this.mySuites.push((Object)suiteName);
        } else if (TESTCASE.equals(qName)) {
            String name;
            String nameValue = attributes.getValue(NAME);
            this.myCurrentTest = name = nameValue == null ? "" : StringUtil.unescapeXmlEntities((String)nameValue);
            this.myStatus = null;
            this.myDuration = attributes.getValue(DURATION);
            String classNameValue = attributes.getValue(CLASSNAME);
            String classname = classNameValue == null ? null : StringUtil.unescapeXmlEntities((String)classNameValue);
            String location = StringUtil.isEmpty((String)classname) ? name : classname + "/" + name;
            TestStartedEvent startedEvent = new TestStartedEvent(name, "java:test://" + location);
            this.myProcessor.onTestStarted(startedEvent);
        } else if (ERR.equals(qName)) {
            this.myErrorOutput = true;
        } else if (SKIPPED.equals(qName)) {
            this.myStatus = SKIPPED;
        } else if (IGNORED.equals(qName)) {
            this.myStatus = IGNORED;
        } else if (FAILURE.equals(qName)) {
            this.myStatus = "failed";
        } else if (ERROR.equals(qName)) {
            this.myStatus = ERROR;
        }
        this.currentValue.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String currentText = StringUtil.unescapeXmlEntities((String)this.currentValue.toString());
        this.currentValue.setLength(0);
        if (TESTSUITE.equals(qName)) {
            this.myProcessor.onSuiteFinished(new TestSuiteFinishedEvent((String)this.mySuites.pop()));
        } else if (TESTCASE.equals(qName)) {
            long time;
            if (this.myStatus != null) {
                if (this.myStatus.equals(ERROR) || this.myStatus.equals("failed")) {
                    this.myProcessor.onTestFailure(new TestFailedEvent(this.myCurrentTest, "", currentText, this.myStatus.equals(ERROR), null, null));
                } else if (this.myStatus.equals(IGNORED) || this.myStatus.equals(SKIPPED)) {
                    this.myProcessor.onTestIgnored(new TestIgnoredEvent(this.myCurrentTest, "", currentText));
                } else {
                    throw new IllegalStateException("Unknown status: " + this.myStatus);
                }
            }
            try {
                time = (long)(1000.0f * Float.parseFloat(this.myDuration));
            }
            catch (NumberFormatException e) {
                time = -1L;
            }
            this.myProcessor.onTestFinished(new TestFinishedEvent(this.myCurrentTest, Long.valueOf(time)));
            this.myCurrentTest = null;
        } else if ((ERR.equals(qName) || OUT.equals(qName)) && !StringUtil.isEmpty((String)currentText)) {
            if (this.myCurrentTest != null) {
                this.myProcessor.onTestOutput(new TestOutputEvent(this.myCurrentTest, currentText, !this.myErrorOutput));
            } else {
                this.myProcessor.onUncapturedOutput(currentText, this.myErrorOutput ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT);
            }
        }
    }

    public static final class AntTestOutputExtension
    implements ImportTestOutputExtension {
        @Nullable
        public DefaultHandler createHandler(@NotNull Reader reader, GeneralTestEventsProcessor processor) {
            if (reader == null) {
                AntTestOutputExtension.$$$reportNull$$$0(0);
            }
            final String[] rooName = new String[]{null};
            NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)new NanoXmlBuilder(){

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    throw NanoXmlUtil.ParserStoppedXmlException.INSTANCE;
                }

                public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
                    rooName[0] = name;
                }
            });
            return AntTestContentHandler.TESTSUITES.equals(rooName[0]) ? new AntTestContentHandler(processor) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/execution/AntTestContentHandler$AntTestOutputExtension", "createHandler"));
        }
    }
}

