/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.Location;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaTestConfigurationBase
extends JavaRunConfigurationBase
implements RefactoringListenerProvider,
SMRunnerConsolePropertiesProvider {
    private ShortenCommandLine myShortenCommandLine;
    private boolean myUseModulePath;
    @NonNls
    private static final String USE_CLASS_PATH_ONLY = "useClassPathOnly";
    private boolean myPrintAsyncStackTraceForExceptions;
    @NonNls
    private static final String PRINT_ASYNC_STACK_TRACE_FOR_EXCEPTIONS_ATTRIBUTE = "printAsyncStackTraceForExceptions";

    public JavaTestConfigurationBase(String name, @NotNull JavaRunConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        if (configurationModule == null) {
            JavaTestConfigurationBase.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JavaTestConfigurationBase.$$$reportNull$$$0(1);
        }
        super(name, configurationModule, factory);
        this.myShortenCommandLine = null;
        this.myUseModulePath = true;
        this.myPrintAsyncStackTraceForExceptions = true;
    }

    public JavaTestConfigurationBase(@NotNull JavaRunConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        if (configurationModule == null) {
            JavaTestConfigurationBase.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            JavaTestConfigurationBase.$$$reportNull$$$0(3);
        }
        super(configurationModule, factory);
        this.myShortenCommandLine = null;
        this.myUseModulePath = true;
        this.myPrintAsyncStackTraceForExceptions = true;
    }

    public abstract void bePatternConfiguration(List<PsiClass> var1, PsiMethod var2);

    public abstract void beMethodConfiguration(Location<PsiMethod> var1);

    public abstract void beClassConfiguration(PsiClass var1);

    public void withNestedClass(PsiClass aClass) {
    }

    public abstract boolean isConfiguredByElement(PsiElement var1);

    @NonNls
    public abstract String getTestType();

    public String prepareParameterizedParameter(String paramSetName) {
        return paramSetName;
    }

    public abstract TestSearchScope getTestSearchScope();

    public abstract void setSearchScope(TestSearchScope var1);

    @Nullable
    public abstract JavaTestFrameworkRunnableState<? extends JavaTestConfigurationBase> getState(@NotNull Executor var1, @NotNull ExecutionEnvironment var2) throws ExecutionException;

    @Nullable
    public ShortenCommandLine getShortenCommandLine() {
        return this.myShortenCommandLine;
    }

    public void setShortenCommandLine(@Nullable ShortenCommandLine shortenCommandLine) {
        this.myShortenCommandLine = shortenCommandLine;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JavaTestConfigurationBase.$$$reportNull$$$0(4);
        }
        super.readExternal(element);
        Element mode = element.getChild("shortenClasspath");
        this.setShortenCommandLine(mode != null ? ShortenCommandLine.valueOf((String)mode.getAttributeValue("name")) : null);
        this.myUseModulePath = element.getChild(USE_CLASS_PATH_ONLY) == null;
        String value = element.getAttributeValue(PRINT_ASYNC_STACK_TRACE_FOR_EXCEPTIONS_ATTRIBUTE);
        this.myPrintAsyncStackTraceForExceptions = value == null || Boolean.parseBoolean(value);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JavaTestConfigurationBase.$$$reportNull$$$0(5);
        }
        super.writeExternal(element);
        if (this.myShortenCommandLine != null) {
            element.addContent(new Element("shortenClasspath").setAttribute("name", this.myShortenCommandLine.name()));
        }
        if (!this.myUseModulePath) {
            element.addContent(new Element(USE_CLASS_PATH_ONLY));
        }
        if (!this.myPrintAsyncStackTraceForExceptions) {
            element.setAttribute(PRINT_ASYNC_STACK_TRACE_FOR_EXCEPTIONS_ATTRIBUTE, "false");
        }
    }

    public boolean isUseModulePath() {
        return this.myUseModulePath;
    }

    public void setUseModulePath(boolean useModulePath) {
        this.myUseModulePath = useModulePath;
    }

    public boolean isPrintAsyncStackTraceForExceptions() {
        return this.myPrintAsyncStackTraceForExceptions;
    }

    public void setPrintAsyncStackTraceForExceptions(boolean printAsyncStackTraceForExceptions) {
        this.myPrintAsyncStackTraceForExceptions = printAsyncStackTraceForExceptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationModule";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/JavaTestConfigurationBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

