/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.TargetDebuggerConnection;
import com.intellij.execution.TargetDebuggerConnectionUtil;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.EelTargetEnvironmentRequest;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.wsl.WslPath;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCommandLineState
extends CommandLineState
implements JavaCommandLine,
TargetEnvironmentAwareRunProfileState,
RemoteConnectionCreator {
    private static final Logger LOG = Logger.getInstance(JavaCommandLineState.class);
    private JavaParameters myParams;
    private TargetEnvironmentRequest myTargetEnvironmentRequest;
    private TargetedCommandLineBuilder myCommandLine;
    @Nullable
    private volatile TargetDebuggerConnection myTargetDebuggerConnection;

    protected JavaCommandLineState(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            JavaCommandLineState.$$$reportNull$$$0(0);
        }
        super(environment);
    }

    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myParams == null) {
            this.myParams = this.isReadActionRequired() ? (JavaParameters)ReadAction.compute(this::createJavaParameters) : this.createJavaParameters();
        }
        return this.myParams;
    }

    protected boolean isReadActionRequired() {
        return true;
    }

    public void clear() {
        this.myParams = null;
        if (Registry.is((String)"ide.jvm.command.line.clear.all.environments")) {
            this.myTargetEnvironmentRequest = null;
            this.myCommandLine = null;
            this.myTargetDebuggerConnection = null;
        }
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler oSProcessHandler = JavaCommandLineStateUtil.startProcess((GeneralCommandLine)this.createCommandLine(), (boolean)this.ansiColoringEnabled());
        if (oSProcessHandler == null) {
            JavaCommandLineState.$$$reportNull$$$0(1);
        }
        return oSProcessHandler;
    }

    protected boolean ansiColoringEnabled() {
        return true;
    }

    protected abstract JavaParameters createJavaParameters() throws ExecutionException;

    public TargetEnvironmentRequest createCustomTargetEnvironmentRequest() {
        try {
            JavaParameters parameters = this.getJavaParameters();
            EelTargetEnvironmentRequest.Configuration config = JavaCommandLineState.checkCreateNonLocalConfiguration(parameters.getJdk());
            return config == null ? null : new EelTargetEnvironmentRequest(config);
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static EelTargetEnvironmentRequest.Configuration checkCreateNonLocalConfiguration(@Nullable Sdk jdk) {
        if (jdk == null) {
            return null;
        }
        VirtualFile virtualFile = jdk.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        Path vitrualFilePath = virtualFile.toNioPath();
        EelDescriptor descriptor = EelProviderUtil.getEelDescriptor((Path)vitrualFilePath);
        if (descriptor != LocalEelDescriptor.INSTANCE) {
            EelTargetEnvironmentRequest.Configuration config = new EelTargetEnvironmentRequest.Configuration(EelProviderUtil.toEelApiBlocking((EelDescriptor)descriptor));
            JavaCommandLineState.addJavaLangConfig((TargetEnvironmentConfiguration)config, Objects.requireNonNull(EelNioBridgeServiceKt.asEelPath((Path)vitrualFilePath)).toString(), jdk);
            return config;
        }
        return null;
    }

    @ApiStatus.Obsolete
    public static WslTargetEnvironmentConfiguration checkCreateWslConfiguration(@Nullable Sdk jdk) {
        if (jdk == null) {
            return null;
        }
        VirtualFile virtualFile = jdk.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        WslPath wslPath = WslPath.parseWindowsUncPath((String)virtualFile.getPath());
        if (wslPath != null) {
            WslTargetEnvironmentConfiguration config = new WslTargetEnvironmentConfiguration(wslPath.getDistribution());
            JavaCommandLineState.addJavaLangConfig((TargetEnvironmentConfiguration)config, wslPath.getLinuxPath(), jdk);
            return config;
        }
        return null;
    }

    private static void addJavaLangConfig(TargetEnvironmentConfiguration config, String javaHomePath, Sdk jdk) {
        JavaLanguageRuntimeConfiguration javaConfig = new JavaLanguageRuntimeConfiguration();
        javaConfig.setHomePath(javaHomePath);
        String jdkVersionString = jdk.getVersionString();
        if (jdkVersionString != null) {
            javaConfig.setJavaVersionString(jdkVersionString);
        }
        config.addLanguageRuntime((LanguageRuntimeConfiguration)javaConfig);
    }

    protected boolean shouldPrepareDebuggerConnection() {
        return true;
    }

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        TargetDebuggerConnection targetDebuggerConnection;
        if (request == null) {
            JavaCommandLineState.$$$reportNull$$$0(2);
        }
        if (targetProgressIndicator == null) {
            JavaCommandLineState.$$$reportNull$$$0(3);
        }
        targetProgressIndicator.addSystemLine(ExecutionBundle.message((String)"progress.text.prepare.target.requirements", (Object[])new Object[0]));
        this.myTargetEnvironmentRequest = request;
        this.myTargetDebuggerConnection = targetDebuggerConnection = this.shouldPrepareDebuggerConnection() ? TargetDebuggerConnectionUtil.prepareDebuggerConnection(this, request) : null;
        this.myCommandLine = this.createTargetedCommandLine(this.myTargetEnvironmentRequest);
        if (targetDebuggerConnection != null) {
            Objects.requireNonNull(request).getTargetPortBindings().add(targetDebuggerConnection.getDebuggerPortRequest());
        }
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        TargetDebuggerConnection targetDebuggerConnection;
        if (environment == null) {
            JavaCommandLineState.$$$reportNull$$$0(4);
        }
        if (targetProgressIndicator == null) {
            JavaCommandLineState.$$$reportNull$$$0(5);
        }
        if ((targetDebuggerConnection = this.myTargetDebuggerConnection) != null) {
            targetDebuggerConnection.resolveRemoteConnection(environment);
        }
    }

    @Nullable
    public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
        TargetDebuggerConnection targetDebuggerConnection = this.myTargetDebuggerConnection;
        if (targetDebuggerConnection != null) {
            return targetDebuggerConnection.getResolvedRemoteConnection();
        }
        return null;
    }

    public boolean isPollConnection() {
        return true;
    }

    @Nullable
    public synchronized TargetEnvironmentRequest getTargetEnvironmentRequest() {
        return this.myTargetEnvironmentRequest;
    }

    @NotNull
    protected synchronized TargetedCommandLineBuilder getTargetedCommandLine() {
        TargetedCommandLineBuilder targetedCommandLineBuilder;
        if (this.myCommandLine != null) {
            TargetedCommandLineBuilder targetedCommandLineBuilder2 = this.myCommandLine;
            if (targetedCommandLineBuilder2 == null) {
                JavaCommandLineState.$$$reportNull$$$0(6);
            }
            return targetedCommandLineBuilder2;
        }
        if (RunTargetsEnabled.get() && !(this.getEnvironment().getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest)) {
            LOG.error("Command line hasn't been built yet. Probably you need to run environment#getPreparedTargetEnvironment first, or it return the environment from the previous run session");
        }
        try {
            this.getEnvironment().prepareTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
            targetedCommandLineBuilder = this.myCommandLine;
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
        if (targetedCommandLineBuilder == null) {
            JavaCommandLineState.$$$reportNull$$$0(7);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
        JavaParameters javaParameters;
        if (request == null) {
            JavaCommandLineState.$$$reportNull$$$0(8);
        }
        if (!(javaParameters = this.getJavaParameters()).isDynamicClasspath()) {
            javaParameters.setUseDynamicClasspath(this.getEnvironment().getProject());
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = javaParameters.toCommandLine(request);
        if (targetedCommandLineBuilder == null) {
            JavaCommandLineState.$$$reportNull$$$0(9);
        }
        return targetedCommandLineBuilder;
    }

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        boolean redirectErrorStream = Registry.is((String)"run.processes.with.redirectedErrorStream", (boolean)false);
        LocalTargetEnvironmentRequest request = new LocalTargetEnvironmentRequest();
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.createTargetedCommandLine((TargetEnvironmentRequest)request);
        LocalTargetEnvironment environment = request.prepareEnvironment(TargetProgressIndicator.EMPTY);
        return environment.createGeneralCommandLine(targetedCommandLineBuilder.build()).withRedirectErrorStream(redirectErrorStream);
    }

    public boolean shouldAddJavaProgramRunnerActions() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/JavaCommandLineState";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/JavaCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetedCommandLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironmentRequest";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleCreatedTargetEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

