/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.execution.filters.ExceptionLineParserImpl;
import com.intellij.execution.filters.ExceptionLineRefiner;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class FindDivergedExceptionLineHandler
extends AnAction {
    private static final String LAMBDA_KEYWORD = "lambda$";
    private final PsiFile myPsiFile;
    private final MetaInfo myMetaInfo;
    private final ExceptionLineRefiner myRefiner;
    private final Editor myEditor;

    private FindDivergedExceptionLineHandler(@NotNull PsiFile file, @NotNull MetaInfo metaInfo, @NotNull ExceptionLineRefiner refiner, @NotNull Editor targetEditor) {
        if (file == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(0);
        }
        if (metaInfo == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(1);
        }
        if (refiner == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(2);
        }
        if (targetEditor == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(3);
        }
        super(null, JavaBundle.message((String)"action.find.similar.stack.call.diverged", (Object[])new Object[]{StringUtil.getShortName((String)metaInfo.className), metaInfo.methodName}), null);
        this.myPsiFile = file;
        this.myMetaInfo = metaInfo;
        this.myRefiner = refiner;
        this.myEditor = targetEditor;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Document document;
        if (e == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(4);
        }
        if ((document = PsiDocumentManager.getInstance((Project)this.myPsiFile.getProject()).getDocument(this.myPsiFile)) == null) {
            return;
        }
        AtomicBoolean moreThanOne = new AtomicBoolean(false);
        boolean found = new PsiTargetNavigator(this.collector()).presentationProvider(element -> {
            String containerText;
            String text;
            int lineNumber = document.getLineNumber(element.getTextRange().getEndOffset());
            if (element instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)element;
                text = psiMethod.getName();
                containerText = StringUtil.getShortName((String)this.myMetaInfo.className) + ": " + (lineNumber + 1);
            } else {
                PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
                Object textElement = expression != null ? expression : element;
                TextRange textRange = textElement.getTextRange().intersection(new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)));
                if (textRange == null) {
                    textRange = element.getTextRange();
                }
                text = document.getText(textRange).strip();
                containerText = StringUtil.getShortName((String)this.myMetaInfo.className) + "." + this.myMetaInfo.methodName + "(): " + (lineNumber + 1);
            }
            return TargetPresentation.builder((String)text).containerText(containerText).presentation();
        }).elementsConsumer((elements, navigator) -> {
            PsiElement next;
            if (elements.isEmpty()) {
                return;
            }
            if (elements.size() > 1) {
                moreThanOne.set(true);
            }
            String message = (next = (PsiElement)elements.iterator().next()) instanceof PsiMethod ? JavaBundle.message((String)"action.find.similar.stack.call.methods", (Object[])new Object[]{StringUtil.getShortName((String)this.myMetaInfo.className), this.myMetaInfo.methodName}) : JavaBundle.message((String)"action.find.similar.stack.call.similar.calls", (Object[])new Object[]{StringUtil.getShortName((String)this.myMetaInfo.className), this.myMetaInfo.methodName});
            navigator.title(message);
            navigator.tabTitle(message);
        }).navigate(this.myEditor, null, element -> {
            int offset;
            PsiElement caretElement;
            if (!moreThanOne.get() && element instanceof PsiMethod && (caretElement = this.myPsiFile.findElementAt(offset = this.myEditor.getCaretModel().getOffset())) != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)caretElement, (boolean)false)) {
                this.showNotFound(JavaBundle.message((String)"action.find.similar.stack.call.location.not.found", (Object[])new Object[]{StringUtil.getShortName((String)this.myMetaInfo.className), this.myMetaInfo.methodName}));
                return true;
            }
            return EditSourceUtil.navigateToPsiElement((PsiElement)element);
        });
        if (!found) {
            this.showNotFound(JavaBundle.message((String)"action.find.similar.stack.call.methods.not.found", (Object[])new Object[]{StringUtil.getShortName((String)this.myMetaInfo.className), this.myMetaInfo.methodName}));
        }
    }

    private void showNotFound(@NlsContexts.HintText String message) {
        RelativePoint popupLocation = JBPopupFactory.getInstance().guessBestPopupLocation(this.myEditor);
        JComponent label = HintUtil.createWarningLabel((String)message.replace("<", "&lt;").replace(">", "&gt;"));
        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
        JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(4000L).setFillColor(HintUtil.getWarningColor()).createBalloon().show(popupLocation, Balloon.Position.above);
    }

    @VisibleForTesting
    @NotNull
    public Supplier<Collection<PsiElement>> collector() {
        Supplier<Collection<PsiElement>> supplier = () -> {
            final HashSet result = new HashSet();
            final ArrayList startPoints = new ArrayList();
            JavaRecursiveElementVisitor fileVisitor = new JavaRecursiveElementVisitor(){

                public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
                    if (initializer == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (FindDivergedExceptionLineHandler.this.myMetaInfo.callType == MetaInfoCallType.STATIC_INIT) {
                        startPoints.add(initializer);
                    }
                }

                public void visitField(@NotNull PsiField field) {
                    if (field == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (FindDivergedExceptionLineHandler.this.myMetaInfo.callType == MetaInfoCallType.STATIC_INIT && field.hasModifierProperty("static")) {
                        startPoints.add(field);
                    }
                    if (FindDivergedExceptionLineHandler.this.myMetaInfo.callType == MetaInfoCallType.NON_STATIC_INIT && !field.hasModifier(JvmModifier.STATIC)) {
                        startPoints.add(field);
                    }
                }

                public void visitMethod(@NotNull PsiMethod method) {
                    if (method == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    ProgressManager.checkCanceled();
                    if (FindDivergedExceptionLineHandler.this.myMetaInfo.callType != MetaInfoCallType.LAMBDA && FindDivergedExceptionLineHandler.placeMatch((PsiElement)method, FindDivergedExceptionLineHandler.this.myMetaInfo)) {
                        startPoints.add(method);
                    }
                    if (FindDivergedExceptionLineHandler.this.myMetaInfo.callType == MetaInfoCallType.LAMBDA) {
                        super.visitMethod(method);
                    }
                }

                public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                    PsiMethod method;
                    if (expression == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    ProgressManager.checkCanceled();
                    if (FindDivergedExceptionLineHandler.this.myMetaInfo.callType == MetaInfoCallType.LAMBDA && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class)) != null && FindDivergedExceptionLineHandler.placeMatch((PsiElement)method, FindDivergedExceptionLineHandler.this.myMetaInfo)) {
                        startPoints.add(expression);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "initializer";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "field";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "method";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/filters/FindDivergedExceptionLineHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClassInitializer";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitField";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethod";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLambdaExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myPsiFile.acceptChildren((PsiElementVisitor)fileVisitor);
            for (PsiElement startPoint : startPoints) {
                PsiTreeUtil.processElements((PsiElement)startPoint, (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

                    public boolean execute(@NotNull PsiElement element) {
                        if (element == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        ProgressManager.checkCanceled();
                        ExceptionLineRefiner.RefinerMatchResult matchedElement = FindDivergedExceptionLineHandler.this.myRefiner.matchElement(element);
                        if (matchedElement != null && matchedElement.target() instanceof Navigatable) {
                            PsiElement target = matchedElement.target();
                            PsiMethod matchedElementMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)target, PsiMethod.class);
                            if (matchedElementMethod != null && FindDivergedExceptionLineHandler.placeMatch((PsiElement)matchedElementMethod, FindDivergedExceptionLineHandler.this.myMetaInfo)) {
                                result.add(target);
                            }
                            if (matchedElementMethod == null && (FindDivergedExceptionLineHandler.this.myMetaInfo.callType == MetaInfoCallType.NON_STATIC_INIT || FindDivergedExceptionLineHandler.this.myMetaInfo.callType == MetaInfoCallType.STATIC_INIT)) {
                                result.add(target);
                            }
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/filters/FindDivergedExceptionLineHandler$2", "execute"));
                    }
                });
            }
            if (result.isEmpty()) {
                result.addAll(startPoints);
            }
            return result.stream().sorted(Comparator.comparing(element -> element.getTextOffset())).collect(Collectors.toList());
        };
        if (supplier == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(5);
        }
        return supplier;
    }

    private static boolean placeMatch(@NotNull PsiElement element, @NotNull MetaInfo metaInfo) {
        PsiClass psiClass;
        if (element == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(6);
        }
        if (metaInfo == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(7);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null) {
            return false;
        }
        if (!metaInfo.className.equals(psiClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            return metaInfo.methodName.equals(psiMethod.getName()) || metaInfo.callType == MetaInfoCallType.NON_STATIC_INIT && psiMethod.isConstructor();
        }
        return metaInfo.callType == MetaInfoCallType.NON_STATIC_INIT || metaInfo.callType == MetaInfoCallType.STATIC_INIT;
    }

    static @Nullable ExceptionLineParserImpl.LinkInfo createLinkInfo(@Nullable PsiFile file, @Nullable String className, @Nullable String methodName, @Nullable ExceptionLineRefiner refiner, int lineStart, int lineEnd, @Nullable Editor targetEditor) {
        if (file == null || !file.isValid()) {
            return null;
        }
        FindDivergedExceptionLineHandler methodHandler = FindDivergedExceptionLineHandler.getFindMethodHandler(file, className, methodName, refiner, lineStart, lineEnd, targetEditor);
        if (methodHandler == null) {
            return null;
        }
        return new ExceptionLineParserImpl.LinkInfo(file, null, null, methodHandler, finder -> {});
    }

    @Nullable
    public static FindDivergedExceptionLineHandler getFindMethodHandler(@Nullable PsiFile file, @Nullable String className, @Nullable String methodName, @Nullable ExceptionLineRefiner refiner, int lineStart, int lineEnd, @Nullable Editor targetEditor) {
        if (file == null || className == null || methodName == null || refiner == null || targetEditor == null) {
            return null;
        }
        if (DumbService.isDumb((Project)file.getProject())) {
            return null;
        }
        if (!file.getLanguage().is((Language)JavaLanguage.INSTANCE)) {
            return null;
        }
        if (FindDivergedExceptionLineHandler.canBeBridge(file, lineStart, lineEnd, methodName)) {
            return null;
        }
        if (FindDivergedExceptionLineHandler.hasAnonymousClass(className)) {
            return null;
        }
        className = className.replaceAll("\\$", ".");
        MetaInfoCallType callType = MetaInfoCallType.ORDINARY;
        if (methodName.contains("$")) {
            int lambdaIndex = methodName.indexOf(LAMBDA_KEYWORD);
            if (lambdaIndex != -1) {
                callType = MetaInfoCallType.LAMBDA;
                int nextDelimiter = (methodName = methodName.substring(lambdaIndex + LAMBDA_KEYWORD.length())).indexOf("$");
                if (nextDelimiter != -1 && ((methodName = methodName.substring(0, nextDelimiter)).contains("$") || methodName.equals("static") || methodName.equals("new"))) {
                    return null;
                }
            } else {
                return null;
            }
            if (methodName.isEmpty()) {
                return null;
            }
        }
        callType = FindDivergedExceptionLineHandler.findInitCallType(methodName, callType);
        MetaInfo metaInfo = new MetaInfo(className, methodName, callType);
        if (FindDivergedExceptionLineHandler.skipByRefiner(file, refiner, lineStart, lineEnd)) {
            return null;
        }
        return new FindDivergedExceptionLineHandler(file, metaInfo, refiner, targetEditor);
    }

    @NotNull
    private static MetaInfoCallType findInitCallType(@NotNull String methodName, @NotNull MetaInfoCallType callType) {
        if (methodName == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(8);
        }
        if (callType == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(9);
        }
        if (callType == MetaInfoCallType.ORDINARY) {
            if ("<init>".equals(methodName)) {
                callType = MetaInfoCallType.NON_STATIC_INIT;
            } else if ("<clinit>".equals(methodName)) {
                callType = MetaInfoCallType.STATIC_INIT;
            }
        }
        MetaInfoCallType metaInfoCallType = callType;
        if (metaInfoCallType == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(10);
        }
        return metaInfoCallType;
    }

    private static boolean skipByRefiner(@NotNull PsiFile file, @NotNull ExceptionLineRefiner refiner, int lineStart, int lineEnd) {
        if (file == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(11);
        }
        if (refiner == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(12);
        }
        if (refiner.getExceptionInfo() != null) {
            PsiElement element = file.findElementAt(lineStart);
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            if (document == null) {
                return true;
            }
            while (element != null && element.getTextRange().getStartOffset() < lineEnd) {
                int lineNumberEnd;
                int startOffset;
                int lineNumberStart;
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiField.class});
                if (parent != null && (lineNumberStart = document.getLineNumber(startOffset = parent.getTextRange().getStartOffset())) != (lineNumberEnd = document.getLineNumber(startOffset + parent.getTextLength()))) {
                    return true;
                }
                element = PsiTreeUtil.nextLeaf((PsiElement)element);
            }
        }
        return false;
    }

    private static boolean canBeBridge(PsiFile file, int lineStart, int lineEnd, String methodName) {
        if (!file.isValid()) {
            return false;
        }
        PsiElement element = file.findElementAt(lineStart);
        while (element != null && element.getTextRange().getStartOffset() < lineEnd) {
            PsiClass targetClass;
            PsiElement parent;
            PsiKeyword keyword;
            PsiElement finalElement = element;
            if (finalElement instanceof PsiKeyword && (keyword = (PsiKeyword)finalElement).getTokenType().equals(JavaTokenType.CLASS_KEYWORD) && (parent = finalElement.getParent()) instanceof PsiClass && ((targetClass = (PsiClass)parent).getExtendsListTypes().length > 0 || targetClass.getImplementsListTypes().length > 0) && ContainerUtil.exists((Object[])targetClass.getMethods(), psiMethod -> methodName.equals(psiMethod.getName()))) {
                return true;
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return false;
    }

    private static boolean hasAnonymousClass(@NotNull String className) {
        int classAdditionalInfoIndex;
        if (className == null) {
            FindDivergedExceptionLineHandler.$$$reportNull$$$0(13);
        }
        if ((classAdditionalInfoIndex = className.indexOf("$")) != -1) {
            String shortName = StringUtil.getShortName((String)className, (char)'$');
            if (shortName.isEmpty()) {
                return true;
            }
            if (Character.isDigit(shortName.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaInfo";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refiner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/FindDivergedExceptionLineHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/FindDivergedExceptionLineHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collector";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findInitCallType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "placeMatch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findInitCallType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "skipByRefiner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasAnonymousClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10 -> new IllegalStateException(string);
        };
    }

    private record MetaInfo(@NonNls String className, @NonNls String methodName, @NotNull MetaInfoCallType callType) {
        @NotNull
        private final MetaInfoCallType callType;

        private MetaInfo(@NonNls String className, @NonNls String methodName, @NotNull MetaInfoCallType callType) {
            if (callType == null) {
                MetaInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public MetaInfoCallType callType() {
            MetaInfoCallType metaInfoCallType = this.callType;
            if (metaInfoCallType == null) {
                MetaInfo.$$$reportNull$$$0(1);
            }
            return metaInfoCallType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/FindDivergedExceptionLineHandler$MetaInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/FindDivergedExceptionLineHandler$MetaInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "callType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static enum MetaInfoCallType {
        LAMBDA,
        STATIC_INIT,
        NON_STATIC_INIT,
        ORDINARY;

    }
}

