/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.execution.jar.JarApplicationConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JarApplicationConfigurationProducer
extends LazyRunConfigurationProducer<JarApplicationConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        JarApplicationConfigurationType jarApplicationConfigurationType = JarApplicationConfigurationType.getInstance();
        if (jarApplicationConfigurationType == null) {
            JarApplicationConfigurationProducer.$$$reportNull$$$0(0);
        }
        return jarApplicationConfigurationType;
    }

    protected boolean setupConfigurationFromContext(@NotNull JarApplicationConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile file;
        if (configuration == null) {
            JarApplicationConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JarApplicationConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            JarApplicationConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((file = JarApplicationConfigurationProducer.getJarFileFromContext(context)) != null) {
            configuration.setName(file.getName());
            configuration.setJarPath(file.getPath());
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getJarFileFromContext(ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        VirtualFile file = location.getVirtualFile();
        return file != null && FileUtilRt.extensionEquals((String)file.getName(), (String)"jar") ? file : null;
    }

    public boolean isConfigurationFromContext(@NotNull JarApplicationConfiguration configuration, @NotNull ConfigurationContext context) {
        VirtualFile file;
        if (configuration == null) {
            JarApplicationConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JarApplicationConfigurationProducer.$$$reportNull$$$0(5);
        }
        return (file = JarApplicationConfigurationProducer.getJarFileFromContext(context)) != null && VfsUtilCore.pathEqualsTo((VirtualFile)file, (String)configuration.getJarPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/jar/JarApplicationConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/jar/JarApplicationConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

