/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/remote/JavaRemoteDebugRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "<init>", "()V", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "canImport", "", "typeName", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "intellij.java.execution.impl"})
public final class JavaRemoteDebugRunConfigurationImporter
implements RunConfigurationImporter {
    public void process(@NotNull Project project, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, ?> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (!(runConfiguration instanceof RemoteConfiguration)) {
            throw new IllegalArgumentException("Unexpected type of run configuration: " + runConfiguration.getClass());
        }
        Object obj = cfg.get("moduleName");
        String string = obj instanceof String ? (String)obj : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Module module = modelsProvider.getModifiableModuleModel().findModuleByName(it);
            if (module != null) {
                ((RemoteConfiguration)runConfiguration).setModule(module);
            }
        }
        RemoteConfiguration $this$process_u24lambda_u241 = (RemoteConfiguration)runConfiguration;
        boolean bl = false;
        Object obj2 = cfg.get("transport");
        $this$process_u24lambda_u241.USE_SOCKET_TRANSPORT = !Intrinsics.areEqual((Object)(obj2 instanceof String ? (String)obj2 : null), (Object)"SHARED_MEM");
        obj2 = cfg.get("mode");
        $this$process_u24lambda_u241.SERVER_MODE = Intrinsics.areEqual((Object)(obj2 instanceof String ? (String)obj2 : null), (Object)"LISTEN");
        Object obj3 = cfg.get("port");
        Number number = obj3 instanceof Number ? (Number)((Number)obj3) : (Number)null;
        $this$process_u24lambda_u241.PORT = number != null ? String.valueOf(number.intValue()) : null;
        obj2 = cfg.get("host");
        $this$process_u24lambda_u241.HOST = obj2 instanceof String ? (String)obj2 : null;
        obj2 = cfg.get("sharedMemoryAddress");
        $this$process_u24lambda_u241.SHMEM_ADDRESS = obj2 instanceof String ? (String)obj2 : null;
        obj3 = cfg.get("autoRestart");
        Boolean bl2 = obj3 instanceof Boolean ? (Boolean)obj3 : null;
        $this$process_u24lambda_u241.AUTO_RESTART = bl2 != null ? bl2 : false;
    }

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)typeName, (Object)"remote");
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return ((RemoteConfigurationType)ConfigurationTypeUtil.findConfigurationType(RemoteConfigurationType.class)).getConfigurationFactories()[0];
    }
}

