/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.actions.ShowAffectedTestsAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

final class AffectedTestsInChangeListPainter
implements ChangeListDecorator {
    private final Project myProject;

    AffectedTestsInChangeListPainter(@NotNull Project project) {
        if (project == null) {
            AffectedTestsInChangeListPainter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void decorateChangeList(@NotNull LocalChangeList changeList, @NotNull ColoredTreeCellRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (changeList == null) {
            AffectedTestsInChangeListPainter.$$$reportNull$$$0(1);
        }
        if (renderer == null) {
            AffectedTestsInChangeListPainter.$$$reportNull$$$0(2);
        }
        if (!Registry.is((String)"show.affected.tests.in.changelists")) {
            return;
        }
        if (!ShowAffectedTestsAction.isEnabled(this.myProject)) {
            return;
        }
        if (changeList.getChanges().isEmpty()) {
            return;
        }
        renderer.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        renderer.append(JavaCompilerBundle.message((String)"test.discovery.find.affected.tests", (Object[])new Object[0]), new SimpleTextAttributes(16, NamedColorUtil.getInactiveTextColor()), () -> {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)renderer.getTree());
            Change[] changes = changeList.getChanges().toArray(Change.EMPTY_CHANGE_ARRAY);
            ShowAffectedTestsAction.showDiscoveredTestsByChanges(this.myProject, changes, changeList.getName(), dataContext);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testDiscovery/AffectedTestsInChangeListPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "decorateChangeList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

