/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DiscoveredTestsTreeModel
extends BaseTreeModel<Object>
implements InvokerSupplier {
    private final Invoker myInvoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this);
    private final Object myRoot = ObjectUtils.NULL;
    private final List<Node.Clazz> myTestClasses = new SmartList();
    private final Map<Node.Clazz, List<Node.Method>> myTests = new HashMap<Node.Clazz, List<Node.Method>>();

    DiscoveredTestsTreeModel() {
    }

    public synchronized List<?> getChildren(Object parent) {
        if (parent == this.myRoot) {
            return this.getTestClasses();
        }
        if (parent instanceof Node.Clazz) {
            return new ArrayList(this.myTests.get((Node.Clazz)parent));
        }
        return Collections.emptyList();
    }

    synchronized List<Node<PsiClass>> getTestClasses() {
        return new ArrayList<Node<PsiClass>>(this.myTestClasses);
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public boolean isLeaf(Object object) {
        return this.myRoot != object && super.isLeaf(object);
    }

    synchronized void addTest(@NotNull PsiClass testClass, @Nullable PsiMethod testMethod, @Nullable String parameter) {
        Node.Method actualMethodNode;
        int methodIdx;
        if (testClass == null) {
            DiscoveredTestsTreeModel.$$$reportNull$$$0(0);
        }
        Node.Clazz classNode = (Node.Clazz)ReadAction.compute(() -> new Node.Clazz(testClass));
        Node.Method methodNode = testMethod == null ? null : (Node.Method)ReadAction.compute(() -> new Node.Method(testMethod));
        int idx = (Integer)ReadAction.compute(() -> Collections.binarySearch(this.myTestClasses, classNode, Comparator.comparing(c -> c.getName()).thenComparing(c -> c.getPackageName())));
        if (idx < 0) {
            int insertIdx = -idx - 1;
            this.myTestClasses.add(insertIdx, classNode);
            this.myTests.put(classNode, (List<Node.Method>)(methodNode == null ? new SmartList() : new SmartList((Object)methodNode)));
            this.treeStructureChanged(null, null, null);
            return;
        }
        List<Node.Method> testMethods = this.myTests.get(this.myTestClasses.get(idx));
        int n = methodIdx = methodNode != null ? (Integer)ReadAction.compute(() -> Collections.binarySearch(testMethods, methodNode, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName())))) : -1;
        if (methodIdx < 0) {
            methodIdx = -methodIdx - 1;
            if (methodNode != null) {
                testMethods.add(methodIdx, methodNode);
            }
            actualMethodNode = methodNode;
        } else {
            actualMethodNode = testMethods.get(methodIdx);
        }
        if (actualMethodNode != null && parameter != null) {
            actualMethodNode.addParameter(parameter);
        }
        this.treeStructureChanged(null, null, null);
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            DiscoveredTestsTreeModel.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    @Nullable
    public static String getClassName(@NotNull PsiClass c) {
        PsiClass containingClass;
        if (c == null) {
            DiscoveredTestsTreeModel.$$$reportNull$$$0(2);
        }
        if (c instanceof PsiAnonymousClass && (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)c, PsiClass.class)) != null) {
            return ClassUtil.getJVMClassName((PsiClass)containingClass) + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)c));
        }
        return ClassUtil.getJVMClassName((PsiClass)c);
    }

    synchronized TestMethodUsage @NotNull [] getTestMethods() {
        TestMethodUsage[] testMethodUsageArray = (TestMethodUsage[])this.myTests.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(m -> new TestMethodUsage(m.getPointer(), ((Node.Clazz)e.getKey()).getPointer(), m.getParameters()))).toArray(TestMethodUsage[]::new);
        if (testMethodUsageArray == null) {
            DiscoveredTestsTreeModel.$$$reportNull$$$0(3);
        }
        return testMethodUsageArray;
    }

    synchronized int getTestCount() {
        return this.myTests.values().stream().mapToInt(ms -> ms.size()).sum();
    }

    synchronized int getTestClassesCount() {
        return this.myTests.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTest";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    public static abstract class Node<Psi extends PsiMember> {
        @NotNull
        private final SmartPsiElementPointer<Psi> myPointer;
        private final String myName;
        private final Icon myIcon;

        private Node(@NotNull Psi psi) {
            if (psi == null) {
                Node.$$$reportNull$$$0(0);
            }
            this(psi, o -> o.getName());
        }

        public Node(@NotNull Psi psi, Function<? super Psi, String> calcName) {
            if (psi == null) {
                Node.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.createPointer(psi);
            this.myName = (String)calcName.fun(psi);
            this.myIcon = psi.getIcon(2);
        }

        @NotNull
        public SmartPsiElementPointer<Psi> getPointer() {
            SmartPsiElementPointer<Psi> smartPsiElementPointer = this.myPointer;
            if (smartPsiElementPointer == null) {
                Node.$$$reportNull$$$0(2);
            }
            return smartPsiElementPointer;
        }

        @NlsSafe
        String getName() {
            return this.myName;
        }

        Icon getIcon() {
            return this.myIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPointer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        static final class Method
        extends Node<PsiMethod> {
            private final Collection<String> myParameters;

            private Method(@NotNull PsiMethod method) {
                if (method == null) {
                    Method.$$$reportNull$$$0(0);
                }
                super(method);
                this.myParameters = new HashSet<String>();
            }

            public void addParameter(@NotNull String parameter) {
                if (parameter == null) {
                    Method.$$$reportNull$$$0(1);
                }
                this.myParameters.add(parameter);
            }

            @NotNull
            Collection<String> getParameters() {
                Collection<String> collection = this.myParameters;
                if (collection == null) {
                    Method.$$$reportNull$$$0(2);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node$Method";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node$Method";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameters";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "addParameter";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        static class Clazz
        extends Node<PsiClass> {
            private final String myPackageName;

            Clazz(@NotNull PsiClass psi) {
                if (psi == null) {
                    Clazz.$$$reportNull$$$0(0);
                }
                super(psi, o -> StringUtil.notNullize((String)o.getName(), (String)StringUtil.notNullize((String)DiscoveredTestsTreeModel.getClassName(o), (String)"<null>")));
                this.myPackageName = PsiUtil.getPackageName((PsiClass)psi);
            }

            @NlsSafe
            String getPackageName() {
                return this.myPackageName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTreeModel$Node$Clazz", "<init>"));
            }
        }
    }
}

