/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.application.options.ModulesCombo;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.core.JavaPsiBundle;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SortedComboBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationModuleSelector {
    @NotNull
    private final Project myProject;
    private final ModulesCombo myModulesDescriptionsComboBox;
    private final JComboBox<? extends Module> myModulesList;

    @Deprecated(forRemoval=true)
    public ConfigurationModuleSelector(@NotNull Project project, JComboBox<? extends Module> modulesList) {
        if (project == null) {
            ConfigurationModuleSelector.$$$reportNull$$$0(0);
        }
        final String noModule = JavaPsiBundle.message((String)"list.item.no.module", (Object[])new Object[0]);
        this.myProject = project;
        this.myModulesList = modulesList;
        this.myModulesDescriptionsComboBox = null;
        ComboboxSpeedSearch search = new ComboboxSpeedSearch(this, modulesList, null){

            protected String getElementText(Object element) {
                if (element instanceof Module) {
                    return ((Module)element).getName();
                }
                if (element == null) {
                    return noModule;
                }
                return super.getElementText(element);
            }
        };
        search.setupListeners();
        this.myModulesList.setModel((ComboBoxModel<? extends Module>)new SortedComboBoxModel((Comparator)ModulesAlphaComparator.INSTANCE));
        this.myModulesList.setRenderer((ListCellRenderer<? extends Module>)new ModuleListCellRenderer(noModule));
    }

    public ConfigurationModuleSelector(@NotNull Project project, ModulesComboBox modulesComboBox) {
        if (project == null) {
            ConfigurationModuleSelector.$$$reportNull$$$0(1);
        }
        this(project, modulesComboBox, JavaPsiBundle.message((String)"list.item.no.module", (Object[])new Object[0]));
    }

    public ConfigurationModuleSelector(@NotNull Project project, ModuleDescriptionsComboBox modulesDescriptionsComboBox) {
        if (project == null) {
            ConfigurationModuleSelector.$$$reportNull$$$0(2);
        }
        this(project, (ModulesCombo)modulesDescriptionsComboBox, JavaPsiBundle.message((String)"list.item.no.module", (Object[])new Object[0]));
    }

    public ConfigurationModuleSelector(@NotNull Project project, ModulesCombo modulesDescriptionsComboBox) {
        if (project == null) {
            ConfigurationModuleSelector.$$$reportNull$$$0(3);
        }
        this(project, modulesDescriptionsComboBox, JavaPsiBundle.message((String)"list.item.no.module", (Object[])new Object[0]));
    }

    private ConfigurationModuleSelector(@NotNull Project project, ModulesCombo modulesDescriptionsComboBox, @NlsContexts.ListItem @Nullable String emptySelectionText) {
        if (project == null) {
            ConfigurationModuleSelector.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myModulesDescriptionsComboBox = modulesDescriptionsComboBox;
        this.myModulesList = null;
        if (emptySelectionText != null) {
            modulesDescriptionsComboBox.allowEmptySelection(emptySelectionText);
        }
    }

    public ConfigurationModuleSelector(@NotNull Project project, ModulesComboBox modulesComboBox, @NlsContexts.ListItem String noModule) {
        if (project == null) {
            ConfigurationModuleSelector.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.myModulesList = modulesComboBox;
        this.myModulesDescriptionsComboBox = null;
        modulesComboBox.allowEmptySelection(noModule);
    }

    public void applyTo(ModuleBasedConfiguration configurationModule) {
        if (this.myModulesList != null) {
            configurationModule.setModule((Module)this.myModulesList.getSelectedItem());
        } else {
            configurationModule.setModuleName(this.myModulesDescriptionsComboBox.getSelectedModuleName());
        }
    }

    public void reset(ModuleBasedConfiguration configuration) {
        this.reset();
        if (this.myModulesList != null) {
            this.myModulesList.setSelectedItem(configuration.getConfigurationModule().getModule());
        } else {
            this.myModulesDescriptionsComboBox.setSelectedModule(this.myProject, configuration.getConfigurationModule().getModuleName());
        }
    }

    public void reset() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        ArrayList<Module> list = new ArrayList<Module>();
        for (Module module : modules) {
            if (!this.isModuleAccepted(module)) continue;
            list.add(module);
        }
        this.setModules(list);
    }

    public boolean isModuleAccepted(Module module) {
        return ModuleTypeManager.getInstance().isClasspathProvider(ModuleType.get((Module)module));
    }

    public Project getProject() {
        return this.myProject;
    }

    public JavaRunConfigurationModule getConfigurationModule() {
        JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(this.getProject(), false);
        configurationModule.setModule(this.getModule());
        return configurationModule;
    }

    private void setModules(Collection<? extends Module> modules) {
        if (this.myModulesDescriptionsComboBox != null) {
            this.myModulesDescriptionsComboBox.setModules(modules);
        } else if (this.myModulesList instanceof ModulesComboBox) {
            ((ModulesComboBox)this.myModulesList).setModules(modules);
        } else {
            SortedComboBoxModel model = (SortedComboBoxModel)this.myModulesList.getModel();
            model.setAll(modules);
            model.add(null);
        }
    }

    public Module getModule() {
        return this.myModulesDescriptionsComboBox != null ? this.myModulesDescriptionsComboBox.getSelectedModule() : (Module)this.myModulesList.getSelectedItem();
    }

    @Nullable
    public PsiClass findClass(String className) {
        return this.getConfigurationModule().findClass(className);
    }

    public String getModuleName() {
        Module module = this.getModule();
        return module == null ? "" : module.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ui/ConfigurationModuleSelector", "<init>"));
    }
}

