/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntryKt;
import com.intellij.testIntegration.SuiteEntry;
import com.intellij.testIntegration.TestEntryVisitor;
import java.util.Date;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lcom/intellij/testIntegration/SingleTestEntry;", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "url", "", "runDate", "Ljava/util/Date;", "runConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "magnitude", "Lcom/intellij/execution/testframework/sm/runner/states/TestStateInfo$Magnitude;", "<init>", "(Ljava/lang/String;Ljava/util/Date;Lcom/intellij/execution/RunnerAndConfigurationSettings;Lcom/intellij/execution/testframework/sm/runner/states/TestStateInfo$Magnitude;)V", "getUrl", "()Ljava/lang/String;", "getRunDate", "()Ljava/util/Date;", "getRunConfiguration", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "presentation", "getPresentation", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "failed", "", "getFailed", "()Z", "suite", "Lcom/intellij/testIntegration/SuiteEntry;", "getSuite", "()Lcom/intellij/testIntegration/SuiteEntry;", "setSuite", "(Lcom/intellij/testIntegration/SuiteEntry;)V", "accept", "", "visitor", "Lcom/intellij/testIntegration/TestEntryVisitor;", "intellij.java.execution.impl"})
public final class SingleTestEntry
implements RecentTestsPopupEntry {
    @NotNull
    private final String url;
    @NotNull
    private final Date runDate;
    @NotNull
    private final RunnerAndConfigurationSettings runConfiguration;
    @NotNull
    private final String presentation;
    @Nullable
    private final Icon icon;
    private final boolean failed;
    @Nullable
    private SuiteEntry suite;

    public SingleTestEntry(@NotNull String url, @NotNull Date runDate, @NotNull RunnerAndConfigurationSettings runConfiguration, @NotNull TestStateInfo.Magnitude magnitude) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)runDate, (String)"runDate");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)magnitude, (String)"magnitude");
        this.url = url;
        this.runDate = runDate;
        this.runConfiguration = runConfiguration;
        this.presentation = RunConfigurationEntryKt.access$toClassName(this.url, 1);
        this.icon = TestIconMapper.getIcon((TestStateInfo.Magnitude)magnitude);
        this.failed = magnitude == TestStateInfo.Magnitude.ERROR_INDEX || magnitude == TestStateInfo.Magnitude.FAILED_INDEX;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public Date getRunDate() {
        return this.runDate;
    }

    @NotNull
    public final RunnerAndConfigurationSettings getRunConfiguration() {
        return this.runConfiguration;
    }

    @Override
    @NotNull
    public String getPresentation() {
        return this.presentation;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean getFailed() {
        return this.failed;
    }

    @Nullable
    public final SuiteEntry getSuite() {
        return this.suite;
    }

    public final void setSuite(@Nullable SuiteEntry suiteEntry) {
        this.suite = suiteEntry;
    }

    @Override
    public void accept(@NotNull TestEntryVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visitTest(this);
    }
}

