/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.copyright;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.psi.UpdatePsiFileCopyright;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UpdateJavaFileCopyright
extends UpdatePsiFileCopyright {
    private static final Logger LOG = Logger.getInstance((String)UpdateJavaFileCopyright.class.getName());

    public UpdateJavaFileCopyright(Project project, Module module, VirtualFile root, CopyrightProfile options) {
        super(project, module, root, options);
    }

    protected boolean accept() {
        return this.getFile() instanceof PsiJavaFile;
    }

    protected void scanFile() {
        LOG.debug("updating " + String.valueOf(this.getFile().getVirtualFile()));
        PsiClassOwner javaFile = (PsiClassOwner)this.getFile();
        PsiElement pkg = this.getPackageStatement();
        PsiElement[] imports = this.getImportsList();
        PsiClass topClass = null;
        PsiClass[] classes = javaFile.getClasses();
        if (classes.length > 0) {
            topClass = classes[0];
        }
        PsiElement first = javaFile.getFirstChild();
        int location = this.getLanguageOptions().getFileLocation();
        if (pkg != null) {
            this.checkComments(first, pkg, location == 1);
            first = pkg;
        } else if (location == 1) {
            location = 2;
        }
        if (imports != null && imports.length > 0) {
            this.checkComments(first, imports[0], location == 2);
            first = imports[0];
        } else if (location == 2) {
            location = 3;
        }
        if (topClass != null) {
            ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
            this.collectComments(first, (PsiElement)topClass, comments);
            this.collectComments(topClass.getFirstChild(), (PsiElement)topClass.getModifierList(), comments);
            this.checkCommentsForTopClass(topClass, location, comments);
        } else if (location == 3) {
            // empty if block
        }
    }

    protected void checkCommentsForTopClass(PsiClass topClass, int location, List<PsiComment> comments) {
        this.checkComments((PsiElement)topClass.getModifierList(), location == 3, comments);
    }

    protected PsiElement @Nullable [] getImportsList() {
        PsiJavaFile javaFile = (PsiJavaFile)this.getFile();
        assert (javaFile != null);
        PsiImportList importList = javaFile.getImportList();
        return importList == null ? null : importList.getChildren();
    }

    @Nullable
    protected PsiElement getPackageStatement() {
        PsiJavaFile javaFile = (PsiJavaFile)this.getFile();
        assert (javaFile != null);
        return javaFile.getPackageStatement();
    }

    static final class UpdateJavaCopyrightsProvider
    extends UpdateCopyrightsProvider {
        UpdateJavaCopyrightsProvider() {
        }

        public UpdateCopyright createInstance(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
            return new UpdateJavaFileCopyright(project, module, file, options);
        }
    }
}

