/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.compose;

import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.compose.ComposeUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class ComposeKeyCheckBranchFilter
extends CoverageFilter {
    private int myKeyIndex;
    private State myState = State.INITIAL;
    private int mySavedVarIndex = -1;

    @Override
    public boolean isApplicable(InstrumentationData context) {
        return ComposeUtils.isComposeMethod(context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initFilter(MethodVisitor methodVisitor, InstrumentationData context) {
        void var2_2;
        void var3_3;
        void var1_1;
        KotlinDefaultArgsBranchFilter defaultArgsFilter = new KotlinDefaultArgsBranchFilter();
        defaultArgsFilter.initFilter((MethodVisitor)var1_1, context);
        super.initFilter((MethodVisitor)var3_3, (InstrumentationData)var2_2);
        this.myKeyIndex = this.getKeyParameterVarIndex();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitVarInsn(int opcode, int varIndex) {
        void var1_1;
        super.visitVarInsn(opcode, varIndex);
        if ((varIndex == this.myKeyIndex || varIndex == this.mySavedVarIndex) && opcode == 21) {
            this.myState = State.LOAD_LAST;
            return;
        }
        if (this.myState == State.LOAD_LAST && var1_1 == 54) {
            void var2_2;
            this.mySavedVarIndex = var2_2;
            this.myState = State.SAVE_LAST;
            return;
        }
        this.myState = State.INITIAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInsn(int opcode) {
        void var1_1;
        void var2_2;
        super.visitInsn(opcode);
        boolean isConst = InstrumentationUtils.isIntConstLoading(opcode);
        if (isConst && this.myState == State.LOAD_LAST) {
            this.myState = State.LOAD_CONST;
            return;
        }
        if (var2_2 != false && this.myState == State.AND) {
            this.myState = State.LOAD_CONST_2;
            return;
        }
        if (var1_1 == 126 && this.myState == State.LOAD_CONST) {
            this.myState = State.AND;
            return;
        }
        this.myState = State.INITIAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitIntInsn(int opcode, int operand) {
        void var1_1;
        void var2_2;
        super.visitIntInsn(opcode, (int)var2_2);
        boolean isConst = InstrumentationUtils.isIntConstLoading(opcode);
        if (isConst && this.myState == State.LOAD_LAST) {
            this.myState = State.LOAD_CONST;
            return;
        }
        if (var1_1 != false && this.myState == State.AND) {
            this.myState = State.LOAD_CONST_2;
            return;
        }
        this.myState = State.INITIAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitJumpInsn(int opcode, Label label) {
        void var1_1;
        void var2_2;
        super.visitJumpInsn(opcode, (Label)var2_2);
        if (opcode == 160 && this.myState == State.LOAD_CONST_2) {
            this.myContext.removeLastJump();
            this.myState = State.COMPARE;
            return;
        }
        if (var1_1 == 154 && (this.myState == State.LOAD_LAST || this.myState == State.AND)) {
            this.myContext.removeLastJump();
            this.myState = State.COMPARE;
            return;
        }
        this.myState = State.INITIAL;
    }

    /*
     * WARNING - void declaration
     */
    private int getKeyParameterVarIndex() {
        void var3_3;
        String string = this.myContext.getMethodDesc();
        Type[] types = Type.getArgumentTypes(string);
        int composerIndex = ComposeUtils.getComposerIndex(types);
        if (composerIndex < 0) {
            return -1;
        }
        int index = 0;
        for (int i = 0; i <= composerIndex; ++i) {
            index += types[i].getSize();
        }
        if ((8 & this.myContext.getMethodAccess()) == 0) {
            ++index;
        }
        return (int)var3_3;
    }

    private static enum State {
        INITIAL,
        LOAD_LAST,
        SAVE_LAST,
        LOAD_CONST,
        AND,
        LOAD_CONST_2,
        COMPARE;

    }
}

