/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.lines.BaseLineFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class ClosingBracesFilter
extends BaseLineFilter {
    private boolean mySeenReturn;
    private boolean mySeenGoto;
    private int myLinesCount = 0;

    @Override
    public boolean isApplicable(InstrumentationData context) {
        return true;
    }

    @Override
    protected boolean shouldRemoveLine() {
        return (this.mySeenReturn || this.mySeenGoto) && this.myLinesCount > 1;
    }

    @Override
    protected void onLineRemoved() {
        --this.myLinesCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        if (this.getCurrentLine() != line) {
            ++this.myLinesCount;
        }
        super.visitLineNumber((int)var1_1, (Label)var2_2);
        this.mySeenReturn = false;
        this.mySeenGoto = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInsn(int opcode) {
        void var1_1;
        this.mv.visitInsn(opcode);
        if (172 <= opcode && opcode <= 177) {
            this.mySeenReturn = true;
            return;
        }
        if (opcode == 87) {
            return;
        }
        if (var1_1 == false) {
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitJumpInsn(int opcode, Label label) {
        void var1_1;
        void var2_2;
        this.mv.visitJumpInsn(opcode, (Label)var2_2);
        if (var1_1 == 167) {
            this.mySeenGoto = true;
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mv.visitFieldInsn(opcode, owner, name, descriptor);
        if (var1_1 == 178 && var2_2.equals("kotlin/Unit") && var3_3.equals("INSTANCE") && descriptor.equals("Lkotlin/Unit;")) {
            return;
        }
        this.setHasInstructions();
    }
}

