/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.IncludePatternsSection;
import com.intellij.rt.coverage.util.InstructionsSection;
import com.intellij.rt.coverage.util.PartlyAnalysedClassesSection;
import com.intellij.rt.coverage.util.ReportSection;
import com.intellij.rt.coverage.util.UncoveredBranchesSection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;

public class ReportSectionsUtil {
    public static final int UNCOVERED_BRANCHES_SECTION_ID = 1;
    public static final int INSTRUCTIONS_SECTION_ID = 2;
    public static final int PARTLY_ANALYSED_CLASSES_SECTION_ID = 3;
    public static final int INCLUDE_PATTERNS_SECTION_ID = 4;

    /*
     * WARNING - void declaration
     */
    private static Map<Integer, ReportSection> getSections(ProjectData projectData) {
        void var1_1;
        ProjectData projectData2;
        LinkedHashMap<Integer, ReportSection> result = new LinkedHashMap<Integer, ReportSection>();
        result.put(1, new UncoveredBranchesSection());
        result.put(2, new InstructionsSection(projectData2));
        result.put(3, new PartlyAnalysedClassesSection());
        result.put(4, new IncludePatternsSection());
        return var1_1;
    }

    public static void loadSections(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict) throws IOException {
        int numberOfSections = CoverageIOUtil.readINT(in);
        Map<Integer, ReportSection> sections = ReportSectionsUtil.getSections(projectData);
        for (int i = 0; i < numberOfSections; ++i) {
            int sectionId = CoverageIOUtil.readINT(in);
            int size = CoverageIOUtil.readINT(in);
            int version = CoverageIOUtil.readINT(in);
            ReportSection section = sections.get(sectionId);
            if (section != null) {
                if (version <= section.getVersion()) {
                    section.load(projectData, in, dict, version);
                    continue;
                }
                ErrorReporter.info("Section version " + version + " is greater than agent maximum support version " + section.getVersion() + "\nPlease try to update coverage agent.");
            } else {
                ErrorReporter.info("Unknown section id " + sectionId + ". Please try to update coverage agent.");
            }
            in.skipBytes(size);
        }
    }

    public static void saveSections(ProjectData projectData, DataOutputStream out, TObjectIntHashMap<String> dict, InstrumentationOptions options) throws IOException {
        Iterator iterator;
        List<ReportSection> sections = ReportSectionsUtil.getEngagedSections(projectData, options);
        CoverageIOUtil.writeINT(out, sections.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ReportSection reportSection = (ReportSection)iterator.next();
            reportSection.save(projectData, out, dict);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<ReportSection> getEngagedSections(ProjectData projectData, InstrumentationOptions options) {
        void var2_2;
        ArrayList<ReportSection> engagedSections = new ArrayList<ReportSection>();
        for (ReportSection section : ReportSectionsUtil.getSections(projectData).values()) {
            if (!section.isEngaged(projectData, options)) continue;
            engagedSections.add(section);
        }
        return var2_2;
    }
}

