/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.configuration;

import com.jetbrains.fus.reporting.FusHttpClient;
import com.jetbrains.fus.reporting.FusJsonSerializer;
import com.jetbrains.fus.reporting.configuration.ConfigurationClient;
import com.jetbrains.fus.reporting.configuration.LocalConfigurationClient;
import com.jetbrains.fus.reporting.configuration.RegionCode;
import com.jetbrains.fus.reporting.configuration.RemoteConfigurationClient;
import java.io.Reader;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/fus/reporting/configuration/ConfigurationClientFactory;", "", "()V", "Companion", "configuration"})
public final class ConfigurationClientFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final ConfigurationClient create(@NotNull String recorderId, @NotNull String productCode, @NotNull String productVersion, boolean isTestConfiguration, @NotNull FusHttpClient httpClient, @NotNull RegionCode regionCode, long cacheTimeoutMs, @NotNull FusJsonSerializer serializer) {
        return Companion.create(recorderId, productCode, productVersion, isTestConfiguration, httpClient, regionCode, cacheTimeoutMs, serializer);
    }

    @JvmStatic
    @NotNull
    public static final ConfigurationClient create(@NotNull Reader reader, @NotNull String productCode, @NotNull String productVersion, @NotNull FusJsonSerializer serializer) {
        return Companion.create(reader, productCode, productVersion, serializer);
    }

    @JvmStatic
    @NotNull
    public static final ConfigurationClient createTest(@NotNull String productCode, @NotNull String productVersion, @NotNull FusHttpClient httpClient, @NotNull String configurationUrl, long cacheTimeoutMs, @NotNull FusJsonSerializer serializer) {
        return Companion.createTest(productCode, productVersion, httpClient, configurationUrl, cacheTimeoutMs, serializer);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007JL\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0007JH\u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J:\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/fus/reporting/configuration/ConfigurationClientFactory$Companion;", "", "()V", "create", "Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "reader", "Ljava/io/Reader;", "productCode", "", "productVersion", "serializer", "Lcom/jetbrains/fus/reporting/FusJsonSerializer;", "recorderId", "isTestConfiguration", "", "httpClient", "Lcom/jetbrains/fus/reporting/FusHttpClient;", "regionCode", "Lcom/jetbrains/fus/reporting/configuration/RegionCode;", "cacheTimeoutMs", "", "createConfigurationClient", "createTest", "configurationUrl", "configuration"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ConfigurationClient create(@NotNull String recorderId, @NotNull String productCode, @NotNull String productVersion, boolean isTestConfiguration, @NotNull FusHttpClient httpClient, @NotNull RegionCode regionCode, long cacheTimeoutMs, @NotNull FusJsonSerializer serializer) {
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            Intrinsics.checkNotNullParameter((Object)productVersion, (String)"productVersion");
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Intrinsics.checkNotNullParameter((Object)((Object)regionCode), (String)"regionCode");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            return this.createConfigurationClient(recorderId, productCode, productVersion, isTestConfiguration, httpClient, regionCode, cacheTimeoutMs, serializer);
        }

        public static /* synthetic */ ConfigurationClient create$default(Companion companion, String string, String string2, String string3, boolean bl, FusHttpClient fusHttpClient, RegionCode regionCode, long l, FusJsonSerializer fusJsonSerializer, int n, Object object) {
            if ((n & 0x20) != 0) {
                regionCode = RegionCode.ALL;
            }
            if ((n & 0x40) != 0) {
                l = TimeUnit.MINUTES.toMillis(10L);
            }
            return companion.create(string, string2, string3, bl, fusHttpClient, regionCode, l, fusJsonSerializer);
        }

        private final ConfigurationClient createConfigurationClient(String recorderId, String productCode, String productVersion, boolean isTestConfiguration, FusHttpClient httpClient, RegionCode regionCode, long cacheTimeoutMs, FusJsonSerializer serializer) {
            String string;
            Object[] objectArray;
            String string2;
            if (isTestConfiguration) {
                string2 = regionCode.getEventLogSettingsURLTemplate();
                objectArray = new Object[]{"test/" + recorderId, productCode};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                string2 = regionCode.getEventLogSettingsURLTemplate();
                objectArray = new Object[]{recorderId, productCode};
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            }
            String configurationUrl = string;
            return new RemoteConfigurationClient(configurationUrl, productCode, productVersion, httpClient, serializer, cacheTimeoutMs);
        }

        @JvmStatic
        @NotNull
        public final ConfigurationClient create(@NotNull Reader reader, @NotNull String productCode, @NotNull String productVersion, @NotNull FusJsonSerializer serializer) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            Intrinsics.checkNotNullParameter((Object)productVersion, (String)"productVersion");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            return new LocalConfigurationClient(reader, productCode, productVersion, serializer);
        }

        @JvmStatic
        @NotNull
        public final ConfigurationClient createTest(@NotNull String productCode, @NotNull String productVersion, @NotNull FusHttpClient httpClient, @NotNull String configurationUrl, long cacheTimeoutMs, @NotNull FusJsonSerializer serializer) {
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            Intrinsics.checkNotNullParameter((Object)productVersion, (String)"productVersion");
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Intrinsics.checkNotNullParameter((Object)configurationUrl, (String)"configurationUrl");
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            return new RemoteConfigurationClient(configurationUrl, productCode, productVersion, httpClient, serializer, cacheTimeoutMs);
        }

        public static /* synthetic */ ConfigurationClient createTest$default(Companion companion, String string, String string2, FusHttpClient fusHttpClient, String string3, long l, FusJsonSerializer fusJsonSerializer, int n, Object object) {
            if ((n & 0x10) != 0) {
                l = TimeUnit.MINUTES.toMillis(10L);
            }
            return companion.createTest(string, string2, fusHttpClient, string3, l, fusJsonSerializer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

