/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.model.MavenSource;

public class MavenBuildBase
implements Serializable {
    private String myFinalName;
    private String myDefaultGoal;
    private String myDirectory;
    @NotNull
    private transient ReentrantReadWriteLock myLock;
    @NotNull
    private final @NotNull List<@NotNull String> myFilters;
    @NotNull
    private final @NotNull List<@NotNull MavenSource> myMavenSources;

    public MavenBuildBase() {
        this.myLock = new ReentrantReadWriteLock();
        this.myFilters = new ArrayList<String>();
        this.myMavenSources = new ArrayList<MavenSource>();
    }

    protected MavenBuildBase(@NotNull MavenBuildBase other) {
        if (other == null) {
            MavenBuildBase.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myFilters = new ArrayList<String>();
        this.myMavenSources = new ArrayList<MavenSource>();
        other.myLock.readLock().lock();
        try {
            this.myFinalName = other.myFinalName;
            this.myDefaultGoal = other.myDefaultGoal;
            this.myDirectory = other.myDirectory;
            this.myFilters.addAll(other.myFilters);
            this.myMavenSources.addAll(other.myMavenSources);
        }
        finally {
            other.myLock.readLock().unlock();
        }
    }

    public String getFinalName() {
        return this.myFinalName;
    }

    public void setFinalName(String finalName) {
        this.myFinalName = finalName;
    }

    public String getDefaultGoal() {
        return this.myDefaultGoal;
    }

    public void setDefaultGoal(String defaultGoal) {
        this.myDefaultGoal = defaultGoal;
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    public void setDirectory(String directory) {
        this.myDirectory = directory;
    }

    @NotNull
    public @NotNull List<@NotNull MavenResource> getResources() {
        List list = this.withReadLock(() -> this.myMavenSources.stream().filter(MavenSource::isResource).map(MavenResource::new).collect(Collectors.toList()));
        if (list == null) {
            MavenBuildBase.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setResources(@NotNull @NotNull List<@NotNull MavenResource> resources) {
        if (resources == null) {
            MavenBuildBase.$$$reportNull$$$0(2);
        }
        this.withWriteLock(() -> {
            this.myMavenSources.removeIf(MavenSource::isResource);
            ArrayList<MavenSource> converted = new ArrayList<MavenSource>(resources.size());
            for (MavenResource r : resources) {
                converted.add(MavenSource.fromResource(r, false));
            }
            this.myMavenSources.addAll(converted);
        });
    }

    @NotNull
    public @NotNull List<@NotNull MavenResource> getTestResources() {
        List list = this.withReadLock(() -> this.myMavenSources.stream().filter(MavenSource::isTestResource).map(MavenResource::new).collect(Collectors.toList()));
        if (list == null) {
            MavenBuildBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setTestResources(@NotNull @NotNull List<@NotNull MavenResource> testResources) {
        if (testResources == null) {
            MavenBuildBase.$$$reportNull$$$0(4);
        }
        this.withWriteLock(() -> {
            this.myMavenSources.removeIf(MavenSource::isTestResource);
            ArrayList<MavenSource> converted = new ArrayList<MavenSource>(testResources.size());
            for (MavenResource r : testResources) {
                converted.add(MavenSource.fromResource(r, true));
            }
            this.myMavenSources.addAll(converted);
        });
    }

    @NotNull
    public @NotNull List<@NotNull String> getSources() {
        List list = this.withReadLock(() -> this.myMavenSources.stream().filter(MavenSource::isSource).map(MavenSource::getDirectory).collect(Collectors.toList()));
        if (list == null) {
            MavenBuildBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void setSources(@NotNull @NotNull List<@NotNull String> sources) {
        if (sources == null) {
            MavenBuildBase.$$$reportNull$$$0(6);
        }
        this.withWriteLock(() -> {
            this.myMavenSources.removeIf(MavenSource::isSource);
            ArrayList<MavenSource> converted = new ArrayList<MavenSource>(sources.size());
            for (String s : sources) {
                converted.add(MavenSource.fromSrc(s, false));
            }
            this.myMavenSources.addAll(converted);
        });
    }

    @NotNull
    public @NotNull List<@NotNull String> getTestSources() {
        List list = this.withReadLock(() -> this.myMavenSources.stream().filter(MavenSource::isTestSource).map(MavenSource::getDirectory).collect(Collectors.toList()));
        if (list == null) {
            MavenBuildBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void setTestSources(@NotNull @NotNull List<@NotNull String> testSources) {
        if (testSources == null) {
            MavenBuildBase.$$$reportNull$$$0(8);
        }
        this.withWriteLock(() -> {
            this.myMavenSources.removeIf(MavenSource::isTestSource);
            ArrayList<MavenSource> converted = new ArrayList<MavenSource>(testSources.size());
            for (String s : testSources) {
                converted.add(MavenSource.fromSrc(s, true));
            }
            this.myMavenSources.addAll(converted);
        });
    }

    @NotNull
    public @NotNull List<@NotNull String> getFilters() {
        List list = this.withReadLock(() -> Collections.unmodifiableList(new ArrayList<String>(this.myFilters)));
        if (list == null) {
            MavenBuildBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void setFilters(@NotNull @NotNull List<@NotNull String> filters) {
        if (filters == null) {
            MavenBuildBase.$$$reportNull$$$0(10);
        }
        this.withWriteLock(() -> {
            this.myFilters.clear();
            this.myFilters.addAll(filters);
        });
    }

    @NotNull
    public @NotNull List<@NotNull MavenSource> getMavenSources() {
        List list = this.withReadLock(() -> new ArrayList<MavenSource>(this.myMavenSources));
        if (list == null) {
            MavenBuildBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void setMavenSources(@NotNull @NotNull List<@NotNull MavenSource> mavenSources) {
        if (mavenSources == null) {
            MavenBuildBase.$$$reportNull$$$0(12);
        }
        this.withWriteLock(() -> {
            this.myMavenSources.clear();
            this.myMavenSources.addAll(mavenSources);
        });
    }

    private <T> T withReadLock(@NotNull Supplier<T> supplier) {
        if (supplier == null) {
            MavenBuildBase.$$$reportNull$$$0(13);
        }
        this.myLock.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private void withWriteLock(@NotNull Runnable runnable) {
        if (runnable == null) {
            MavenBuildBase.$$$reportNull$$$0(14);
        }
        this.myLock.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private void readObject(@NotNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in == null) {
            MavenBuildBase.$$$reportNull$$$0(15);
        }
        in.defaultReadObject();
        this.myLock = new ReentrantReadWriteLock();
    }

    MavenBuildBase copy() {
        return new MavenBuildBase(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/model/MavenBuildBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testResources";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSources";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenSources";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/model/MavenBuildBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestResources";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSources";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setResources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTestResources";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSources";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTestSources";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setFilters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setMavenSources";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withReadLock";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withWriteLock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

