/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.JBRCrash;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PlatformUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\n\u0010\tR\u001a\u0010\f\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/diagnostic/ExceptionAutoReportUtil;", "", "<init>", "()V", "EA_AUTO_REPORT_OFFERED_PROPERTY", "", "autoReportIsForbiddenForProduct", "", "getAutoReportIsForbiddenForProduct", "()Z", "isAutoReportVisible", "isAutoReportVisible$annotations", "isAutoReportEnabled", "isAutoReportEnabled$annotations", "getConsentAndNeedsReconfirm", "Lkotlin/Pair;", "Lcom/intellij/ide/gdpr/Consent;", "shouldOfferEnablingAutoReport", "enablingAutoReportOffered", "", "autoReportEnabled", "isAutoReportableException", "message", "Lcom/intellij/diagnostic/AbstractMessage;", "getRelevantData", "Lcom/intellij/diagnostic/ITNReporter;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "isDefaultSubmitter", "submitter", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExceptionAutoReportUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionAutoReportUtil.kt\ncom/intellij/diagnostic/ExceptionAutoReportUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,106:1\n23#2:107\n*S KotlinDebug\n*F\n+ 1 ExceptionAutoReportUtil.kt\ncom/intellij/diagnostic/ExceptionAutoReportUtil\n*L\n43#1:107\n*E\n"})
public final class ExceptionAutoReportUtil {
    @NotNull
    public static final ExceptionAutoReportUtil INSTANCE = new ExceptionAutoReportUtil();
    @NotNull
    private static final String EA_AUTO_REPORT_OFFERED_PROPERTY = "ea.auto.report.offered";

    private ExceptionAutoReportUtil() {
    }

    public final boolean getAutoReportIsForbiddenForProduct() {
        return AppMode.isRemoteDevHost() || PlatformUtils.isJetBrainsClient() || !ApplicationInfoImpl.getShadowInstance().isVendorJetBrains();
    }

    public static final boolean isAutoReportVisible() {
        return !INSTANCE.getAutoReportIsForbiddenForProduct() && Registry.Companion.is("ea.auto.report.feature.visible", false);
    }

    @JvmStatic
    public static /* synthetic */ void isAutoReportVisible$annotations() {
    }

    public static final boolean isAutoReportEnabled() {
        if (!ExceptionAutoReportUtil.isAutoReportVisible()) {
            return false;
        }
        Pair<Consent, Boolean> pair = INSTANCE.getConsentAndNeedsReconfirm();
        Consent consent = (Consent)pair.component1();
        boolean needsReconfirm = (Boolean)pair.component2();
        Consent consent2 = consent;
        return (consent2 != null ? consent2.isAccepted() : false) && !needsReconfirm;
    }

    @JvmStatic
    public static /* synthetic */ void isAutoReportEnabled$annotations() {
    }

    private final Pair<Consent, Boolean> getConsentAndNeedsReconfirm() {
        Pair<List<Consent>, Boolean> pair = ConsentOptions.getInstance().getConsents(ConsentOptions.condEAAutoReportConsent());
        Intrinsics.checkNotNullExpressionValue(pair, (String)"getConsents(...)");
        Pair<List<Consent>, Boolean> pair2 = pair;
        List consents = (List)pair2.component1();
        Boolean needsReconfirm = (Boolean)pair2.component2();
        ExceptionAutoReportUtil $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(ExceptionAutoReportUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.assertTrue(consents.size() <= 1, () -> ExceptionAutoReportUtil.getConsentAndNeedsReconfirm$lambda$0(consents));
        Intrinsics.checkNotNull((Object)consents);
        return new Pair(CollectionsKt.firstOrNull((List)consents), (Object)needsReconfirm);
    }

    public final boolean shouldOfferEnablingAutoReport() {
        if (!ExceptionAutoReportUtil.isAutoReportVisible()) {
            return false;
        }
        Pair<Consent, Boolean> pair = this.getConsentAndNeedsReconfirm();
        Consent consent = (Consent)pair.component1();
        boolean needsReconfirm = (Boolean)pair.component2();
        if (consent == null) {
            return false;
        }
        if (consent.isAccepted() && !needsReconfirm) {
            return false;
        }
        if (!PropertiesComponent.getInstance().getBoolean(EA_AUTO_REPORT_OFFERED_PROPERTY, false)) {
            return true;
        }
        return !PropertiesComponent.getInstance().getBoolean("ea.auto.report.offered." + consent.getVersion(), false);
    }

    public final void enablingAutoReportOffered(boolean autoReportEnabled) {
        if (!ExceptionAutoReportUtil.isAutoReportVisible()) {
            return;
        }
        ConsentOptions.getInstance().setEAAutoReportAllowed(autoReportEnabled);
        PropertiesComponent.getInstance().setValue(EA_AUTO_REPORT_OFFERED_PROPERTY, true);
        Consent consent = (Consent)this.getConsentAndNeedsReconfirm().getFirst();
        if (consent != null) {
            PropertiesComponent.getInstance().setValue("ea.auto.report.offered." + consent.getVersion(), true);
        }
    }

    public final boolean isAutoReportableException(@NotNull AbstractMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.getRelevantData(message) != null;
    }

    @Nullable
    public final Pair<ITNReporter, IdeaPluginDescriptor> getRelevantData(@NotNull AbstractMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Throwable throwable = message.getThrowable();
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getThrowable(...)");
        Throwable throwable2 = throwable;
        if (throwable2 instanceof JBRCrash) {
            return null;
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginUtil.getInstance().findPluginId(message.getThrowable()));
        if (plugin != null && !PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)((PluginDescriptor)plugin)).isDevelopedByJetBrains()) {
            return null;
        }
        ErrorReportSubmitter submitter = DefaultIdeaErrorLogger.findSubmitter(throwable2, plugin);
        if (!(submitter instanceof ITNReporter) || !this.isDefaultSubmitter((ITNReporter)submitter)) {
            return null;
        }
        return new Pair((Object)submitter, (Object)plugin);
    }

    private final boolean isDefaultSubmitter(ITNReporter submitter) {
        return Intrinsics.areEqual(((Object)((Object)submitter)).getClass(), ITNReporter.class);
    }

    private static final String getConsentAndNeedsReconfirm$lambda$0(List $consents) {
        Intrinsics.checkNotNull((Object)$consents);
        return "Consent is expected to be bundled; multiple consents: " + CollectionsKt.joinToString$default((Iterable)$consents, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }
}

