/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.CallTreeNode;
import com.intellij.diagnostic.Freeze;
import com.intellij.diagnostic.FreezeNotifier;
import com.intellij.diagnostic.FreezeProfiler;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.IdeaFreezeReporter;
import com.intellij.diagnostic.IdeaFreezeReporterKt;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.PerformanceListener;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.PerformanceWatcherImplKt;
import com.intellij.diagnostic.SamplingTask;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.idea.AppMode;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.util.ApplicationKt;
import com.intellij.util.containers.UList;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ThreadInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u001a\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\f\u0010\u001c\u001a\u00020\u000e*\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002JB\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/diagnostic/IdeaFreezeReporter;", "Lcom/intellij/diagnostic/PerformanceListener;", "<init>", "()V", "dumpTask", "Lcom/intellij/diagnostic/SamplingTask;", "currentDumps", "", "Lcom/intellij/diagnostic/ThreadDump;", "kotlin.jvm.PlatformType", "", "stacktraceCommonPart", "Ljava/lang/StackTraceElement;", "appClosing", "", "uiFreezeStarted", "", "reportDir", "Ljava/nio/file/Path;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "dumpedThreads", "toFile", "dump", "uiFreezeFinished", "durationMs", "", "uiFreezeRecorded", "isValid", "reset", "createEvent", "Lcom/intellij/diagnostic/LogMessage;", "duration", "attachments", "Lcom/intellij/openapi/diagnostic/Attachment;", "performanceWatcher", "Lcom/intellij/diagnostic/PerformanceWatcher;", "finished", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeaFreezeReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaFreezeReporter.kt\ncom/intellij/diagnostic/IdeaFreezeReporter\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,545:1\n42#2,3:546\n1#3:549\n1#3:561\n1642#4,10:550\n1915#4:560\n1916#4:562\n1652#4:563\n1786#4,3:564\n1807#4,3:567\n*S KotlinDebug\n*F\n+ 1 IdeaFreezeReporter.kt\ncom/intellij/diagnostic/IdeaFreezeReporter\n*L\n56#1:546,3\n214#1:561\n214#1:550,10\n214#1:560\n214#1:562\n214#1:563\n216#1:564,3\n240#1:567,3\n*E\n"})
public final class IdeaFreezeReporter
implements PerformanceListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SamplingTask dumpTask;
    private final List<ThreadDump> currentDumps = Collections.synchronizedList(new ArrayList());
    @Nullable
    private List<StackTraceElement> stacktraceCommonPart;
    private volatile boolean appClosing;

    public IdeaFreezeReporter() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
        if (!IdeaFreezeReporterKt.access$getDEBUG$p() && (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) && !ApplicationManagerEx.isInIntegrationTest()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
        boolean $i$f$service = false;
        Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        BuildersKt.launch$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(app, this, null){
            int label;
            final /* synthetic */ Application $app;
            final /* synthetic */ IdeaFreezeReporter this$0;
            {
                this.$app = $app;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SimpleMessageBusConnection simpleMessageBusConnection = this.$app.getMessageBus().simpleConnect();
                        Topic topic = AppLifecycleListener.TOPIC;
                        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                        simpleMessageBusConnection.subscribe(topic, (Object)new AppLifecycleListener(){

                            public void appWillBeClosed(boolean isRestart) {
                                this$0.appClosing = true;
                            }
                        });
                        if (!IdeaFreezeReporterKt.access$getDEBUG$p() && (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) && !ApplicationManagerEx.isInIntegrationTest()) return Unit.INSTANCE;
                        this.label = 1;
                        Object object2 = IdeaFreezeReporterKt.access$reportUnfinishedFreezes((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void uiFreezeStarted(@NotNull Path reportDir, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        if (IdeaFreezeReporterKt.access$getDEBUG$p() || !DebugAttachDetector.isAttached()) {
            SamplingTask samplingTask = this.dumpTask;
            if (samplingTask != null) {
                samplingTask.stop();
            }
            this.reset();
            PerformanceWatcher watcher = PerformanceWatcher.Companion.getInstance();
            int maxDumpDuration = watcher.getMaxDumpDuration();
            if (maxDumpDuration == 0) {
                return;
            }
            this.dumpTask = new SamplingTask(maxDumpDuration, coroutineScope, reportDir){
                private final AtomicBoolean stopped;
                final /* synthetic */ Path $reportDir;
                {
                    this.$reportDir = $reportDir;
                    super(100, $maxDumpDuration, $coroutineScope);
                    this.stopped = new AtomicBoolean();
                }

                public void stop() {
                    super.stop();
                    if (this.stopped.compareAndSet(false, true)) {
                        IdeaFreezeReporterKt.access$getEP_NAME$p().forEachExtensionSafe(arg_0 -> uiFreezeStarted.1.stop$lambda$1(arg_0 -> uiFreezeStarted.1.stop$lambda$0(this.$reportDir, arg_0), arg_0));
                    }
                }

                /*
                 * Unable to fully structure code
                 */
                public Object stopDumpingThreads(Continuation<? super Unit> $completion) {
                    if (!($completion instanceof uiFreezeStarted.stopDumpingThreads.1)) ** GOTO lbl-1000
                    var3_2 = $completion;
                    if ((var3_2.label & -2147483648) != 0) {
                        var3_2.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            /* synthetic */ Object result;
                            final /* synthetic */ uiFreezeStarted.1 this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.stopDumpingThreads((Continuation<? super Unit>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $continuation.label = 1;
                            v0 = super.stopDumpingThreads((Continuation<? super Unit>)$continuation);
                            if (v0 == var4_4) {
                                return var4_4;
                            }
                            ** GOTO lbl20
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl20:
                            // 2 sources

                            if (this.stopped.compareAndSet(false, true)) {
                                IdeaFreezeReporterKt.access$getEP_NAME$p().forEachExtensionSafe((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, stopDumpingThreads$lambda$3(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stopDumpingThreads$lambda$2(java.nio.file.Path com.intellij.diagnostic.FreezeProfiler ), (Lcom/intellij/diagnostic/FreezeProfiler;)Lkotlin/Unit;)((Path)this.$reportDir)));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                private static final Unit stop$lambda$0(Path $reportDir, FreezeProfiler it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.stop($reportDir);
                    return Unit.INSTANCE;
                }

                private static final void stop$lambda$1(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }

                private static final Unit stopDumpingThreads$lambda$2(Path $reportDir, FreezeProfiler it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.stop($reportDir);
                    return Unit.INSTANCE;
                }

                private static final void stopDumpingThreads$lambda$3(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            };
            IdeaFreezeReporterKt.access$getEP_NAME$p().forEachExtensionSafe(arg_0 -> IdeaFreezeReporter.uiFreezeStarted$lambda$1(arg_0 -> IdeaFreezeReporter.uiFreezeStarted$lambda$0(reportDir, arg_0), arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpedThreads(@NotNull Path toFile, @NotNull ThreadDump dump) {
        Intrinsics.checkNotNullParameter((Object)toFile, (String)"toFile");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        SamplingTask samplingTask = this.dumpTask;
        if (samplingTask == null) {
            return;
        }
        SamplingTask dumpTask = samplingTask;
        this.currentDumps.add(dump);
        StackTraceElement[] edtStack = dump.getEDTStackTrace();
        if (edtStack != null) {
            List<StackTraceElement> list2;
            if (this.stacktraceCommonPart == null) {
                StackTraceElement[] stackTraceElementArray = edtStack;
                list2 = List.of(Arrays.copyOf(stackTraceElementArray, stackTraceElementArray.length));
            } else {
                List<StackTraceElement> list3 = this.stacktraceCommonPart;
                Intrinsics.checkNotNull(list3);
                list2 = PerformanceWatcherImplKt.getStacktraceCommonPart(list3, edtStack);
            }
            this.stacktraceCommonPart = list2;
        }
        Path dir = toFile.getParent();
        PerformanceWatcher performanceWatcher = PerformanceWatcher.Companion.getInstance();
        long duration2 = dumpTask.getTotalTime() + (long)performanceWatcher.getUnresponsiveInterval();
        LogMessage logMessage = this.createEvent(dumpTask, duration2, CollectionsKt.emptyList(), dir, performanceWatcher, false);
        if (logMessage == null) {
            return;
        }
        LogMessage event = logMessage;
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.writeString(dir.resolve(".message"), (CharSequence)event.getMessage(), new OpenOption[0]);
            Object object = new ObjectOutputStream(Files.newOutputStream(dir.resolve(".throwable"), new OpenOption[0]));
            Throwable throwable = null;
            try {
                ObjectOutputStream it = (ObjectOutputStream)object;
                boolean bl = false;
                it.writeObject(event.getThrowable());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = dir.resolve(".appinfo");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resolve(...)");
            Companion.saveAppInfo$intellij_platform_ide_impl((Path)object, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void uiFreezeFinished(long durationMs, @Nullable Path reportDir) {
        block1: {
            SamplingTask samplingTask = this.dumpTask;
            if (samplingTask == null) {
                return;
            }
            samplingTask.stop();
            Path path = reportDir;
            if (path == null) break block1;
            Path it = path;
            boolean bl = false;
            IdeaFreezeReporterKt.access$cleanup(it);
        }
    }

    public void uiFreezeRecorded(long durationMs, @Nullable Path reportDir) {
        Collection collection;
        SamplingTask dumpTask = this.dumpTask;
        if (dumpTask == null) {
            return;
        }
        if (Registry.Companion.is("freeze.reporter.enabled", false) && ((int)(durationMs / (long)1000) > 10 || ApplicationManagerEx.isInIntegrationTest()) && !((collection = (Collection)this.stacktraceCommonPart) == null || collection.isEmpty())) {
            ArrayList dumps = new ArrayList(this.currentDumps);
            if (this.isValid(dumpTask) && dumps.size() >= 2) {
                LogMessage loggingEvent;
                ArrayList attachments = new ArrayList();
                IdeaFreezeReporterKt.access$addDumpsAttachments(dumps, IdeaFreezeReporter::uiFreezeRecorded$lambda$0, attachments);
                if (reportDir != null) {
                    IdeaFreezeReporterKt.access$getEP_NAME$p().forEachExtensionSafe(arg_0 -> IdeaFreezeReporter.uiFreezeRecorded$lambda$2(arg_0 -> IdeaFreezeReporter.uiFreezeRecorded$lambda$1(attachments, reportDir, arg_0), arg_0));
                }
                if ((loggingEvent = this.createEvent(dumpTask, durationMs, attachments, reportDir, PerformanceWatcher.Companion.getInstance(), true)) != null && (ApplicationKt.getApplication().isEAP() || ApplicationKt.getApplication().isInternal())) {
                    Companion.report$intellij_platform_ide_impl(loggingEvent);
                }
                if (reportDir != null && loggingEvent != null && !((Collection)dumps).isEmpty()) {
                    for (FreezeNotifier notifier : IdeaFreezeReporterKt.access$getFREEZE_NOTIFIER_EP$p().getExtensionList()) {
                        notifier.notifyFreeze(loggingEvent, dumps, reportDir, durationMs);
                    }
                }
            }
        }
        this.dumpTask = null;
        this.reset();
    }

    private final boolean isValid(SamplingTask $this$isValid) {
        return UList.getSize-impl((Object[])$this$isValid.getThreadInfos-8e-EdQE()) > 1000 / $this$isValid.dumpInterval;
    }

    private final void reset() {
        this.currentDumps.clear();
        this.stacktraceCommonPart = null;
    }

    /*
     * WARNING - void declaration
     */
    private final LogMessage createEvent(SamplingTask dumpTask, long duration2, List<Attachment> attachments, Path reportDir, PerformanceWatcher performanceWatcher, boolean finished) {
        double processCpuLoad;
        String edtNote;
        String reportText;
        boolean nonEdtCause;
        List<StackTraceElement> commonStack;
        int classLoadingRatio;
        boolean allInEdt;
        String jitProblem;
        List infos;
        block26: {
            block25: {
                boolean bl;
                block24: {
                    CallTreeNode commonStackNode;
                    boolean bl2;
                    List causeThreads;
                    block23: {
                        void $this$mapNotNullTo$iv$iv;
                        if (!this.isValid(dumpTask)) {
                            return null;
                        }
                        infos = UList.toList-impl((Object[])dumpTask.getThreadInfos-8e-EdQE());
                        Iterable $this$mapNotNull$iv = infos;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                            ThreadInfo it$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv;
                            boolean bl3 = false;
                            ThreadInfo[] it = (ThreadInfo[])element$iv$iv;
                            boolean bl4 = false;
                            if (IdeaFreezeReporterKt.access$getCauseThread(it) == null) continue;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        causeThreads = (List)destination$iv$iv;
                        jitProblem = performanceWatcher.getJitProblem();
                        Iterable $this$all$iv = causeThreads;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                ThreadInfo it = (ThreadInfo)element$iv;
                                boolean bl6 = false;
                                if (ThreadDumper.isEDT((ThreadInfo)it)) continue;
                                bl2 = false;
                                break block23;
                            }
                            bl2 = true;
                        }
                    }
                    allInEdt = bl2;
                    CallTreeNode root = IdeaFreezeReporterKt.access$buildTree(causeThreads, dumpTask.dumpInterval);
                    classLoadingRatio = IdeaFreezeReporterKt.access$countClassLoading(causeThreads) * 100 / causeThreads.size();
                    CallTreeNode callTreeNode = commonStackNode = root.findDominantCommonStack((long)((double)(causeThreads.size() * dumpTask.dumpInterval) * 0.25));
                    commonStack = callTreeNode != null ? callTreeNode.getStack() : null;
                    nonEdtCause = false;
                    Collection bl6 = commonStack;
                    if (bl6 == null || bl6.isEmpty()) {
                        commonStack = this.stacktraceCommonPart;
                    } else {
                        CallTreeNode callTreeNode2 = commonStackNode;
                        Intrinsics.checkNotNull((Object)callTreeNode2);
                        ThreadInfo threadInfo = callTreeNode2.threadInfo;
                        Intrinsics.checkNotNull((Object)threadInfo);
                        nonEdtCause = !ThreadDumper.isEDT((ThreadInfo)threadInfo);
                    }
                    reportText = root.dump();
                    try {
                        if (reportDir != null) {
                            Files.createDirectories(reportDir, new FileAttribute[0]);
                            Files.writeString(reportDir.resolve("report.txt"), (CharSequence)reportText, new OpenOption[0]);
                        }
                    }
                    catch (IOException element$iv$iv$iv) {
                        // empty catch block
                    }
                    if ((element$iv$iv$iv = (Collection)commonStack) == null || element$iv$iv$iv.isEmpty()) break block25;
                    Iterable $this$any$iv = commonStack;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            StackTraceElement it = (StackTraceElement)element$iv;
                            boolean bl7 = false;
                            if (!IdeaFreezeReporterKt.access$skippedFrame(it)) continue;
                            bl = true;
                            break block24;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block26;
            }
            return null;
        }
        long durationInSeconds = duration2 / (long)1000;
        String string = edtNote = allInEdt ? "in EDT " : "";
        String message = "Freeze " + edtNote + "for " + durationInSeconds + " seconds\n" + (finished ? "" : (this.appClosing ? "IDE is closing. " : "IDE KILLED! ")) + "Sampled time: " + infos.size() * dumpTask.dumpInterval + "ms, sampling rate: " + dumpTask.dumpInterval + "ms";
        if (jitProblem != null) {
            message = message + ", " + jitProblem;
        }
        long total = dumpTask.getTotalTime();
        long gcTime = dumpTask.getGcTime();
        if (total > 0L) {
            message = message + ", GC time: " + gcTime + "ms (" + gcTime * (long)100 / total + "%), Class loading: " + classLoadingRatio + "%";
        }
        if (DebugAttachDetector.isDebugEnabled()) {
            message = message + ", debug agent: on";
        }
        if ((processCpuLoad = dumpTask.getProcessCpuLoad()) > 0.0) {
            message = message + ", CPU load: " + (int)(processCpuLoad * (double)100) + "%";
        }
        if (nonEdtCause) {
            message = message + "\n\nThe stack is from the thread that was blocking EDT";
        }
        Attachment report = IdeaFreezeReporterKt.access$createReportAttachment(durationInSeconds, reportText);
        return new LogMessage(new Freeze(commonStack), message, CollectionsKt.plus((Collection)attachments, (Object)report));
    }

    private static final Unit uiFreezeStarted$lambda$0(Path $reportDir, FreezeProfiler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.start($reportDir);
        return Unit.INSTANCE;
    }

    private static final void uiFreezeStarted$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final String uiFreezeRecorded$lambda$0(ThreadDump it) {
        String string = it.getRawDump();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawDump(...)");
        return string;
    }

    private static final Unit uiFreezeRecorded$lambda$1(ArrayList $attachments, Path $reportDir, FreezeProfiler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $attachments.addAll((Collection)it.getAttachments($reportDir));
        return Unit.INSTANCE;
    }

    private static final void uiFreezeRecorded$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diagnostic/IdeaFreezeReporter$Companion;", "", "<init>", "()V", "saveAppInfo", "", "appInfoFile", "Ljava/nio/file/Path;", "overwrite", "", "saveAppInfo$intellij_platform_ide_impl", "report", "event", "Lcom/intellij/diagnostic/LogMessage;", "report$intellij_platform_ide_impl", "checkProfilerCrash", "crashContent", "", "checkProfilerCrash$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void saveAppInfo$intellij_platform_ide_impl(@NotNull Path appInfoFile, boolean overwrite) {
            Intrinsics.checkNotNullParameter((Object)appInfoFile, (String)"appInfoFile");
            if (overwrite || !Files.exists(appInfoFile, new LinkOption[0])) {
                Files.createDirectories(appInfoFile.getParent(), new FileAttribute[0]);
                Files.writeString(appInfoFile, (CharSequence)ITNProxy.getAppInfoString(), new OpenOption[0]);
            }
        }

        public final void report$intellij_platform_ide_impl(@NotNull LogMessage event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginUtil.getInstance().findPluginId(event.getThrowable()));
            if (plugin == null || PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)((PluginDescriptor)plugin))) {
                MessagePool.getInstance().addIdeFatalMessage(event);
            }
        }

        public final void checkProfilerCrash$intellij_platform_ide_impl(@NotNull String crashContent) {
            Intrinsics.checkNotNullParameter((Object)crashContent, (String)"crashContent");
            IdeaFreezeReporterKt.access$getEP_NAME$p().forEachExtensionSafe(arg_0 -> Companion.checkProfilerCrash$lambda$1(arg_0 -> Companion.checkProfilerCrash$lambda$0(crashContent, arg_0), arg_0));
        }

        private static final Unit checkProfilerCrash$lambda$0(String $crashContent, FreezeProfiler it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.checkCrash($crashContent);
            return Unit.INSTANCE;
        }

        private static final void checkProfilerCrash$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

